/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.annotation.factory.javassist;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationDefaultAttribute;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.MemberValue;
import javassist.scopedpool.ScopedClassPoolRepository;
import javassist.scopedpool.ScopedClassPoolRepositoryImpl;
import org.jboss.annotation.factory.AnnotationValidationException;
import org.jboss.annotation.factory.AnnotationValidator;
import org.jboss.annotation.factory.javassist.MemberValueGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValueAnnotationValidator
implements AnnotationValidator {
    ScopedClassPoolRepository repository = ScopedClassPoolRepositoryImpl.getInstance();

    @Override
    public void validate(Map<String, Object> map, Class<?> annotation) {
        ArrayList<String> notAssignedAttributes = null;
        CtClass ctClass = null;
        Method[] methods = this.getDeclaredMethods(annotation);
        for (int i = 0; i < methods.length; ++i) {
            CtMethod method;
            if (map.get(methods[i].getName()) != null) continue;
            if (ctClass == null) {
                ctClass = this.getCtClass(annotation);
            }
            try {
                method = ctClass.getDeclaredMethod(methods[i].getName());
            }
            catch (NotFoundException e) {
                throw new RuntimeException("Unable to find method " + methods[i].getName() + " for " + annotation.getName());
            }
            Object defaultValue = null;
            MethodInfo minfo = method.getMethodInfo2();
            AnnotationDefaultAttribute defAttr = (AnnotationDefaultAttribute)minfo.getAttribute("AnnotationDefault");
            if (defAttr != null) {
                MemberValue value = defAttr.getDefaultValue();
                MemberValueGetter getter = new MemberValueGetter(methods[i]);
                value.accept(getter);
                defaultValue = getter.getValue();
            }
            if (defaultValue != null) {
                map.put(methods[i].getName(), defaultValue);
                continue;
            }
            if (notAssignedAttributes == null) {
                notAssignedAttributes = new ArrayList<String>();
            }
            notAssignedAttributes.add(methods[i].getName());
        }
        if (notAssignedAttributes != null) {
            throw new AnnotationValidationException("Unable to fill in default attributes for " + annotation + " " + notAssignedAttributes);
        }
    }

    CtClass getCtClass(Class<?> clazz) {
        try {
            ClassPool pool = this.repository.findClassPool(clazz.getClassLoader());
            return pool.get(clazz.getName());
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Unable to load CtClass for " + clazz, e);
        }
    }

    private Method[] getDeclaredMethods(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        });
    }
}

