/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util.logging;

import org.jboss.logging.LoggerPlugin;
import org.jboss.logging.LoggerPluginInstance;
import org.jboss.logging.NullLoggerPluginInstance;

public class SystemOutLoggerPlugin
implements LoggerPlugin {
    private static final String WARN = "[aop-warn]";
    private static final String TRACE = "[aop-trace]";
    private static final String INFO = "[aop-info]";
    private static final String FATAL = "[aop-fatal]";
    private static final String ERROR = "[aop-error]";
    private static final String DEBUG = "[aop-debug]";
    String name;

    public LoggerPluginInstance getInstance(String name, String resourceBundleName) {
        return new NullLoggerPluginInstance(name, (LoggerPlugin)this);
    }

    public void debug(Object message) {
        this.print(DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.print(DEBUG, message, t);
    }

    public void debug(String loggerFcqn, Object message, Throwable t) {
        this.print("[aop-debug] " + loggerFcqn, message, t);
    }

    public void error(Object message) {
        this.print(ERROR, message, null);
    }

    public void error(Object message, Throwable t) {
        this.print(ERROR, message, t);
    }

    public void error(String loggerFcqn, Object message, Throwable t) {
        this.print("[aop-error] " + loggerFcqn, message, t);
    }

    public void fatal(Object message) {
        this.print(FATAL, message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.print(FATAL, message, t);
    }

    public void fatal(String loggerFcqn, Object message, Throwable t) {
        this.print("[aop-fatal] " + loggerFcqn, message, t);
    }

    public void info(Object message) {
        this.print(INFO, message, null);
    }

    public void info(Object message, Throwable t) {
        this.print(INFO, message, t);
    }

    public void info(String loggerFcqn, Object message, Throwable t) {
        this.print("[aop-info] " + loggerFcqn, message, t);
    }

    public void init(String name) {
        this.name = name;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public void trace(Object message) {
        this.print(TRACE, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.print(TRACE, message, null);
    }

    public void trace(String loggerFcqn, Object message, Throwable t) {
        this.print("[aop-trace] " + loggerFcqn, message, t);
    }

    public void warn(Object message) {
        this.print(WARN, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.print(WARN, message, null);
    }

    public void warn(String loggerFcqn, Object message, Throwable t) {
        this.print("[aop-warn] " + loggerFcqn, message, t);
    }

    private void print(String prefix, Object message, Throwable t) {
        System.out.println(prefix + " " + this.name + " " + message);
        if (t != null) {
            t.printStackTrace(System.out);
        }
    }
}

