/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.classpool;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javassist.ClassPool;
import javassist.scopedpool.ScopedClassPool;
import javassist.scopedpool.ScopedClassPoolFactory;
import javassist.scopedpool.ScopedClassPoolRepository;
import javassist.scopedpool.ScopedClassPoolRepositoryImpl;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.SecurityActions;
import org.jboss.aop.classpool.AOPClassPoolFactory;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AOPClassPoolRepository
implements ScopedClassPoolRepository {
    private static final Logger logger = Logger.getLogger(AOPClassPoolRepository.class);
    private static final AOPClassPoolRepository instance = new AOPClassPoolRepository();
    protected final HashMap<ClassLoader, HashSet<Class<?>>> ucl2classes = new HashMap();
    AspectManager manager;
    ScopedClassPoolRepository delegate = ScopedClassPoolRepositoryImpl.getInstance();

    public static AOPClassPoolRepository getInstance() {
        return instance;
    }

    private AOPClassPoolRepository() {
        this.delegate.setClassPoolFactory((ScopedClassPoolFactory)new AOPClassPoolFactory());
    }

    public void setClassPoolFactory(ScopedClassPoolFactory factory) {
        this.delegate.setClassPoolFactory(factory);
    }

    public ScopedClassPoolFactory getClassPoolFactory() {
        return this.delegate.getClassPoolFactory();
    }

    public boolean isPrune() {
        return this.delegate.isPrune();
    }

    public void setPrune(boolean prune) {
        this.delegate.setPrune(prune);
    }

    public ScopedClassPool createScopedClassPool(ClassLoader cl, ClassPool src) {
        return this.delegate.createScopedClassPool(cl, src);
    }

    public ClassPool findClassPool(ClassLoader cl) {
        return this.delegate.findClassPool(cl);
    }

    public void setAspectManager(AspectManager manager) {
        this.manager = manager;
    }

    public Map<ClassLoader, ClassPool> getRegisteredCLs() {
        return this.delegate.getRegisteredCLs();
    }

    public void clearUnregisteredClassLoaders() {
        this.delegate.clearUnregisteredClassLoaders();
    }

    public ClassPool registerClassLoader(ClassLoader ucl) {
        return this.delegate.registerClassLoader(ucl);
    }

    public void unregisterClassLoader(ClassLoader cl) {
        this.delegate.unregisterClassLoader(cl);
    }

    public void registerClass(Class<?> clazz) {
        ClassLoader classLoader = SecurityActions.getClassLoader(clazz);
        HashSet<Class<Object>> classes = this.ucl2classes.get(classLoader);
        if (classes == null) {
            classes = new HashSet();
            this.ucl2classes.put(classLoader, classes);
        }
        classes.add(clazz);
    }

    public void perfomUnregisterClassLoader(ClassLoader cl) {
        if (System.getSecurityManager() == null) {
            UnregisterClassLoaderAction.NON_PRIVILEGED.unregister(this, cl);
        } else {
            UnregisterClassLoaderAction.PRIVILEGED.unregister(this, cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnregisterClassLoader(ClassLoader cl) {
        Map map = this.delegate.getRegisteredCLs();
        synchronized (map) {
            HashSet<Class<?>> classes = this.ucl2classes.remove(cl);
            if (classes != null) {
                for (Class<?> clazz : classes) {
                    Map<Class<?>, WeakReference<Advisor>> map2 = this.manager.getAdvisors();
                    synchronized (map2) {
                        WeakReference<Advisor> ref = this.manager.getAdvisors().get(clazz);
                        if (ref != null) {
                            Advisor advisor = (Advisor)ref.get();
                            this.manager.getAdvisors().remove(clazz);
                            if (advisor != null) {
                                advisor.cleanup();
                            }
                        }
                        Class<?> advisedClass = clazz;
                        try {
                            Field f = advisedClass.getDeclaredField("aop$classAdvisor$aop");
                            f.setAccessible(true);
                            f.set(null, null);
                        }
                        catch (NoSuchFieldException e) {
                            logger.warn((Object)("Error unsetting advisor for " + advisedClass.getName() + " " + e));
                        }
                        catch (IllegalAccessException e) {
                            logger.warn((Object)("Error unsetting advisor for " + advisedClass.getName() + " " + e));
                        }
                    }
                }
            }
        }
    }

    static interface UnregisterClassLoaderAction {
        public static final UnregisterClassLoaderAction PRIVILEGED = new UnregisterClassLoaderAction(){

            public void unregister(final AOPClassPoolRepository repository, final ClassLoader loader) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() {
                            repository.doUnregisterClassLoader(loader);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
        public static final UnregisterClassLoaderAction NON_PRIVILEGED = new UnregisterClassLoaderAction(){

            public void unregister(AOPClassPoolRepository repository, ClassLoader loader) {
                repository.doUnregisterClassLoader(loader);
            }
        };

        public void unregister(AOPClassPoolRepository var1, ClassLoader var2);
    }
}

