/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.Constructor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.instrument.ClassicInstrumentor;
import org.jboss.aop.instrument.DynamicTransformationObserver;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.InstrumentorEnum;
import org.jboss.aop.instrument.JoinpointClassifier;
import org.jboss.aop.instrument.SecurityActions;
import org.jboss.logging.Logger;

public class InstrumentorFactory {
    private static final Logger logger = Logger.getLogger(InstrumentorFactory.class);
    protected static InstrumentorEnum instrumentor;
    protected static Constructor<?> otherInstrumentorConstructor;
    private static final Class<?>[] CONSTRUCTOR_SIG;

    public static void initialise(String property) {
        if (AspectManager.verbose && logger.isDebugEnabled()) {
            logger.debug((Object)("Passed in instrumentor: " + property));
        }
        if (property != null) {
            if (property.equals(ClassicInstrumentor.class.getName())) {
                instrumentor = InstrumentorEnum.CLASSIC;
            } else if (property.equals(GeneratedAdvisorInstrumentor.class.getName())) {
                instrumentor = InstrumentorEnum.GENERATED_ADVISOR;
            } else {
                try {
                    Class<?> otherInstrumentorClass = SecurityActions.getContextClassLoader().loadClass(property);
                    otherInstrumentorConstructor = otherInstrumentorClass.getConstructor(CONSTRUCTOR_SIG);
                    instrumentor = InstrumentorEnum.OTHER_INSTRUMENTOR;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Invalid instrumentor " + property + " was used");
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(property + " does not have a constructor with the expected signature");
                }
            }
        } else {
            instrumentor = InstrumentorEnum.GENERATED_ADVISOR;
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug((Object)("Defaulting instrumentor to: " + InstrumentorFactory.getInstrumentorName()));
            }
        }
    }

    public static InstrumentorEnum getInstrumentor() {
        return instrumentor;
    }

    public static Instrumentor getInstrumentor(AOPClassPool pool, AspectManager manager, JoinpointClassifier joinpointClassifier, DynamicTransformationObserver observer) {
        if (instrumentor == InstrumentorEnum.CLASSIC) {
            return new ClassicInstrumentor(pool, manager, joinpointClassifier, observer);
        }
        if (instrumentor == InstrumentorEnum.GENERATED_ADVISOR) {
            return new GeneratedAdvisorInstrumentor(pool, manager, joinpointClassifier, observer);
        }
        if (otherInstrumentorConstructor != null) {
            try {
                return (Instrumentor)otherInstrumentorConstructor.newInstance(new Object[]{pool, manager, joinpointClassifier, observer});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Instrumentor is not set");
    }

    public static Instrumentor getInstrumentor(AspectManager manager, JoinpointClassifier joinpointClassifier) {
        if (instrumentor == InstrumentorEnum.CLASSIC) {
            return new ClassicInstrumentor(manager, joinpointClassifier);
        }
        if (instrumentor == InstrumentorEnum.GENERATED_ADVISOR) {
            return new GeneratedAdvisorInstrumentor(manager, joinpointClassifier);
        }
        throw new RuntimeException("Instrumentor is not set");
    }

    public static String getInstrumentorName() {
        if (instrumentor == InstrumentorEnum.CLASSIC) {
            return ClassicInstrumentor.class.getName();
        }
        if (instrumentor == InstrumentorEnum.GENERATED_ADVISOR) {
            return GeneratedAdvisorInstrumentor.class.getName();
        }
        if (instrumentor == InstrumentorEnum.OTHER_INSTRUMENTOR) {
            return otherInstrumentorConstructor.getName();
        }
        throw new RuntimeException("Instrumentor is not set");
    }

    static {
        CONSTRUCTOR_SIG = new Class[]{AOPClassPool.class, AspectManager.class, JoinpointClassifier.class, DynamicTransformationObserver.class};
    }
}

