/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.classloader;

import java.lang.reflect.Method;
import java.net.URL;
import junit.textui.TestRunner;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.classloader.UserDefinedCL;

public class UserDefinedCLTestCase
extends AOPTestWithSetup {
    private URL jarURL;
    private static final String USER_DEFINED_PACKAGE = UserDefinedCLTestCase.class.getPackage().getName() + ".scenario";
    private static final String POJO_CLASS = USER_DEFINED_PACKAGE + ".POJO";
    private static final String INTERCEPTOR_CLASS = USER_DEFINED_PACKAGE + ".POJOInterceptor";
    private static final String SCENARIO_TO_LOAD = "/target/test-classes/org/jboss/test/aop/classloader/scenario.jar";

    public UserDefinedCLTestCase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(UserDefinedCLTestCase.class);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.jarURL = this.getURLRelativeToProjectRoot(SCENARIO_TO_LOAD);
    }

    public void testURLLoadedInterception() throws Exception {
        Thread currentThread = Thread.currentThread();
        UserDefinedCL classLoader = new UserDefinedCL(this.jarURL, currentThread.getContextClassLoader());
        currentThread.setContextClassLoader(classLoader);
        Class<?> clazz = Class.forName(INTERCEPTOR_CLASS, false, classLoader);
        AdviceBinding binding = new AdviceBinding("userdefinedclbinding", "execution(* *->*(..))", null);
        binding.addInterceptor(clazz);
        AspectManager.instance().addBinding(binding);
        Method resetStatus = clazz.getDeclaredMethod("resetInvokeStatus", new Class[0]);
        Method getStatus = clazz.getDeclaredMethod("getInvoked", new Class[0]);
        Class<?> pojoClass = Class.forName(POJO_CLASS, false, classLoader);
        Object pojoInstance = pojoClass.newInstance();
        resetStatus.invoke(null, new Object[0]);
        Method pojoMethod = pojoClass.getDeclaredMethod("execute", new Class[0]);
        pojoMethod.invoke(pojoInstance, new Object[0]);
        UserDefinedCLTestCase.assertTrue((boolean)((Boolean)getStatus.invoke(null, new Object[0])));
    }
}

