/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.jdk15.dynamic.common;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.instrument.ConstructorExecutionTransformer;
import org.jboss.aop.joinpoint.InvocationBase;

public class POJOWrappingInfo {
    private boolean constructorWrapped;
    private boolean fieldReadWrapped;
    private boolean fieldWriteWrapped;
    private boolean methodWrapped;

    public POJOWrappingInfo() {
    }

    public POJOWrappingInfo(CtClass pojoClass, CtField field, CtMethod method, String notAdvisedMethod, CtClass pojoClient) throws CannotCompileException, NotFoundException {
        String fieldWrapper;
        this.constructorWrapped = true;
        this.fieldReadWrapped = true;
        this.fieldWriteWrapped = true;
        this.methodWrapped = false;
        if (pojoClass.isFrozen()) {
            pojoClass.defrost();
        }
        method.instrument((ExprEditor)new POJOMethodIntrospector(notAdvisedMethod));
        if (pojoClient.isFrozen()) {
            pojoClient.defrost();
        }
        pojoClient.instrument((ExprEditor)new POJOClientIntrospector());
        if (this.constructorWrapped) {
            String constructorWrapper = ConstructorExecutionTransformer.constructorFactory((String)pojoClass.getSimpleName());
            boolean bl = this.constructorWrapped = !this.isWrapperEmpty(pojoClass, constructorWrapper);
        }
        if (this.fieldReadWrapped) {
            fieldWrapper = field.getName() + "_r_" + "$aop";
            boolean bl = this.fieldReadWrapped = !this.isWrapperEmpty(pojoClass, fieldWrapper);
        }
        if (this.fieldWriteWrapped) {
            fieldWrapper = field.getName() + "_w_" + "$aop";
            this.fieldWriteWrapped = !this.isWrapperEmpty(pojoClass, fieldWrapper);
        }
    }

    private boolean isWrapperEmpty(CtClass pojoClass, String wrapperName) throws CannotCompileException {
        CtMethod wrapper;
        try {
            wrapper = pojoClass.getDeclaredMethod(wrapperName);
        }
        catch (NotFoundException e) {
            return true;
        }
        WrapperIntrospector introspector = new WrapperIntrospector();
        wrapper.instrument((ExprEditor)introspector);
        return introspector.wrapperEmpty;
    }

    public boolean isConstructorWrapped() {
        return this.constructorWrapped;
    }

    public boolean isFieldReadWrapped() {
        return this.fieldReadWrapped;
    }

    public boolean isFieldWriteWrapped() {
        return this.fieldWriteWrapped;
    }

    public boolean isMethodWrapped() {
        return this.methodWrapped;
    }

    private class WrapperIntrospector
    extends ExprEditor {
        boolean wrapperEmpty = true;

        private WrapperIntrospector() {
        }

        public void edit(MethodCall call) {
            if (call.getClassName().equals(ClassAdvisor.class.getName()) || call.getClassName().equals(InvocationBase.class.getName())) {
                this.wrapperEmpty = false;
            }
        }
    }

    private class POJOClientIntrospector
    extends ExprEditor {
        private POJOClientIntrospector() {
        }

        public void edit(NewExpr newExpr) {
            if (newExpr.getClassName().equals(((Object)((Object)this)).getClass().getPackage().getName() + "scenario.POJO")) {
                POJOWrappingInfo.this.constructorWrapped = false;
            }
        }

        public void edit(FieldAccess fieldAccess) {
            if (fieldAccess.getFieldName().equals("counter") && fieldAccess.getClassName().equals(((Object)((Object)this)).getClass().getPackage().getName() + "scenario.POJO")) {
                if (fieldAccess.isReader()) {
                    POJOWrappingInfo.this.fieldReadWrapped = false;
                } else {
                    POJOWrappingInfo.this.fieldWriteWrapped = false;
                }
            }
        }
    }

    private class POJOMethodIntrospector
    extends ExprEditor {
        private String notAdvisedMethod;

        public POJOMethodIntrospector(String notAdvisedMethod) {
            this.notAdvisedMethod = notAdvisedMethod;
        }

        public void edit(MethodCall methodCall) throws CannotCompileException {
            if (methodCall.where().getName().endsWith("$aop")) {
                return;
            }
            if (methodCall.getClassName().equals(((Object)((Object)this)).getClass().getPackage().getName() + ".scenario.POJO") && methodCall.getMethodName().equals(this.notAdvisedMethod)) {
                POJOWrappingInfo.this.methodWrapped = true;
            }
        }
    }
}

