/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.scope;

import java.lang.reflect.Method;
import java.util.ArrayList;
import junit.textui.TestRunner;
import org.jboss.aop.Advised;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.MethodHashing;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.scope.CallingPOJO;
import org.jboss.test.aop.scope.CopyPOJOWithMixedChains;
import org.jboss.test.aop.scope.Interceptions;
import org.jboss.test.aop.scope.POJO2WithAspect;
import org.jboss.test.aop.scope.POJO2WithAspectFactory;
import org.jboss.test.aop.scope.POJO2WithInterceptor;
import org.jboss.test.aop.scope.POJO2WithInterceptorFactory;
import org.jboss.test.aop.scope.POJOWithAspect;
import org.jboss.test.aop.scope.POJOWithAspectFactory;
import org.jboss.test.aop.scope.POJOWithInterceptor;
import org.jboss.test.aop.scope.POJOWithInterceptorFactory;
import org.jboss.test.aop.scope.POJOWithMixedChains;
import org.jboss.test.aop.scope.POJOWithNullAspect;
import org.jboss.test.aop.scope.PerClassAspect;
import org.jboss.test.aop.scope.PerClassJoinpointInterceptor;
import org.jboss.test.aop.scope.PerInstanceAspect;
import org.jboss.test.aop.scope.PerJoinpointInterceptor;
import org.jboss.test.aop.scope.PerVmInterceptor;

public class ScopeTestCase
extends AOPTestWithSetup {
    static final String[] staticNames = new String[]{PerJoinpointInterceptor.class.getName(), PerVmInterceptor.class.getName(), PerClassAspect.class.getName(), PerClassJoinpointInterceptor.class.getName()};
    static final String[] nonStaticNames = new String[]{PerJoinpointInterceptor.class.getName(), PerVmInterceptor.class.getName(), PerClassAspect.class.getName(), PerClassJoinpointInterceptor.class.getName(), PerInstanceAspect.class.getName()};
    static final String[] staticAndConstructionNames = new String[]{PerJoinpointInterceptor.class.getName(), PerVmInterceptor.class.getName(), PerClassAspect.class.getName(), PerClassJoinpointInterceptor.class.getName(), PerJoinpointInterceptor.class.getName(), PerVmInterceptor.class.getName(), PerClassAspect.class.getName(), PerClassJoinpointInterceptor.class.getName(), PerInstanceAspect.class.getName()};

    public static void main(String[] args) {
        TestRunner.run(ScopeTestCase.class);
    }

    public ScopeTestCase(String arg0) {
        super(arg0);
    }

    public void testSimplePerVmAspect() {
        Interceptions.clear();
        POJOWithAspect pojo = new POJOWithAspect();
        ScopeTestCase.assertEquals((int)5, (int)pojo.perVmA(5));
        pojo.perVmB();
        POJO2WithAspect pojo2 = new POJO2WithAspect();
        pojo2.perVmA(100);
        pojo2.perVmB();
        ScopeTestCase.assertEquals((int)4, (int)Interceptions.size());
        ScopeTestCase.assertEquals((Object)Interceptions.get(0), (Object)Interceptions.get(1));
        ScopeTestCase.assertEquals((Object)Interceptions.get(1), (Object)Interceptions.get(2));
        ScopeTestCase.assertEquals((Object)Interceptions.get(2), (Object)Interceptions.get(3));
    }

    public void testSimplePerVmInterceptor() {
        Interceptions.clear();
        POJOWithInterceptor pojo = new POJOWithInterceptor();
        ScopeTestCase.assertEquals((int)5, (int)pojo.perVmA(5));
        pojo.perVmB();
        POJO2WithInterceptor pojo2 = new POJO2WithInterceptor();
        pojo2.perVmA(50);
        pojo2.perVmB();
        ScopeTestCase.assertEquals((int)4, (int)Interceptions.size());
        ScopeTestCase.assertEquals((Object)Interceptions.get(0), (Object)Interceptions.get(1));
        ScopeTestCase.assertEquals((Object)Interceptions.get(1), (Object)Interceptions.get(2));
        ScopeTestCase.assertEquals((Object)Interceptions.get(2), (Object)Interceptions.get(3));
    }

    public void testSimplePerVmAspectFactory() {
        Interceptions.clear();
        POJOWithAspectFactory pojo = new POJOWithAspectFactory();
        ScopeTestCase.assertEquals((int)5, (int)pojo.perVmA(5));
        pojo.perVmB();
        POJO2WithAspectFactory pojo2 = new POJO2WithAspectFactory();
        pojo2.perVmA(15);
        pojo2.perVmB();
        ScopeTestCase.assertEquals((int)4, (int)Interceptions.size());
        ScopeTestCase.assertEquals((Object)Interceptions.get(0), (Object)Interceptions.get(1));
        ScopeTestCase.assertEquals((Object)Interceptions.get(1), (Object)Interceptions.get(2));
        ScopeTestCase.assertEquals((Object)Interceptions.get(2), (Object)Interceptions.get(3));
    }

    public void testSimplePerVmInterceptorFactory() {
        Interceptions.clear();
        POJOWithInterceptorFactory pojo = new POJOWithInterceptorFactory();
        ScopeTestCase.assertEquals((int)5, (int)pojo.perVmA(5));
        pojo.perVmB();
        POJO2WithInterceptorFactory pojo2 = new POJO2WithInterceptorFactory();
        pojo2.perVmA(15);
        pojo2.perVmB();
        ScopeTestCase.assertEquals((int)4, (int)Interceptions.size());
        ScopeTestCase.assertEquals((Object)Interceptions.get(0), (Object)Interceptions.get(1));
        ScopeTestCase.assertEquals((Object)Interceptions.get(1), (Object)Interceptions.get(2));
        ScopeTestCase.assertEquals((Object)Interceptions.get(2), (Object)Interceptions.get(3));
    }

    public void testSimplePerClassAspect() {
        Interceptions.clear();
        POJOWithAspect pojo = new POJOWithAspect();
        ScopeTestCase.assertEquals((int)5, (int)pojo.perClazzA(5));
        pojo.perClazzB();
        POJO2WithAspect pojo2 = new POJO2WithAspect();
        pojo2.perClazzA(5);
        pojo2.perClazzB();
        ScopeTestCase.assertEquals((int)4, (int)Interceptions.size());
        ScopeTestCase.assertEquals((Object)Interceptions.get(0), (Object)Interceptions.get(1));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(1), (Object)Interceptions.get(2));
        ScopeTestCase.assertEquals((Object)Interceptions.get(2), (Object)Interceptions.get(3));
    }

    public void testSimplePerClassInterceptor() {
        Interceptions.clear();
        POJOWithInterceptor pojo = new POJOWithInterceptor();
        ScopeTestCase.assertEquals((int)5, (int)pojo.perClazzA(5));
        pojo.perClazzB();
        POJO2WithInterceptor pojo2 = new POJO2WithInterceptor();
        pojo2.perClazzA(50);
        pojo2.perClazzB();
        for (int i = 0; i < Interceptions.size(); ++i) {
            System.out.println("intercepted by " + Interceptions.get(i));
        }
        ScopeTestCase.assertEquals((int)4, (int)Interceptions.size());
        ScopeTestCase.assertEquals((Object)Interceptions.get(0), (Object)Interceptions.get(1));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(1), (Object)Interceptions.get(2));
        ScopeTestCase.assertEquals((Object)Interceptions.get(2), (Object)Interceptions.get(3));
    }

    public void testSimplePerClassAspectFactory() {
        Interceptions.clear();
        POJOWithAspectFactory pojo = new POJOWithAspectFactory();
        ScopeTestCase.assertEquals((int)5, (int)pojo.perClazzA(5));
        pojo.perClazzB();
        POJO2WithAspectFactory pojo2 = new POJO2WithAspectFactory();
        pojo2.perClazzA(5);
        pojo2.perClazzB();
        ScopeTestCase.assertEquals((int)4, (int)Interceptions.size());
        ScopeTestCase.assertEquals((Object)Interceptions.get(0), (Object)Interceptions.get(1));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(1), (Object)Interceptions.get(2));
        ScopeTestCase.assertEquals((Object)Interceptions.get(2), (Object)Interceptions.get(3));
    }

    public void testSimplePerClassInterceptorFactory() {
        Interceptions.clear();
        POJOWithInterceptorFactory pojo = new POJOWithInterceptorFactory();
        ScopeTestCase.assertEquals((int)5, (int)pojo.perClazzA(5));
        pojo.perClazzB();
        POJO2WithInterceptorFactory pojo2 = new POJO2WithInterceptorFactory();
        pojo2.perClazzA(5);
        pojo2.perClazzB();
        for (int i = 0; i < Interceptions.size(); ++i) {
            System.out.println("intercepted by " + Interceptions.get(i));
        }
        ScopeTestCase.assertEquals((int)4, (int)Interceptions.size());
        ScopeTestCase.assertEquals((Object)Interceptions.get(0), (Object)Interceptions.get(1));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(1), (Object)Interceptions.get(2));
        ScopeTestCase.assertEquals((Object)Interceptions.get(2), (Object)Interceptions.get(3));
    }

    public void testSimplePerInstanceAspect() {
        Interceptions.clear();
        POJOWithAspect pojo = new POJOWithAspect();
        POJO2WithAspect pojo2 = new POJO2WithAspect();
        POJOWithAspect pojo3 = new POJOWithAspect();
        POJO2WithAspect pojo4 = new POJO2WithAspect();
        ScopeTestCase.assertEquals((int)5, (int)pojo.perInstanceA(5));
        pojo2.perInstanceA(5);
        pojo3.perInstanceA(5);
        pojo4.perInstanceA(5);
        pojo.perInstanceB();
        pojo2.perInstanceB();
        pojo3.perInstanceB();
        pojo4.perInstanceB();
        ScopeTestCase.assertEquals((int)8, (int)Interceptions.size());
        ScopeTestCase.assertEquals((Object)Interceptions.get(0), (Object)Interceptions.get(4));
        ScopeTestCase.assertEquals((Object)Interceptions.get(1), (Object)Interceptions.get(5));
        ScopeTestCase.assertEquals((Object)Interceptions.get(2), (Object)Interceptions.get(6));
        ScopeTestCase.assertEquals((Object)Interceptions.get(3), (Object)Interceptions.get(7));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(1));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(2));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(3));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(1), (Object)Interceptions.get(2));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(1), (Object)Interceptions.get(3));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(2), (Object)Interceptions.get(3));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(4), (Object)Interceptions.get(5));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(4), (Object)Interceptions.get(6));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(4), (Object)Interceptions.get(7));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(5), (Object)Interceptions.get(6));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(5), (Object)Interceptions.get(7));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(6), (Object)Interceptions.get(7));
    }

    public void testSimplePerInstanceInterceptor() {
        Interceptions.clear();
        POJOWithInterceptor pojo = new POJOWithInterceptor();
        POJOWithInterceptor pojo2 = new POJOWithInterceptor();
        POJOWithInterceptor pojo3 = new POJOWithInterceptor();
        POJOWithInterceptor pojo4 = new POJOWithInterceptor();
        ScopeTestCase.assertEquals((int)5, (int)pojo.perInstanceA(5));
        pojo2.perInstanceA(5);
        pojo3.perInstanceA(5);
        pojo4.perInstanceA(5);
        pojo.perInstanceB();
        pojo2.perInstanceB();
        pojo3.perInstanceB();
        pojo4.perInstanceB();
        ScopeTestCase.assertEquals((int)8, (int)Interceptions.size());
        ScopeTestCase.assertEquals((Object)Interceptions.get(0), (Object)Interceptions.get(4));
        ScopeTestCase.assertEquals((Object)Interceptions.get(1), (Object)Interceptions.get(5));
        ScopeTestCase.assertEquals((Object)Interceptions.get(2), (Object)Interceptions.get(6));
        ScopeTestCase.assertEquals((Object)Interceptions.get(3), (Object)Interceptions.get(7));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(1));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(2));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(3));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(1), (Object)Interceptions.get(2));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(1), (Object)Interceptions.get(3));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(2), (Object)Interceptions.get(3));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(4), (Object)Interceptions.get(5));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(4), (Object)Interceptions.get(6));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(4), (Object)Interceptions.get(7));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(5), (Object)Interceptions.get(6));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(5), (Object)Interceptions.get(7));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(6), (Object)Interceptions.get(7));
    }

    public void testSimplePerInstanceAspectFactory() {
        Interceptions.clear();
        POJOWithAspectFactory pojo = new POJOWithAspectFactory();
        POJOWithAspectFactory pojo2 = new POJOWithAspectFactory();
        POJOWithAspectFactory pojo3 = new POJOWithAspectFactory();
        POJOWithAspectFactory pojo4 = new POJOWithAspectFactory();
        ScopeTestCase.assertEquals((int)5, (int)pojo.perInstanceA(5));
        pojo2.perInstanceA(5);
        pojo3.perInstanceA(5);
        pojo4.perInstanceA(5);
        pojo.perInstanceB();
        pojo2.perInstanceB();
        pojo3.perInstanceB();
        pojo4.perInstanceB();
        ScopeTestCase.assertEquals((int)8, (int)Interceptions.size());
        ScopeTestCase.assertEquals((Object)Interceptions.get(0), (Object)Interceptions.get(4));
        ScopeTestCase.assertEquals((Object)Interceptions.get(1), (Object)Interceptions.get(5));
        ScopeTestCase.assertEquals((Object)Interceptions.get(2), (Object)Interceptions.get(6));
        ScopeTestCase.assertEquals((Object)Interceptions.get(3), (Object)Interceptions.get(7));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(1));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(2));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(3));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(1), (Object)Interceptions.get(2));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(1), (Object)Interceptions.get(3));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(2), (Object)Interceptions.get(3));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(4), (Object)Interceptions.get(5));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(4), (Object)Interceptions.get(6));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(4), (Object)Interceptions.get(7));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(5), (Object)Interceptions.get(6));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(5), (Object)Interceptions.get(7));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(6), (Object)Interceptions.get(7));
    }

    public void testSimplePerInstanceInterceptorFactory() {
        Interceptions.clear();
        POJOWithInterceptorFactory pojo = new POJOWithInterceptorFactory();
        POJOWithInterceptorFactory pojo2 = new POJOWithInterceptorFactory();
        POJOWithInterceptorFactory pojo3 = new POJOWithInterceptorFactory();
        POJOWithInterceptorFactory pojo4 = new POJOWithInterceptorFactory();
        ScopeTestCase.assertEquals((int)5, (int)pojo.perInstanceA(5));
        pojo2.perInstanceA(5);
        pojo3.perInstanceA(5);
        pojo4.perInstanceA(5);
        pojo.perInstanceB();
        pojo2.perInstanceB();
        pojo3.perInstanceB();
        pojo4.perInstanceB();
        ScopeTestCase.assertEquals((int)8, (int)Interceptions.size());
        ScopeTestCase.assertEquals((Object)Interceptions.get(0), (Object)Interceptions.get(4));
        ScopeTestCase.assertEquals((Object)Interceptions.get(1), (Object)Interceptions.get(5));
        ScopeTestCase.assertEquals((Object)Interceptions.get(2), (Object)Interceptions.get(6));
        ScopeTestCase.assertEquals((Object)Interceptions.get(3), (Object)Interceptions.get(7));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(1));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(2));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(3));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(1), (Object)Interceptions.get(2));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(1), (Object)Interceptions.get(3));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(2), (Object)Interceptions.get(3));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(4), (Object)Interceptions.get(5));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(4), (Object)Interceptions.get(6));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(4), (Object)Interceptions.get(7));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(5), (Object)Interceptions.get(6));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(5), (Object)Interceptions.get(7));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(6), (Object)Interceptions.get(7));
    }

    public void testSimplePerJoinpointAspect() {
        Interceptions.clear();
        POJOWithAspect pojo = new POJOWithAspect();
        POJO2WithAspect pojo2 = new POJO2WithAspect();
        POJOWithAspect pojo3 = new POJOWithAspect();
        POJO2WithAspect pojo4 = new POJO2WithAspect();
        ScopeTestCase.assertEquals((int)5, (int)pojo.perJoinpointA(5));
        pojo2.perJoinpointA(5);
        pojo3.perJoinpointA(5);
        pojo4.perJoinpointA(5);
        pojo.perJoinpointB();
        pojo2.perJoinpointB();
        pojo3.perJoinpointB();
        pojo4.perJoinpointB();
        pojo.perJoinpointA(5);
        pojo2.perJoinpointA(5);
        pojo3.perJoinpointA(5);
        pojo4.perJoinpointA(5);
        pojo.perJoinpointB();
        pojo2.perJoinpointB();
        pojo3.perJoinpointB();
        pojo4.perJoinpointB();
        ScopeTestCase.assertEquals((int)16, (int)Interceptions.size());
        int[] results = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7};
        for (int i = 0; i < results.length; ++i) {
            for (int j = 0; j < results.length; ++j) {
                if (i == j || Math.abs(i - j) == results.length / 2) {
                    ScopeTestCase.assertEquals((String)("interceptions " + i + " and " + j + " should be the same"), (Object)Interceptions.get(i), (Object)Interceptions.get(j));
                    continue;
                }
                ScopeTestCase.assertNotSame((String)("interceptions " + i + " and " + j + " should not be the same"), (Object)Interceptions.get(i), (Object)Interceptions.get(j));
            }
        }
    }

    public void testSimplePerJoinpointInterceptor() {
        Interceptions.clear();
        POJOWithInterceptor pojo = new POJOWithInterceptor();
        POJOWithInterceptor pojo2 = new POJOWithInterceptor();
        POJOWithInterceptor pojo3 = new POJOWithInterceptor();
        POJOWithInterceptor pojo4 = new POJOWithInterceptor();
        ScopeTestCase.assertEquals((int)5, (int)pojo.perJoinpointA(5));
        pojo2.perJoinpointA(5);
        pojo3.perJoinpointA(5);
        pojo4.perJoinpointA(5);
        pojo.perJoinpointB();
        pojo2.perJoinpointB();
        pojo3.perJoinpointB();
        pojo4.perJoinpointB();
        pojo.perJoinpointA(5);
        pojo2.perJoinpointA(5);
        pojo3.perJoinpointA(5);
        pojo4.perJoinpointA(5);
        pojo.perJoinpointB();
        pojo2.perJoinpointB();
        pojo3.perJoinpointB();
        pojo4.perJoinpointB();
        ScopeTestCase.assertEquals((int)16, (int)Interceptions.size());
        int[] results = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7};
        for (int i = 0; i < results.length; ++i) {
            for (int j = 0; j < results.length; ++j) {
                if (i == j || Math.abs(i - j) == results.length / 2) {
                    ScopeTestCase.assertEquals((String)("interceptions " + i + " and " + j + " should be the same"), (Object)Interceptions.get(i), (Object)Interceptions.get(j));
                    continue;
                }
                ScopeTestCase.assertNotSame((String)("interceptions " + i + " and " + j + " should not be the same"), (Object)Interceptions.get(i), (Object)Interceptions.get(j));
            }
        }
    }

    public void testSimplePerJoinpointAspectFactory() {
        Interceptions.clear();
        POJOWithAspectFactory pojo = new POJOWithAspectFactory();
        POJOWithAspectFactory pojo2 = new POJOWithAspectFactory();
        POJOWithAspectFactory pojo3 = new POJOWithAspectFactory();
        POJOWithAspectFactory pojo4 = new POJOWithAspectFactory();
        ScopeTestCase.assertEquals((int)5, (int)pojo.perJoinpointA(5));
        pojo2.perJoinpointA(5);
        pojo3.perJoinpointA(5);
        pojo4.perJoinpointA(5);
        pojo.perJoinpointB();
        pojo2.perJoinpointB();
        pojo3.perJoinpointB();
        pojo4.perJoinpointB();
        pojo.perJoinpointA(5);
        pojo2.perJoinpointA(5);
        pojo3.perJoinpointA(5);
        pojo4.perJoinpointA(5);
        pojo.perJoinpointB();
        pojo2.perJoinpointB();
        pojo3.perJoinpointB();
        pojo4.perJoinpointB();
        ScopeTestCase.assertEquals((int)16, (int)Interceptions.size());
        int[] results = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7};
        for (int i = 0; i < results.length; ++i) {
            for (int j = 0; j < results.length; ++j) {
                if (i == j || Math.abs(i - j) == results.length / 2) {
                    ScopeTestCase.assertEquals((String)("interceptions " + i + " and " + j + " should be the same"), (Object)Interceptions.get(i), (Object)Interceptions.get(j));
                    continue;
                }
                ScopeTestCase.assertNotSame((String)("interceptions " + i + " and " + j + " should not be the same"), (Object)Interceptions.get(i), (Object)Interceptions.get(j));
            }
        }
    }

    public void testSimplePerJoinpointInterceptorFactory() {
        Interceptions.clear();
        POJOWithInterceptorFactory pojo = new POJOWithInterceptorFactory();
        POJOWithInterceptorFactory pojo2 = new POJOWithInterceptorFactory();
        POJOWithInterceptorFactory pojo3 = new POJOWithInterceptorFactory();
        POJOWithInterceptorFactory pojo4 = new POJOWithInterceptorFactory();
        ScopeTestCase.assertEquals((int)5, (int)pojo.perJoinpointA(5));
        pojo2.perJoinpointA(5);
        pojo3.perJoinpointA(5);
        pojo4.perJoinpointA(5);
        pojo.perJoinpointB();
        pojo2.perJoinpointB();
        pojo3.perJoinpointB();
        pojo4.perJoinpointB();
        pojo.perJoinpointA(5);
        pojo2.perJoinpointA(5);
        pojo3.perJoinpointA(5);
        pojo4.perJoinpointA(5);
        pojo.perJoinpointB();
        pojo2.perJoinpointB();
        pojo3.perJoinpointB();
        pojo4.perJoinpointB();
        ScopeTestCase.assertEquals((int)16, (int)Interceptions.size());
        int[] results = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7};
        for (int i = 0; i < results.length; ++i) {
            for (int j = 0; j < results.length; ++j) {
                if (i == j || Math.abs(i - j) == results.length / 2) {
                    ScopeTestCase.assertEquals((String)("interceptions " + i + " and " + j + " should be the same"), (Object)Interceptions.get(i), (Object)Interceptions.get(j));
                    continue;
                }
                ScopeTestCase.assertNotSame((String)("interceptions " + i + " and " + j + " should not be the same"), (Object)Interceptions.get(i), (Object)Interceptions.get(j));
            }
        }
    }

    public void testNullAspectFactory() {
        int value = POJOWithNullAspect.staticField;
        POJOWithNullAspect.staticField = value + 1;
        POJOWithNullAspect.staticMethod();
        POJOWithNullAspect.callerMethod2();
        POJOWithNullAspect pojo = new POJOWithNullAspect();
        pojo.field = (value += pojo.field) - 10;
        pojo.method();
        pojo.callerMethod1();
        new POJOWithNullAspect(3, 4);
        Interceptions.clear();
        pojo.mixedMethod();
        ScopeTestCase.assertEquals((int)1, (int)Interceptions.size());
    }

    public void testPOJOStaticWithMixedChains() throws Exception {
        System.out.println("TEST POJO WITH MIXED CHAINS");
        Interceptions.clear();
        ScopeTestCase.assertEquals((int)5, (int)POJOWithMixedChains.staticMethod(5));
        this.checkExpectedNames(staticNames);
        ArrayList staticMethod = (ArrayList)Interceptions.interceptions.clone();
        Interceptions.clear();
        POJOWithMixedChains.voidStaticMethod();
        this.checkExpectedNames(staticNames);
        ArrayList staticVoidMethod = (ArrayList)Interceptions.interceptions.clone();
        Interceptions.clear();
        POJOWithMixedChains.staticField = 100;
        this.checkExpectedNames(staticNames);
        ArrayList staticFieldWrite = (ArrayList)Interceptions.interceptions.clone();
        Interceptions.clear();
        ScopeTestCase.assertEquals((int)100, (int)POJOWithMixedChains.staticField);
        this.checkExpectedNames(staticNames);
        ArrayList staticFieldRead = (ArrayList)Interceptions.interceptions.clone();
        this.checkSimilarities(staticMethod, staticVoidMethod, new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE});
        this.checkSimilarities(staticMethod, staticFieldWrite, new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE});
        this.checkSimilarities(staticFieldWrite, staticFieldRead, new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE});
    }

    public void testPOJOConstructionWithMixedChains() throws Exception {
        Interceptions.clear();
        POJOWithMixedChains pojo = new POJOWithMixedChains();
        this.checkExpectedNames(staticAndConstructionNames);
        ArrayList ctorA = (ArrayList)Interceptions.interceptions.clone();
        Interceptions.clear();
        POJOWithMixedChains pojo2 = new POJOWithMixedChains(100);
        this.checkExpectedNames(staticAndConstructionNames);
        ArrayList ctorB = (ArrayList)Interceptions.interceptions.clone();
        this.checkSimilarities(ctorA, ctorB, new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE});
    }

    public void testPOJOMethodsWithMixedChains() throws Exception {
        POJOWithMixedChains pojo = new POJOWithMixedChains();
        POJOWithMixedChains pojo2 = new POJOWithMixedChains();
        Interceptions.clear();
        ScopeTestCase.assertEquals((int)100, (int)pojo.method(100));
        this.checkExpectedNames(nonStaticNames);
        ArrayList methodInterceptionsA = (ArrayList)Interceptions.interceptions.clone();
        Interceptions.clear();
        ScopeTestCase.assertEquals((int)100, (int)pojo2.method(100));
        this.checkExpectedNames(nonStaticNames);
        ArrayList methodInterceptionsB = (ArrayList)Interceptions.interceptions.clone();
        System.out.println("Checking methodA and methodB");
        this.checkSimilarities(methodInterceptionsA, methodInterceptionsB, new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE});
    }

    public void testPOJOFieldsWithMixedChains() throws Exception {
        POJOWithMixedChains pojo = new POJOWithMixedChains();
        POJOWithMixedChains pojo2 = new POJOWithMixedChains();
        Interceptions.clear();
        pojo.field = 100;
        this.checkExpectedNames(nonStaticNames);
        ArrayList fieldWriteA = (ArrayList)Interceptions.interceptions.clone();
        Interceptions.clear();
        pojo2.field = 50;
        this.checkExpectedNames(nonStaticNames);
        ArrayList fieldWriteB = (ArrayList)Interceptions.interceptions.clone();
        Interceptions.clear();
        ScopeTestCase.assertEquals((int)100, (int)pojo.field);
        this.checkExpectedNames(nonStaticNames);
        ArrayList fieldReadA = (ArrayList)Interceptions.interceptions.clone();
        Interceptions.clear();
        ScopeTestCase.assertEquals((int)50, (int)pojo2.field);
        this.checkExpectedNames(nonStaticNames);
        ArrayList fieldReadB = (ArrayList)Interceptions.interceptions.clone();
        this.checkSimilarities(fieldWriteA, fieldWriteB, new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE});
        this.checkSimilarities(fieldReadA, fieldReadB, new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE});
        this.checkSimilarities(fieldReadA, fieldWriteA, new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE});
        this.checkSimilarities(fieldReadB, fieldWriteB, new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE});
    }

    public void testCallerFromCtorWithMixedChains() throws Exception {
        int i;
        Interceptions.clear();
        CallingPOJO pojo = new CallingPOJO();
        CallingPOJO pojo2 = new CallingPOJO();
        String[] expectedNames = new String[20];
        for (i = 0; i < 20; i += 5) {
            System.arraycopy(nonStaticNames, 0, expectedNames, i, nonStaticNames.length);
        }
        this.checkExpectedNames(expectedNames);
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(5));
        ScopeTestCase.assertSame((Object)Interceptions.get(1), (Object)Interceptions.get(6));
        ScopeTestCase.assertSame((Object)Interceptions.get(2), (Object)Interceptions.get(7));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(3), (Object)Interceptions.get(8));
        ScopeTestCase.assertSame((Object)Interceptions.get(4), (Object)Interceptions.get(9));
        for (i = 0; i < Interceptions.size(); ++i) {
            System.out.println(Interceptions.get(i));
        }
        Interceptions.clear();
        pojo = new CallingPOJO();
        ArrayList ctorA = (ArrayList)Interceptions.interceptions.clone();
        Interceptions.clear();
        pojo2 = new CallingPOJO();
        ArrayList ctorB = (ArrayList)Interceptions.interceptions.clone();
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(5));
        ScopeTestCase.assertSame((Object)Interceptions.get(1), (Object)Interceptions.get(6));
        ScopeTestCase.assertSame((Object)Interceptions.get(2), (Object)Interceptions.get(7));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(3), (Object)Interceptions.get(8));
        ScopeTestCase.assertSame((Object)Interceptions.get(4), (Object)Interceptions.get(9));
        this.checkSimilarities(ctorA, ctorB, new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE});
    }

    public void testCallerFromStaticMethodWithMixedChains() throws Exception {
        int i;
        Interceptions.clear();
        CallingPOJO.callFromStatic();
        CallingPOJO.callFromStatic();
        String[] expectedNames = new String[16];
        for (i = 0; i < 16; i += 4) {
            System.arraycopy(staticNames, 0, expectedNames, i, staticNames.length);
        }
        this.checkExpectedNames(expectedNames);
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(4));
        ScopeTestCase.assertSame((Object)Interceptions.get(1), (Object)Interceptions.get(5));
        ScopeTestCase.assertSame((Object)Interceptions.get(2), (Object)Interceptions.get(6));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(3), (Object)Interceptions.get(7));
        for (i = 0; i < Interceptions.size(); ++i) {
            System.out.println(Interceptions.get(i));
        }
        Interceptions.clear();
        CallingPOJO.callFromStatic();
        ArrayList staticA = (ArrayList)Interceptions.interceptions.clone();
        Interceptions.clear();
        CallingPOJO.callFromStatic();
        ArrayList staticB = (ArrayList)Interceptions.interceptions.clone();
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(4));
        ScopeTestCase.assertSame((Object)Interceptions.get(1), (Object)Interceptions.get(5));
        ScopeTestCase.assertSame((Object)Interceptions.get(2), (Object)Interceptions.get(6));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(3), (Object)Interceptions.get(7));
        this.checkSimilarities(staticA, staticB, new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE});
    }

    public void testCallerFromMethodWithMixedChains() throws Exception {
        CallingPOJO pojo = new CallingPOJO();
        CallingPOJO pojo2 = new CallingPOJO();
        Interceptions.clear();
        pojo.call();
        pojo2.call();
        String[] expectedNames = new String[20];
        for (int i = 0; i < 20; i += 5) {
            System.arraycopy(nonStaticNames, 0, expectedNames, i, nonStaticNames.length);
        }
        this.checkExpectedNames(expectedNames);
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(5));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(10));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(0), (Object)Interceptions.get(15));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(5), (Object)Interceptions.get(10));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(5), (Object)Interceptions.get(15));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(10), (Object)Interceptions.get(15));
        if (Interceptions.get(1) != Interceptions.get(6) || Interceptions.get(1) != Interceptions.get(11) || Interceptions.get(1) != Interceptions.get(16)) {
            throw new Exception("PER_CLASS scoped should have been the same");
        }
        if (Interceptions.get(2) != Interceptions.get(7) || Interceptions.get(2) != Interceptions.get(12) || Interceptions.get(2) != Interceptions.get(17)) {
            throw new Exception("PER_CLASS scoped should have been the same");
        }
        ScopeTestCase.assertSame((Object)Interceptions.get(3), (Object)Interceptions.get(13));
        ScopeTestCase.assertSame((Object)Interceptions.get(8), (Object)Interceptions.get(18));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(3), (Object)Interceptions.get(8));
        ScopeTestCase.assertSame((Object)Interceptions.get(4), (Object)Interceptions.get(9));
        ScopeTestCase.assertSame((Object)Interceptions.get(14), (Object)Interceptions.get(19));
        ScopeTestCase.assertNotSame((Object)Interceptions.get(4), (Object)Interceptions.get(14));
    }

    public void testDynamicInvoke() throws Throwable {
        POJOWithMixedChains pojo = new POJOWithMixedChains();
        Interceptions.clear();
        pojo.dynamicMethod();
        ArrayList methodA = (ArrayList)Interceptions.interceptions.clone();
        Interceptions.clear();
        Method method = pojo.getClass().getMethod("dynamicMethod", new Class[0]);
        long hash = MethodHashing.calculateHash((Method)method);
        MethodInvocation invocation = new MethodInvocation(null, hash, null, null, null);
        invocation.setArguments(new Object[0]);
        ((Advised)pojo)._getAdvisor().dynamicInvoke((Object)pojo, (Invocation)invocation);
        ArrayList methodB = (ArrayList)Interceptions.interceptions.clone();
        this.checkSimilarities(methodA, methodB);
    }

    public void testCopy() throws Exception {
        System.out.println("TEST COPY");
        Interceptions.clear();
        ScopeTestCase.assertEquals((int)5, (int)CopyPOJOWithMixedChains.staticMethod(5));
        ScopeTestCase.assertEquals((int)8, (int)Interceptions.size());
        this.checkSimilaritiesInTowHalves(Interceptions.interceptions);
        Interceptions.clear();
        CopyPOJOWithMixedChains.staticField = 17;
        ScopeTestCase.assertEquals((int)8, (int)Interceptions.size());
        this.checkSimilaritiesInTowHalves(Interceptions.interceptions);
        Interceptions.clear();
        ScopeTestCase.assertEquals((int)17, (int)CopyPOJOWithMixedChains.staticField);
        ScopeTestCase.assertEquals((int)8, (int)Interceptions.size());
        this.checkSimilaritiesInTowHalves(Interceptions.interceptions);
        Interceptions.clear();
        CopyPOJOWithMixedChains pojo = new CopyPOJOWithMixedChains(5);
        ScopeTestCase.assertEquals((int)8, (int)Interceptions.size());
        this.checkSimilaritiesInTowHalves(Interceptions.interceptions);
        Interceptions.clear();
        pojo.field = 99;
        ScopeTestCase.assertEquals((int)10, (int)Interceptions.size());
        this.checkSimilaritiesInTowHalves(Interceptions.interceptions);
        Interceptions.clear();
        ScopeTestCase.assertEquals((int)99, (int)pojo.field);
        ScopeTestCase.assertEquals((int)10, (int)Interceptions.size());
        this.checkSimilaritiesInTowHalves(Interceptions.interceptions);
    }

    private void checkSimilaritiesInTowHalves(ArrayList all) {
        ArrayList listA = new ArrayList();
        ArrayList listB = new ArrayList();
        for (int i = 0; i < all.size(); ++i) {
            if (i < all.size() / 2) {
                listA.add(all.get(i));
                continue;
            }
            listB.add(all.get(i));
        }
        this.checkSimilarities(listA, listB);
    }

    private void checkSimilarities(ArrayList listA, ArrayList listB) {
        Boolean[] same = new Boolean[listA.size()];
        for (int i = 0; i < listA.size(); ++i) {
            same[i] = Boolean.TRUE;
        }
        this.checkSimilarities(listA, listB, same);
    }

    private void checkSimilarities(ArrayList listA, ArrayList listB, Boolean[] same) {
        ScopeTestCase.assertEquals((int)listA.size(), (int)listB.size());
        ScopeTestCase.assertEquals((int)listA.size(), (int)same.length);
        for (int i = 0; i < listA.size(); ++i) {
            if (same[i].booleanValue()) {
                ScopeTestCase.assertEquals((String)Integer.toString(i), listA.get(i), listB.get(i));
                continue;
            }
            ScopeTestCase.assertNotSame((String)Integer.toString(i), listA.get(i), listB.get(i));
        }
    }

    private void checkExpectedNames(String[] expected) {
        ScopeTestCase.assertEquals((int)expected.length, (int)Interceptions.size());
        for (int i = 0; i < expected.length; ++i) {
            ScopeTestCase.assertEquals((String)Integer.toString(i), (String)expected[i], (String)Interceptions.get(i).getClass().getName());
        }
    }
}

