/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.stress.batf;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jboss.test.aop.stress.AbstractScenario;
import org.jboss.test.aop.stress.ScenarioTest;
import org.jboss.test.aop.stress.batf.NotWoven;
import org.jboss.test.aop.stress.batf.POJO;
import org.jboss.test.aop.stress.batf.SimpleAspect;

public class BeforeAfterThrowingFinallyVersusAroundTestCase
extends ScenarioTest {
    public static void main(String[] args) {
        int i = -5;
        i *= -1;
        TestRunner.run(BeforeAfterThrowingFinallyVersusAroundTestCase.class);
    }

    public BeforeAfterThrowingFinallyVersusAroundTestCase(String name) throws Exception {
        super(name);
    }

    public void testAroundWithNoExceptionScenario() throws Exception {
        SimpleAspect.reset();
        POJO pojo = new POJO();
        pojo.methodWithAroundNoExceptions();
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertTrue((boolean)SimpleAspect.before);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertTrue((boolean)SimpleAspect.after);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertFalse((boolean)SimpleAspect.throwing);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertFalse((boolean)SimpleAspect.finaly);
        this.getRunner().executeScenario(new AroundWithNoExceptionsScenario(), (TestCase)this);
    }

    public void testBeforeAfterThrowingFinallyWithNoExceptionScenario() throws Exception {
        SimpleAspect.reset();
        POJO pojo = new POJO();
        pojo.methodWithBeforeAfter();
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertTrue((boolean)SimpleAspect.before);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertTrue((boolean)SimpleAspect.after);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertFalse((boolean)SimpleAspect.throwing);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertFalse((boolean)SimpleAspect.finaly);
        this.getRunner().executeScenario(new BeforeAfterThrowingFinallyWithNoExceptionsScenario(), (TestCase)this);
    }

    public void testAroundWithExceptionScenario() throws Exception {
        SimpleAspect.reset();
        boolean exception = false;
        try {
            POJO pojo = new POJO();
            pojo.methodWithAroundExceptions();
        }
        catch (Exception e) {
            exception = true;
        }
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertTrue((boolean)exception);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertTrue((boolean)SimpleAspect.before);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertFalse((boolean)SimpleAspect.after);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertTrue((boolean)SimpleAspect.throwing);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertTrue((boolean)SimpleAspect.finaly);
        this.getRunner().executeScenario(new AroundWithExceptionsScenario(), (TestCase)this);
    }

    public void testBeforeAfterThrowingFinallyWithExceptionScenario() throws Exception {
        SimpleAspect.reset();
        boolean exception = false;
        try {
            POJO pojo = new POJO();
            pojo.methodWithBeforeThrowingFinally();
        }
        catch (Exception e) {
            exception = true;
        }
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertTrue((boolean)exception);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertTrue((boolean)SimpleAspect.before);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertFalse((boolean)SimpleAspect.after);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertTrue((boolean)SimpleAspect.throwing);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertTrue((boolean)SimpleAspect.finaly);
        this.getRunner().executeScenario(new BeforeAfterThrowingFinallyWithExceptionScenario(), (TestCase)this);
    }

    public void testAroundSimulatedBefore() throws Exception {
        SimpleAspect.reset();
        POJO pojo = new POJO();
        pojo.methodWithSimulatedBefore();
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertTrue((boolean)SimpleAspect.before);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertFalse((boolean)SimpleAspect.after);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertFalse((boolean)SimpleAspect.throwing);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertFalse((boolean)SimpleAspect.finaly);
        this.getRunner().executeScenario(new AroundSimulatedBeforeScenario(), (TestCase)this);
    }

    public void testBeforeOnly() throws Exception {
        SimpleAspect.reset();
        POJO pojo = new POJO();
        pojo.methodWithOnlyBefore();
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertTrue((boolean)SimpleAspect.before);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertFalse((boolean)SimpleAspect.after);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertFalse((boolean)SimpleAspect.throwing);
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertFalse((boolean)SimpleAspect.finaly);
        this.getRunner().executeScenario(new BeforeOnlyScenario(), (TestCase)this);
    }

    public void testAroundAccessArguments() throws Exception {
        SimpleAspect.reset();
        POJO pojo = new POJO();
        pojo.methodWithAroundArguments("HELLO");
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertEquals((String)"HELLO", (String)SimpleAspect.string);
        this.getRunner().executeScenario(new AroundAccessArgumentsScenario(), (TestCase)this);
    }

    public void testBeforeAccessTypedArgument() throws Exception {
        SimpleAspect.reset();
        POJO pojo = new POJO();
        pojo.methodWithTypedArguments("HEY");
        BeforeAfterThrowingFinallyVersusAroundTestCase.assertEquals((String)"HEY", (String)SimpleAspect.string);
        this.getRunner().executeScenario(new BeforeAccessTypedArgumentScenario(), (TestCase)this);
    }

    public void testNotWovenNoCtorScenario() throws Exception {
        this.getRunner().executeScenario(new NotWovenNoCtorScenario(), (TestCase)this);
    }

    public void testNotWovenWithCtorScenario() throws Exception {
        this.getRunner().executeScenario(new NotWovenWithCtorScenario(), (TestCase)this);
    }

    private class NotWovenWithCtorScenario
    extends AbstractScenario {
        private NotWovenWithCtorScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            NotWoven pojo = new NotWoven();
            pojo.method2();
        }
    }

    private class NotWovenNoCtorScenario
    extends AbstractScenario {
        NotWoven pojo = new NotWoven();

        private NotWovenNoCtorScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            this.pojo.method1();
        }
    }

    private class BeforeAccessTypedArgumentScenario
    extends AbstractScenario {
        POJO pojo = new POJO();

        private BeforeAccessTypedArgumentScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            this.pojo.methodWithTypedArguments("TEST123");
        }
    }

    private class AroundAccessArgumentsScenario
    extends AbstractScenario {
        POJO pojo = new POJO();

        private AroundAccessArgumentsScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            this.pojo.methodWithAroundArguments("TEST");
        }
    }

    private class BeforeOnlyScenario
    extends AbstractScenario {
        POJO pojo = new POJO();

        private BeforeOnlyScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            this.pojo.methodWithOnlyBefore();
        }
    }

    private class AroundSimulatedBeforeScenario
    extends AbstractScenario {
        POJO pojo = new POJO();

        private AroundSimulatedBeforeScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            this.pojo.methodWithSimulatedBefore();
        }
    }

    private class BeforeAfterThrowingFinallyWithExceptionScenario
    extends AbstractScenario {
        POJO pojo = new POJO();

        private BeforeAfterThrowingFinallyWithExceptionScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            try {
                this.pojo.methodWithBeforeThrowingFinally();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private class AroundWithExceptionsScenario
    extends AbstractScenario {
        POJO pojo = new POJO();

        private AroundWithExceptionsScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            try {
                this.pojo.methodWithAroundExceptions();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private class BeforeAfterThrowingFinallyWithNoExceptionsScenario
    extends AbstractScenario {
        POJO pojo = new POJO();

        private BeforeAfterThrowingFinallyWithNoExceptionsScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            this.pojo.methodWithBeforeAfter();
        }
    }

    private class AroundWithNoExceptionsScenario
    extends AbstractScenario {
        POJO pojo = new POJO();

        private AroundWithNoExceptionsScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            this.pojo.methodWithAroundNoExceptions();
        }
    }
}

