/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.annotatedAdviceParams;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.annotatedAdviceParams.CallType;
import org.jboss.test.aop.annotatedAdviceParams.CallerAspect;
import org.jboss.test.aop.annotatedAdviceParams.POJOException;
import org.jboss.test.aop.annotatedAdviceParams.TargetCallerPOJO;

public class CallerTestCase
extends AOPTestWithSetup {
    private TargetCallerPOJO pojo;

    public static void main(String[] args) {
        TestRunner.run((Test)CallerTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("CallerTestCase");
        suite.addTestSuite(CallerTestCase.class);
        return suite;
    }

    public CallerTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        CallerAspect.clear();
        this.pojo = new TargetCallerPOJO();
    }

    public void test1() throws Exception {
        this.pojo.method5();
        this.assertAllAdvices(this.pojo, false);
    }

    public void test2() throws Exception {
        boolean thrown = false;
        try {
            this.pojo.method6();
        }
        catch (POJOException e) {
            thrown = true;
        }
        CallerTestCase.assertTrue((boolean)thrown);
        this.assertAllAdvices(this.pojo, thrown);
    }

    public void test3() throws Exception {
        this.pojo.method7();
        this.assertAllAdvices(this.pojo, false);
    }

    public void test4() throws Exception {
        this.pojo.method8();
        this.assertAllAdvices(this.pojo, false);
    }

    public void test5() throws Exception {
        boolean thrown = false;
        try {
            this.pojo.method9();
        }
        catch (POJOException e) {
            thrown = true;
        }
        CallerTestCase.assertTrue((boolean)thrown);
        this.assertAllAdvices(this.pojo, thrown);
    }

    public void test6() throws Exception {
        boolean thrown = false;
        try {
            this.pojo.method10();
        }
        catch (POJOException e) {
            thrown = true;
        }
        CallerTestCase.assertTrue((boolean)thrown);
        this.assertAllAdvices(this.pojo, thrown);
    }

    public void test7() throws Exception {
        TargetCallerPOJO.method11();
        this.assertAllAdvices(null, false);
    }

    public void test8() throws Exception {
        TargetCallerPOJO.method12();
        this.assertAllAdvices(null, false);
    }

    public void test9() throws Exception {
        TargetCallerPOJO.method13();
        this.assertAllAdvices(null, false);
    }

    public void test10() throws Exception {
        boolean thrown = false;
        try {
            TargetCallerPOJO.method14();
        }
        catch (POJOException e) {
            thrown = true;
        }
        CallerTestCase.assertTrue((boolean)thrown);
        this.assertAllAdvices(null, thrown);
    }

    public void test11() throws Exception {
        boolean thrown = false;
        try {
            TargetCallerPOJO.method15();
        }
        catch (POJOException e) {
            thrown = true;
        }
        CallerTestCase.assertTrue((boolean)thrown);
        this.assertAllAdvices(null, thrown);
    }

    public void test12() throws POJOException {
        TargetCallerPOJO caller = new TargetCallerPOJO(CallType.CONSTRUCTOR, false);
        this.assertAllAdvices(caller, false);
    }

    public void test13() throws POJOException {
        TargetCallerPOJO caller = new TargetCallerPOJO(CallType.METHOD, false);
        this.assertAllAdvices(caller, false);
    }

    public void test14() throws POJOException {
        TargetCallerPOJO caller = new TargetCallerPOJO(CallType.STATIC_METHOD, false);
        this.assertAllAdvices(caller, false);
    }

    public void test15() {
        this.testConCallerWithException(CallType.CONSTRUCTOR);
    }

    public void test16() {
        this.testConCallerWithException(CallType.METHOD);
    }

    public void test17() {
        this.testConCallerWithException(CallType.STATIC_METHOD);
    }

    public void test18() {
        this.pojo.method1();
        CallerTestCase.assertTrue((boolean)CallerAspect.before1);
        CallerTestCase.assertFalse((boolean)CallerAspect.before2);
        CallerTestCase.assertFalse((boolean)CallerAspect.before3);
        CallerTestCase.assertTrue((boolean)CallerAspect.around1);
        CallerTestCase.assertFalse((boolean)CallerAspect.around2);
        CallerTestCase.assertFalse((boolean)CallerAspect.around4);
        CallerTestCase.assertTrue((boolean)CallerAspect.after1);
        CallerTestCase.assertFalse((boolean)CallerAspect.after2);
        CallerTestCase.assertFalse((boolean)CallerAspect.throwing1);
        CallerTestCase.assertFalse((boolean)CallerAspect.throwing3);
        CallerTestCase.assertFalse((boolean)CallerAspect.finally1);
        CallerTestCase.assertTrue((boolean)CallerAspect.finally2);
        CallerTestCase.assertFalse((boolean)CallerAspect.finally4);
    }

    public void test19() {
        boolean thrown = false;
        try {
            this.pojo.method3();
        }
        catch (POJOException e) {
            thrown = true;
        }
        CallerTestCase.assertTrue((boolean)thrown);
        CallerTestCase.assertTrue((boolean)CallerAspect.before1);
        CallerTestCase.assertFalse((boolean)CallerAspect.before2);
        CallerTestCase.assertFalse((boolean)CallerAspect.before3);
        CallerTestCase.assertTrue((boolean)CallerAspect.around1);
        CallerTestCase.assertFalse((boolean)CallerAspect.around2);
        CallerTestCase.assertFalse((boolean)CallerAspect.around4);
        CallerTestCase.assertFalse((boolean)CallerAspect.after1);
        CallerTestCase.assertFalse((boolean)CallerAspect.after2);
        CallerTestCase.assertTrue((boolean)CallerAspect.throwing1);
        CallerTestCase.assertFalse((boolean)CallerAspect.throwing3);
        CallerTestCase.assertFalse((boolean)CallerAspect.finally1);
        CallerTestCase.assertTrue((boolean)CallerAspect.finally2);
        CallerTestCase.assertFalse((boolean)CallerAspect.finally4);
    }

    public void assertAllAdvices(Object caller, boolean error) {
        this.assertAllAdvices(error);
        CallerTestCase.assertSame((Object)caller, (Object)CallerAspect.before2Caller);
    }

    public void assertAllAdvicesNotNull(boolean error) {
        this.assertAllAdvices(error);
        CallerTestCase.assertNotNull((Object)CallerAspect.before2Caller);
    }

    public void assertAllAdvices(boolean error) {
        CallerTestCase.assertTrue((boolean)CallerAspect.before1);
        CallerTestCase.assertTrue((boolean)CallerAspect.before2);
        CallerTestCase.assertTrue((boolean)CallerAspect.before3);
        CallerTestCase.assertTrue((boolean)CallerAspect.around1);
        CallerTestCase.assertTrue((boolean)CallerAspect.around2);
        CallerTestCase.assertTrue((boolean)CallerAspect.around4);
        CallerTestCase.assertEquals((!error ? 1 : 0) != 0, (boolean)CallerAspect.after1);
        CallerTestCase.assertEquals((!error ? 1 : 0) != 0, (boolean)CallerAspect.after2);
        CallerTestCase.assertEquals((boolean)error, (boolean)CallerAspect.throwing1);
        CallerTestCase.assertEquals((boolean)error, (boolean)CallerAspect.throwing3);
        CallerTestCase.assertTrue((boolean)CallerAspect.finally1);
        CallerTestCase.assertTrue((boolean)CallerAspect.finally2);
        CallerTestCase.assertTrue((boolean)CallerAspect.finally4);
        CallerTestCase.assertSame((Object)CallerAspect.before2Caller, (Object)CallerAspect.before3Caller);
        CallerTestCase.assertSame((Object)CallerAspect.before3Caller, (Object)CallerAspect.around2Caller);
        CallerTestCase.assertSame((Object)CallerAspect.around2Caller, (Object)CallerAspect.around4Caller);
        if (error) {
            CallerTestCase.assertSame((Object)CallerAspect.around4Caller, (Object)CallerAspect.throwing3Caller);
            CallerTestCase.assertNull((Object)CallerAspect.after2Caller);
        } else {
            CallerTestCase.assertSame((Object)CallerAspect.around4Caller, (Object)CallerAspect.after2Caller);
            CallerTestCase.assertNull((Object)CallerAspect.throwing3Caller);
        }
        CallerTestCase.assertSame((Object)CallerAspect.around4Caller, (Object)CallerAspect.finally1Caller);
        CallerTestCase.assertSame((Object)CallerAspect.finally1Caller, (Object)CallerAspect.finally4Caller);
    }

    private void testConCallerWithException(CallType callType) {
        boolean thrown = false;
        try {
            new TargetCallerPOJO(callType, true);
        }
        catch (POJOException e) {
            thrown = true;
        }
        CallerTestCase.assertTrue((boolean)thrown);
        this.assertAllAdvices(thrown);
    }
}

