/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import org.jboss.aop.instrument.FieldAccessTransformer;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.JoinpointClassification;
import org.jboss.aop.instrument.OptimizedFieldInvocations;

public class OptimizedFieldAccessTransformer
extends FieldAccessTransformer {
    public OptimizedFieldAccessTransformer(Instrumentor instrumentor) {
        super(instrumentor);
    }

    protected void doBuildFieldWrappers(CtClass clazz, CtField field, int fieldIndex, boolean shouldReplaceArrayAccess, JoinpointClassification classificationGet, JoinpointClassification classificationSet) throws NotFoundException, CannotCompileException {
        this.instrumentor.setupBasics(clazz);
        boolean wrappedGet = classificationGet.equals(JoinpointClassification.WRAPPED);
        boolean wrappedSet = classificationSet.equals(JoinpointClassification.WRAPPED);
        int mod = this.getStaticModifiers(field);
        this.buildWrapperPlaceHolders(clazz, field, this.isPrepared(classificationGet), this.isPrepared(classificationSet), mod);
        try {
            if (this.isPrepared(classificationGet)) {
                this.addFieldReadInfoFieldWithAccessors(10, clazz, field);
                OptimizedFieldInvocations.createOptimizedInvocationClass(this.instrumentor, clazz, field, true);
                wrapper.prepareForWrapping((CtMember)field, 0);
            }
            if (this.isPrepared(classificationSet)) {
                this.addFieldWriteInfoField(10, clazz, field);
                OptimizedFieldInvocations.createOptimizedInvocationClass(this.instrumentor, clazz, field, false);
                wrapper.prepareForWrapping((CtMember)field, 1);
            }
        }
        catch (Exception e) {
            throw new CannotCompileException((Throwable)e);
        }
        if (wrappedGet) {
            wrapper.wrap((CtMember)field, 0);
            if (classificationGet.equals(JoinpointClassification.DYNAMICALY_WRAPPED)) {
                this.instrumentor.dynamicTransformationObserver.fieldReadDynamicalyWrapped(field);
            }
        }
        if (wrappedSet) {
            wrapper.wrap((CtMember)field, 1);
            if (classificationSet.equals(JoinpointClassification.DYNAMICALY_WRAPPED)) {
                this.instrumentor.dynamicTransformationObserver.fieldWriteDynamicalyWrapped(field);
            }
        }
        this.replaceFieldAccessInternally(clazz, field, wrappedGet, wrappedSet, fieldIndex);
        this.buildWrappers(clazz, field, shouldReplaceArrayAccess, wrappedGet, wrappedSet, fieldIndex);
    }

    protected String getWrapperBody(CtClass clazz, CtField field, boolean get, int index) throws NotFoundException, CannotCompileException {
        if (get) {
            return this.getReadWrapperBody(clazz, field, index);
        }
        return this.getWriteWrapperBody(clazz, field, false, index);
    }

    private String getReadWrapperBody(CtClass clazz, CtField field, int index) throws NotFoundException, CannotCompileException {
        String optimizedInvocation;
        String wrappedName = field.getName();
        try {
            optimizedInvocation = OptimizedFieldInvocations.getOptimizedInvocationClassName(clazz, field, true);
            optimizedInvocation = optimizedInvocation.substring(optimizedInvocation.lastIndexOf(46) + 1);
            optimizedInvocation = clazz.getName() + "$" + optimizedInvocation;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CannotCompileException((Throwable)e);
        }
        String infoName = OptimizedFieldAccessTransformer.getFieldReadInfoFieldName(field.getName());
        boolean isStatic = Modifier.isStatic((int)field.getModifiers());
        String code = !isStatic ? "{    " + OptimizedFieldAccessTransformer.fieldInfoFromWeakReference("info", infoName) + "    org.jboss.aop.ClassInstanceAdvisor instAdv = (org.jboss.aop.ClassInstanceAdvisor)((org.jboss.aop.InstanceAdvised)$1)._getInstanceAdvisor();" + "    org.jboss.aop.advice.Interceptor[] interceptors = info.getInterceptors(); " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null || (instAdv != null && instAdv.hasInstanceAspects))" + "    { " + "       if (instAdv != null) " + "       { " + "          interceptors = instAdv.getInterceptors(interceptors); " + "       } " + "       " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + "aop$classAdvisor$aop" + ".getAdvisedFields()[" + index + "]," + index + ", interceptors); " + "       invocation.setTargetObject($1); " + "       invocation.typedTargetObject = (" + clazz.getName() + ")$1; " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       return ($r)invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       return ((" + clazz.getName() + ")$1)." + wrappedName + ";" + "    }" + "}" : "{     org.jboss.aop.advice.Interceptor[] interceptors = aop$classAdvisor$aop.getFieldReadInfos()[" + index + "].getInterceptors(); " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null) " + "    { " + "    " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + "aop$classAdvisor$aop" + ".getAdvisedFields()[" + index + "]," + index + ", interceptors); " + "       invocation.setTargetObject($1); " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       return ($r)invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       return " + clazz.getName() + "." + wrappedName + ";" + "    }" + "}";
        return code;
    }

    private String getWriteWrapperBody(CtClass clazz, CtField field, boolean shouldReplaceArrayAccess, int index) throws NotFoundException, CannotCompileException {
        String code;
        String optimizedInvocation;
        String wrappedName = field.getName();
        try {
            optimizedInvocation = OptimizedFieldInvocations.getOptimizedInvocationClassName(clazz, field, false);
            optimizedInvocation = optimizedInvocation.substring(optimizedInvocation.lastIndexOf(46) + 1);
            optimizedInvocation = clazz.getName() + "$" + optimizedInvocation;
        }
        catch (Exception e) {
            throw new CannotCompileException((Throwable)e);
        }
        String infoName = OptimizedFieldAccessTransformer.getFieldWriteInfoFieldName(field.getName());
        boolean isStatic = Modifier.isStatic((int)field.getModifiers());
        if (!isStatic) {
            String targetString = "((" + clazz.getName() + ")$1)";
            String fieldString = targetString + "." + field.getName();
            code = "{    " + this.getArrayWriteRegistration(shouldReplaceArrayAccess, targetString, field, fieldString, "$2") + "   " + OptimizedFieldAccessTransformer.fieldInfoFromWeakReference("info", infoName) + "    org.jboss.aop.ClassInstanceAdvisor instAdv = (org.jboss.aop.ClassInstanceAdvisor)((org.jboss.aop.InstanceAdvised)$1)._getInstanceAdvisor();" + "    org.jboss.aop.advice.Interceptor[] interceptors = info.getInterceptors();" + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null || (instAdv != null && instAdv.hasInstanceAspects)) " + "    { " + "       if (instAdv != null) " + "       { " + "          interceptors = instAdv.getInterceptors(interceptors); " + "       } " + "       " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + "aop$classAdvisor$aop" + ".getAdvisedFields()[" + index + "]," + index + ", ($w)$2" + ", interceptors); " + "       invocation.setTargetObject($1); " + "       invocation.typedTargetObject = (" + clazz.getName() + ")$1; " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       ((" + clazz.getName() + ")$1)." + wrappedName + "=$2" + ";" + "    }" + "}";
        } else {
            String targetString = "java.lang.Class.forName(\"" + clazz.getName() + "\")";
            String fieldString = clazz.getName() + "." + field.getName();
            code = "{     " + this.getArrayWriteRegistration(shouldReplaceArrayAccess, targetString, field, fieldString, "$2") + "    org.jboss.aop.advice.Interceptor[] interceptors = " + "aop$classAdvisor$aop" + ".getFieldWriteInfos()[" + index + "].getInterceptors(); " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null) " + "    { " + "       " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + "aop$classAdvisor$aop" + ".getAdvisedFields()[" + index + "]," + index + ", ($w)$2" + ", interceptors); " + "       invocation.setTargetObject($1); " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       " + clazz.getName() + "." + wrappedName + "=$2" + ";" + "    }" + "}";
        }
        return code;
    }

    private void buildWrappers(CtClass clazz, CtField field, boolean shouldReplaceArrayAccess, boolean doGet, boolean doSet, int index) throws NotFoundException, CannotCompileException {
        CtMethod method;
        String code;
        if (doGet) {
            code = this.getReadWrapperBody(clazz, field, index);
            method = clazz.getDeclaredMethod(OptimizedFieldAccessTransformer.fieldRead(field.getName()));
            method.setBody(code);
        }
        if (doSet) {
            code = this.getWriteWrapperBody(clazz, field, shouldReplaceArrayAccess, index);
            method = clazz.getDeclaredMethod(OptimizedFieldAccessTransformer.fieldWrite(field.getName()));
            method.setBody(code);
        }
    }

    protected void replaceFieldAccessInternally(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) throws CannotCompileException {
        OptimizedFieldAccessExprEditor expr = new OptimizedFieldAccessExprEditor(clazz, field, doGet, doSet, index);
        clazz.instrument((ExprEditor)expr);
    }

    protected class OptimizedFieldAccessExprEditor
    extends FieldAccessTransformer.FieldAccessExprEditor {
        public OptimizedFieldAccessExprEditor(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) {
            super(OptimizedFieldAccessTransformer.this, clazz, field, doGet, doSet, index);
        }

        protected void replaceRead(FieldAccess fieldAccess) throws CannotCompileException {
            if (fieldAccess.isStatic()) {
                String code = "    {        $_ = ($r)" + FieldAccessTransformer.fieldRead(this.field.getName()) + "(null);" + "    } " + "";
                fieldAccess.replace(code);
            } else {
                String code = "    {        $_ = ($r)" + FieldAccessTransformer.fieldRead(this.field.getName()) + "($0);" + "    } " + "";
                fieldAccess.replace(code);
            }
        }

        protected void replaceWrite(FieldAccess fieldAccess) throws CannotCompileException {
            String fieldWrite = FieldAccessTransformer.fieldWrite(this.field.getName());
            if (fieldAccess.isStatic()) {
                String code = "    {        " + fieldWrite + "(null, $1);" + "    } " + "";
                fieldAccess.replace(code);
            } else {
                String code = "    {        " + fieldWrite + "($0, $1);" + "    } " + "";
                fieldAccess.replace(code);
            }
        }
    }
}

