/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import gnu.trove.TLongObjectHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ConByConInfo;
import org.jboss.aop.ConByMethodInfo;
import org.jboss.aop.ConstructionInfo;
import org.jboss.aop.ConstructorInfo;
import org.jboss.aop.Domain;
import org.jboss.aop.FieldInfo;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.MethodByConInfo;
import org.jboss.aop.MethodByMethodInfo;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.MethodInterceptors;
import org.jboss.aop.MethodMatchInfo;
import org.jboss.aop.SecurityActions;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.GeneratedAdvisorInterceptor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.PrecedenceSorter;
import org.jboss.aop.instrument.ConByConJoinPointGenerator;
import org.jboss.aop.instrument.ConByMethodJoinPointGenerator;
import org.jboss.aop.instrument.ConstructionJoinPointGenerator;
import org.jboss.aop.instrument.ConstructorJoinPointGenerator;
import org.jboss.aop.instrument.FieldJoinPointGenerator;
import org.jboss.aop.instrument.JoinPointGenerator;
import org.jboss.aop.instrument.MethodByConJoinPointGenerator;
import org.jboss.aop.instrument.MethodByMethodJoinPointGenerator;
import org.jboss.aop.instrument.MethodJoinPointGenerator;
import org.jboss.aop.joinpoint.FieldJoinpoint;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodJoinpoint;
import org.jboss.aop.pointcut.PointcutMethodMatch;
import org.jboss.aop.util.UnmodifiableEmptyCollections;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedClassAdvisor
extends ClassAdvisor {
    public static final String ADD_METHOD_INFO = "addMethodInfo";
    public static final String ADD_CONSTRUCTOR_INFO = "addConstructorInfo";
    public static final String ADD_CONSTRUCTION_INFO = "addConstructionInfo";
    public static final String ADD_FIELD_READ_INFO = "addFieldReadInfo";
    public static final String ADD_FIELD_WRITE_INFO = "addFieldWriteInfo";
    public static final String GET_PARENT_ADVISOR = "getParentAdvisor";
    private static final Logger logger = Logger.getLogger(GeneratedClassAdvisor.class);
    ArrayList<MethodInfo> overriddenMethods = new ArrayList();
    private volatile ConcurrentHashMap<Joinpoint, JoinPointGenerator> joinPointGenerators = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    private volatile ConcurrentHashMap<Joinpoint, FieldJoinPointGenerator> fieldReadJoinPoinGenerators = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    private volatile ConcurrentHashMap<Joinpoint, ConstructorJoinPointGenerator> constructionJoinPointGenerators = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    private volatile ConcurrentHashMap<Joinpoint, ConcurrentHashMap<Class<?>, JoinPointGenerator>> methodCalledByXXXJoinPointGenerators = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    ConcurrentHashMap<Joinpoint, Interceptor[]> oldInfos = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    ConcurrentHashMap<Joinpoint, Interceptor[]> oldFieldReadInfos = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    ConcurrentHashMap<Joinpoint, Interceptor[]> oldConstructionInfos = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    boolean initialisedSuperClasses;
    private int version;
    AdvisorStrategy advisorStrategy;
    ConcurrentHashMap<AspectDefinition, Map<Joinpoint, Object>> perClassJoinpointAspectDefinitions = new ConcurrentHashMap();

    protected GeneratedClassAdvisor(String classname) {
        super(classname, null);
        this.advisorStrategy = new ClassAdvisorStrategy();
    }

    protected GeneratedClassAdvisor(String classname, GeneratedClassAdvisor parent) {
        super(classname, null);
        this.advisorStrategy = new InstanceAdvisorStrategy(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        Map<Domain, Object> subscribedSubDomains;
        super.cleanup();
        this.methodInfos = null;
        this.advisorStrategy = null;
        Map<Domain, Object> map = subscribedSubDomains = this.getManager().getSubscribedSubDomains();
        synchronized (map) {
            Iterator<Domain> it = subscribedSubDomains.keySet().iterator();
            while (it.hasNext()) {
                if (it.next() == null) continue;
                it.remove();
            }
        }
    }

    protected void initialise(Class<?> clazz, AspectManager manager) {
        this.advisorStrategy.initialise(clazz, manager);
    }

    protected void initialiseCallers() {
    }

    protected void initialiseInfosForInstance() {
    }

    protected MethodInfo copyInfoFromClassAdvisor(MethodInfo info) {
        MethodInfo copy = (MethodInfo)info.copy();
        copy.setAdvisor(this);
        this.addMethodInfo(copy);
        return copy;
    }

    protected FieldInfo copyInfoFromClassAdvisor(FieldInfo info) {
        FieldInfo copy = (FieldInfo)info.copy();
        copy.setAdvisor(this);
        return copy;
    }

    protected ConByConInfo copyInfoFromClassAdvisor(ConByConInfo info) {
        ConByConInfo copy = (ConByConInfo)info.copy();
        copy.setAdvisor(this);
        return copy;
    }

    protected MethodByConInfo copyInfoFromClassAdvisor(MethodByConInfo info) {
        MethodByConInfo copy = (MethodByConInfo)info.copy();
        copy.setAdvisor(this);
        return copy;
    }

    protected ConByMethodInfo copyInfoFromClassAdvisor(ConByMethodInfo info) {
        ConByMethodInfo copy = (ConByMethodInfo)info.copy();
        copy.setAdvisor(this);
        return copy;
    }

    protected MethodByMethodInfo copyInfoFromClassAdvisor(MethodByMethodInfo info) {
        MethodByMethodInfo copy = (MethodByMethodInfo)info.copy();
        copy.setAdvisor(this);
        return copy;
    }

    @Override
    protected void rebuildInterceptors() {
        ++this.version;
        this.advisorStrategy.rebuildInterceptors();
    }

    @Override
    protected void rebuildInterceptorsForAddedBinding(AdviceBinding binding) {
        ++this.version;
        this.advisorStrategy.rebuildInterceptorsForAddedBinding(binding);
    }

    @Override
    protected void rebuildInterceptorsForRemovedBinding(AdviceBinding binding) {
        ++this.version;
        this.advisorStrategy.rebuildInterceptorsForRemovedBinding(binding);
    }

    protected synchronized void internalRebuildInterceptors() {
        super.rebuildInterceptors();
    }

    protected void checkVersion() {
        this.advisorStrategy.checkVersion();
    }

    protected void doRebuildForInstance() {
    }

    protected void handleOverriddenMethods(AdviceBinding binding) {
        if (this.overriddenMethods != null && this.overriddenMethods.size() > 0) {
            for (MethodInfo info : this.overriddenMethods) {
                Method method = info.getMethod();
                PointcutMethodMatch match = binding.getPointcut().matchesExecution((Advisor)this, method);
                if (match == null || !match.isMatch()) continue;
                this.adviceBindings.add(binding);
                if (AspectManager.verbose) {
                    logger.error("method matched binding " + binding.getPointcut().getExpr() + " " + method.toString());
                }
                binding.addAdvisor(this);
                this.pointcutResolved(info, binding, new MethodJoinpoint(method));
            }
        }
    }

    @Override
    protected void resolveMethodPointcut(AdviceBinding binding) {
        GeneratedClassAdvisor classAdvisor = this.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
        if (classAdvisor == null) {
            super.resolveMethodPointcut(binding);
            this.handleOverriddenMethods(binding);
        }
    }

    @Override
    protected void resolveFieldPointcut(FieldInfo[] newFieldInfos, Interceptor[][] fieldInterceptors, AdviceBinding binding, boolean write) {
        GeneratedClassAdvisor classAdvisor = this.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
        if (classAdvisor == null) {
            super.resolveFieldPointcut(newFieldInfos, fieldInterceptors, binding, write);
        }
    }

    @Override
    protected void resolveConstructorPointcut(AdviceBinding binding) {
        this.advisorStrategy.resolveConstructorPointcut(binding);
    }

    @Override
    protected void resolveConstructionPointcut(AdviceBinding binding) {
        this.advisorStrategy.resolveConstructionPointcut(binding);
    }

    protected void initialiseMethods() {
    }

    protected void addMethodInfo(MethodInfo mi) {
        MethodInfo old = this.methodInfos.getMethodInfo(mi.getHash());
        if (old != null) {
            this.overriddenMethods.add(old);
        }
        this.methodInfos.put(mi.getHash(), mi);
        this.advisorStrategy.makeAccessibleMethod(mi);
    }

    @Override
    protected void initializeMethodChain() {
        long[] keys = this.advisedMethods.keys();
        for (int i = 0; i < keys.length; ++i) {
            MethodMatchInfo matchInfo = this.methodInfos.getMatchInfo(keys[i]);
            if (this.initialized && matchInfo != null) {
                matchInfo.clear();
            }
            if (matchInfo != null) continue;
            MethodInfo info = new MethodInfo();
            Method amethod = (Method)this.advisedMethods.get(keys[i]);
            info.setAdvisedMethod(amethod);
            info.setUnadvisedMethod(amethod);
            info.setHash(keys[i]);
            info.setAdvisor(this);
            this.methodInfos.put(keys[i], info);
        }
    }

    protected void initialiseConstructors(Collection<ConstructorInfo> constructorInfos) {
    }

    protected void addConstructorInfo(ConstructorInfo ci, Collection<ConstructorInfo> constructorInfos) {
        constructorInfos.add(ci);
        SecurityActions.setAccessible(ci.getConstructor());
    }

    @Override
    protected void createInterceptorChains() throws Exception {
        this.advisorStrategy.createInterceptorChains();
    }

    protected void initialiseConstructions(Collection<ConstructionInfo> constructorInfos) {
    }

    protected void addConstructionInfo(ConstructionInfo ci, Collection<ConstructionInfo> constructionInfos) {
        constructionInfos.add(ci);
    }

    protected void initialiseFieldReads(Collection<FieldInfo> fieldReadInfos) {
    }

    protected void addFieldReadInfo(FieldInfo fi, Collection<FieldInfo> fieldReadInfos) {
        fieldReadInfos.add(fi);
        this.advisorStrategy.makeAccessibleField(fi);
    }

    @Override
    protected void initializeConstructorChain() {
        if (this.constructorInfos == null) {
            super.initializeConstructorChain();
        }
    }

    @Override
    protected void initializeConstructionChain() {
        if (this.constructionInfos == null) {
            super.initializeConstructionChain();
        }
    }

    @Override
    protected void initializeFieldReadChain() {
        this.fieldReadInfos = this.mergeFieldInfos(this.fieldReadInfos, true);
    }

    protected void initialiseFieldWrites(Collection<FieldInfo> fieldWriteInfos) {
    }

    protected void addFieldWriteInfo(FieldInfo fi, Collection<FieldInfo> fieldWriteInfos) {
        fieldWriteInfos.add(fi);
        this.advisorStrategy.makeAccessibleField(fi);
    }

    @Override
    protected void initializeFieldWriteChain() {
        this.fieldWriteInfos = this.mergeFieldInfos(this.fieldWriteInfos, false);
    }

    private FieldInfo[] mergeFieldInfos(FieldInfo[] advisedInfos, boolean read) {
        FieldInfo[] newInfos = new FieldInfo[this.advisedFields.length];
        int nextIndex = 0;
        int advisedInfosLength = advisedInfos == null ? 0 : advisedInfos.length;
        for (int i = 0; i < this.advisedFields.length; ++i) {
            if (nextIndex < advisedInfosLength && advisedInfos[nextIndex].getIndex() == i) {
                if (this.initialized) {
                    advisedInfos[nextIndex].clear();
                }
                newInfos[i] = advisedInfos[nextIndex];
                ++nextIndex;
                continue;
            }
            FieldInfo info = new FieldInfo((Advisor)this, read);
            info.setAdvisedField(this.advisedFields[i]);
            info.setIndex(i);
            newInfos[i] = info;
        }
        return newInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalizeChains() {
        GeneratedClassAdvisor classAdvisor = this.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
        if (classAdvisor != null) {
            Set set = this.adviceBindings;
            synchronized (set) {
                this.adviceBindings.addAll(classAdvisor.adviceBindings);
                if (this.adviceBindings.size() > 0) {
                    for (AdviceBinding binding : this.adviceBindings) {
                        binding.addAdvisor(this);
                    }
                }
            }
        }
        this.finalizeMethodChain();
        this.finalizeFieldReadChain();
        this.finalizeFieldWriteChain();
        this.advisorStrategy.finalizeConstructorChain(this.constructorInfos);
        this.advisorStrategy.finalizeConstructionChain(this.constructionInfos);
    }

    @Override
    protected void finalizeMethodChain() {
        GeneratedClassAdvisor classAdvisor = this.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
        if (classAdvisor != null) {
            this.easyFinalizeMethodChainForInstance(classAdvisor, this.methodInfos);
        } else {
            this.fullWorkFinalizeMethodChain(this.methodInfos);
        }
    }

    private void easyFinalizeMethodChainForInstance(ClassAdvisor classAdvisor, MethodInterceptors newMethodInterceptors) {
        long[] keys = newMethodInterceptors.keys();
        for (int i = 0; i < keys.length; ++i) {
            MethodInfo classMethodInfo = classAdvisor.getMethodInfo(keys[i]);
            MethodMatchInfo matchInfo = newMethodInterceptors.getMatchInfo(keys[i]);
            MethodInfo myMethodInfo = matchInfo.getInfo();
            myMethodInfo.cloneChains(classMethodInfo);
            if (!this.updateOldInfo(this.oldInfos, myMethodInfo, OldInfoMaps.INFOS)) continue;
            MethodJoinPointGenerator generator = this.getJoinPointGenerator(myMethodInfo);
            generator.rebindJoinpoint(myMethodInfo);
        }
    }

    private void fullWorkFinalizeMethodChain(MethodInterceptors newMethodInterceptors) {
        TLongObjectHashMap newMethodInfos = new TLongObjectHashMap();
        long[] keys = newMethodInterceptors.keys();
        for (int i = 0; i < keys.length; ++i) {
            MethodMatchInfo matchInfo = newMethodInterceptors.getMatchInfo(keys[i]);
            matchInfo.populateBindings();
            MethodInfo info = matchInfo.getInfo();
            newMethodInfos.put(keys[i], info);
            MethodJoinPointGenerator generator = this.getJoinPointGenerator(info);
            this.finalizeChainAndRebindJoinPoint(this.oldInfos, info, generator, OldInfoMaps.INFOS);
        }
        if (AspectManager.maintainAdvisorMethodInterceptors) {
            this.methodInterceptors = newMethodInfos;
        }
        if (this.overriddenMethods != null && this.overriddenMethods.size() > 0) {
            for (MethodInfo info : this.overriddenMethods) {
                MethodJoinPointGenerator generator = this.getJoinPointGenerator(info);
                this.finalizeChainAndRebindJoinPoint(this.oldInfos, info, generator, OldInfoMaps.INFOS);
            }
        }
    }

    private void finalizeFieldReadChain() {
        GeneratedClassAdvisor classAdvisor = this.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
        if (classAdvisor != null) {
            this.easyFinalizeFieldChainForInstance(this.oldFieldReadInfos, classAdvisor.getFieldReadInfos(), this.fieldReadInfos, OldInfoMaps.FIELD_READ_INFOS);
        } else {
            this.fullWorkFinalizeFieldChain(this.oldFieldReadInfos, this.fieldReadInfos, OldInfoMaps.FIELD_READ_INFOS);
        }
    }

    protected void finalizeFieldWriteChain() {
        GeneratedClassAdvisor classAdvisor = this.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
        if (classAdvisor != null) {
            this.easyFinalizeFieldChainForInstance(this.oldInfos, classAdvisor.getFieldWriteInfos(), this.fieldWriteInfos, OldInfoMaps.INFOS);
        } else {
            this.fullWorkFinalizeFieldChain(this.oldInfos, this.fieldWriteInfos, OldInfoMaps.INFOS);
        }
    }

    private void easyFinalizeFieldChainForInstance(Map<Joinpoint, Interceptor[]> oldFieldInfos, FieldInfo[] classFieldInfos, FieldInfo[] newFieldInfos, OldInfoMaps oldInfoMapInstance) {
        for (int i = 0; i < newFieldInfos.length; ++i) {
            FieldInfo myInfo = newFieldInfos[i];
            myInfo.cloneChains(classFieldInfos[i]);
            if (!this.updateOldInfo(oldFieldInfos, myInfo, oldInfoMapInstance)) continue;
            FieldJoinPointGenerator generator = this.getJoinPointGenerator(myInfo);
            generator.rebindJoinpoint(myInfo);
        }
    }

    private void fullWorkFinalizeFieldChain(Map<Joinpoint, Interceptor[]> oldFieldInfos, FieldInfo[] newFieldInfos, OldInfoMaps oldInfoMapInstance) {
        for (int i = 0; i < newFieldInfos.length; ++i) {
            FieldInfo info = newFieldInfos[i];
            FieldJoinPointGenerator generator = this.getJoinPointGenerator(info);
            this.finalizeChainAndRebindJoinPoint(oldFieldInfos, info, generator, oldInfoMapInstance);
        }
    }

    @Override
    protected void finalizeMethodCalledByMethodInterceptorChain(MethodByMethodInfo info) {
        MethodByMethodJoinPointGenerator generator = this.getJoinPointGenerator(info);
        this.finalizeChainAndRebindJoinPoint(this.oldInfos, info, generator, OldInfoMaps.INFOS);
    }

    @Override
    protected void finalizeConCalledByMethodInterceptorChain(ConByMethodInfo info) {
        ConByMethodJoinPointGenerator generator = this.getJoinPointGenerator(info);
        this.finalizeChainAndRebindJoinPoint(this.oldInfos, info, generator, OldInfoMaps.INFOS);
    }

    @Override
    protected void finalizeConCalledByConInterceptorChain(ConByConInfo info) {
        ConByConJoinPointGenerator generator = this.getJoinPointGenerator(info);
        this.finalizeChainAndRebindJoinPoint(this.oldInfos, info, generator, OldInfoMaps.INFOS);
    }

    @Override
    protected void finalizeMethodCalledByConInterceptorChain(MethodByConInfo info) {
        MethodByConJoinPointGenerator generator = this.getJoinPointGenerator(info);
        this.finalizeChainAndRebindJoinPoint(this.oldInfos, info, generator, OldInfoMaps.INFOS);
    }

    private JoinPointGenerator getJoinPointGenerator(JoinPointInfo info) {
        if (info instanceof MethodInfo) {
            return this.getJoinPointGenerator((MethodInfo)info);
        }
        if (info instanceof FieldInfo) {
            return this.getJoinPointGenerator((FieldInfo)info);
        }
        if (info instanceof ConstructionInfo) {
            return this.getJoinPointGenerator((ConstructionInfo)info);
        }
        if (info instanceof ConstructorInfo) {
            return this.getJoinPointGenerator((ConstructorInfo)info);
        }
        if (info instanceof ConByConInfo) {
            return this.getJoinPointGenerator((ConByConInfo)info);
        }
        if (info instanceof ConByMethodInfo) {
            return this.getJoinPointGenerator((ConByMethodInfo)info);
        }
        if (info instanceof MethodByMethodInfo) {
            return this.getJoinPointGenerator((MethodByMethodInfo)info);
        }
        if (info instanceof MethodByConInfo) {
            return this.getJoinPointGenerator((MethodByConInfo)info);
        }
        throw new RuntimeException("Invalid JoinPointInfo passed in: " + info.getClass().getName());
    }

    protected MethodJoinPointGenerator getJoinPointGenerator(MethodInfo info) {
        return this.advisorStrategy.getJoinPointGenerator(info);
    }

    protected FieldJoinPointGenerator getJoinPointGenerator(FieldInfo info) {
        return this.advisorStrategy.getJoinPointGenerator(info);
    }

    protected ConstructorJoinPointGenerator getJoinPointGenerator(ConstructorInfo info) {
        return this.advisorStrategy.getJoinPointGenerator(info);
    }

    protected ConstructionJoinPointGenerator getJoinPointGenerator(ConstructionInfo info) {
        return this.advisorStrategy.getJoinPointGenerator(info);
    }

    protected MethodByMethodJoinPointGenerator getJoinPointGenerator(MethodByMethodInfo info) {
        return this.advisorStrategy.getJoinPointGenerator(info);
    }

    protected ConByMethodJoinPointGenerator getJoinPointGenerator(ConByMethodInfo info) {
        return this.advisorStrategy.getJoinPointGenerator(info);
    }

    protected ConByConJoinPointGenerator getJoinPointGenerator(ConByConInfo info) {
        return this.advisorStrategy.getJoinPointGenerator(info);
    }

    protected MethodByConJoinPointGenerator getJoinPointGenerator(MethodByConInfo info) {
        return this.advisorStrategy.getJoinPointGenerator(info);
    }

    @Override
    protected void pointcutResolved(JoinPointInfo info, AdviceBinding binding, Joinpoint joinpoint) {
        ArrayList<Interceptor> curr = info.getInterceptorChain();
        if (binding.getCFlow() != null) {
            InterceptorFactory[] factories = binding.getInterceptorFactories();
            for (int i = 0; i < factories.length; ++i) {
                curr.add(new GeneratedAdvisorInterceptor(factories[i], this, joinpoint, binding.getCFlowString(), binding.getCFlow()));
            }
        } else {
            InterceptorFactory[] factories = binding.getInterceptorFactories();
            for (int i = 0; i < factories.length; ++i) {
                curr.add(new GeneratedAdvisorInterceptor(factories[i], this, joinpoint));
            }
        }
    }

    private void finalizeChainAndRebindJoinPoint(Map<Joinpoint, Interceptor[]> oldInfos, JoinPointInfo info, JoinPointGenerator generator, OldInfoMaps oldInfoMapInstance) {
        this.adjustInfoForAddedBinding(info);
        ArrayList<Interceptor> list = info.getInterceptorChain();
        GeneratedAdvisorInterceptor[] factories = null;
        if (list.size() > 0) {
            factories = this.applyPrecedence(list.toArray(new GeneratedAdvisorInterceptor[list.size()]));
        }
        info.setInterceptors(factories);
        if (this.updateOldInfo(oldInfos, info, oldInfoMapInstance)) {
            generator.rebindJoinpoint(info);
        }
    }

    public String toString() {
        Class<?> clazz = this.getClass();
        StringBuffer sb = new StringBuffer("CLASS: " + clazz.getName());
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            sb.append("\n\t" + fields[i]);
        }
        return sb.toString();
    }

    GeneratedAdvisorInterceptor[] applyPrecedence(GeneratedAdvisorInterceptor[] interceptors) {
        return PrecedenceSorter.applyPrecedence(interceptors, this.manager);
    }

    @Override
    public Object getPerClassAspect(AspectDefinition def) {
        return this.advisorStrategy.getPerClassAspect(def);
    }

    public Object getPerClassJoinpointAspect(AspectDefinition def, Joinpoint joinpoint) {
        return this.advisorStrategy.getPerClassJoinpointAspect(def, joinpoint);
    }

    public synchronized void addPerClassJoinpointAspect(AspectDefinition def, Joinpoint joinpoint) {
        Map<Joinpoint, Object> joinpoints = this.perClassJoinpointAspectDefinitions.get(def);
        if (joinpoints == null) {
            joinpoints = new ConcurrentHashMap<Joinpoint, Object>();
            this.perClassJoinpointAspectDefinitions.put(def, joinpoints);
        }
        if (!joinpoints.containsKey(joinpoint)) {
            Object aspect = def.getFactory().createPerJoinpoint(this, joinpoint);
            if (aspect == null) {
                joinpoints.put(joinpoint, NULL_ASPECT);
            } else {
                joinpoints.put(joinpoint, aspect);
            }
        }
        def.registerAdvisor(this);
    }

    public synchronized void removePerClassJoinpointAspect(AspectDefinition def) {
        this.perClassJoinpointAspectDefinitions.remove(def);
    }

    @Override
    public boolean chainOverridingForInheritedMethods() {
        return true;
    }

    @Override
    public Object getFieldAspect(FieldJoinpoint joinpoint, AspectDefinition def) {
        Object instance = this.getPerClassJoinpointAspect(def, joinpoint);
        if (instance == null) {
            this.addPerClassJoinpointAspect(def, joinpoint);
            instance = this.getPerClassJoinpointAspect(def, joinpoint);
        }
        return instance;
    }

    private GeneratedClassAdvisor getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices() {
        return this.advisorStrategy.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
    }

    @Override
    protected void createMethodTables() throws Exception {
        this.advisorStrategy.createMethodTables();
    }

    @Override
    protected void createFieldTable() throws Exception {
        this.advisorStrategy.createFieldTable();
    }

    @Override
    protected void createConstructorTables() throws Exception {
        this.advisorStrategy.createConstructorTables();
    }

    @Override
    public Set<AspectDefinition> getPerInstanceAspectDefinitions() {
        return this.advisorStrategy.getPerInstanceAspectDefinitions();
    }

    @Override
    public Map<AspectDefinition, Set<Joinpoint>> getPerInstanceJoinpointAspectDefinitions() {
        return this.advisorStrategy.getPerInstanceJoinpointAspectDefinitions();
    }

    private boolean updateOldInfo(Map<Joinpoint, Interceptor[]> oldInfos, JoinPointInfo newInfo, OldInfoMaps oldInfoMapInstance) {
        Interceptor[] oldChain = oldInfos.get(newInfo.getJoinpoint());
        if (oldChain != null && newInfo.equalChains(oldChain)) {
            return false;
        }
        Interceptor[] currentOldChain = newInfo.getInterceptors();
        if (oldInfoMapInstance == OldInfoMaps.INFOS) {
            oldInfos = this.initOldInfosMap();
        } else if (oldInfoMapInstance == OldInfoMaps.FIELD_READ_INFOS) {
            oldInfos = this.initOldFieldReadInfosMap();
        } else if (oldInfoMapInstance == OldInfoMaps.CONSTRUCTION_INFOS) {
            oldInfos = this.initOldConstructionInfosMap();
        } else {
            throw new RuntimeException("Unrecognised map");
        }
        if (currentOldChain != null) {
            oldInfos.put(newInfo.getJoinpoint(), currentOldChain);
        } else if (oldChain != null) {
            oldInfos.remove(newInfo.getJoinpoint());
        }
        return true;
    }

    protected void generateJoinPointClass(MethodInfo info) {
        MethodJoinPointGenerator generator = this.getJoinPointGenerator(info);
        generator.generateJoinPointClass(this.getClassLoader(), info);
    }

    protected void generateJoinPointClass(FieldInfo info) {
        FieldJoinPointGenerator generator = this.getJoinPointGenerator(info);
        generator.generateJoinPointClass(this.getClassLoader(), info);
    }

    protected void generateJoinPointClass(ConstructorInfo info) {
        ConstructorJoinPointGenerator generator = this.getJoinPointGenerator(info);
        generator.generateJoinPointClass(this.getClassLoader(), info);
    }

    protected void generateJoinPointClass(ConstructionInfo info) {
        ConstructionJoinPointGenerator generator = this.getJoinPointGenerator(info);
        generator.generateJoinPointClass(this.getClassLoader(), info);
    }

    protected void generateJoinPointClass(MethodByMethodInfo info) {
        MethodByMethodJoinPointGenerator generator = this.getJoinPointGenerator(info);
        generator.generateJoinPointClass(this.getClassLoader(), info);
    }

    protected void generateJoinPointClass(ConByMethodInfo info) {
        ConByMethodJoinPointGenerator generator = this.getJoinPointGenerator(info);
        generator.generateJoinPointClass(this.getClassLoader(), info);
    }

    protected void generateJoinPointClass(ConByConInfo info) {
        ConByConJoinPointGenerator generator = this.getJoinPointGenerator(info);
        generator.generateJoinPointClass(this.getClassLoader(), info);
    }

    protected void generateJoinPointClass(MethodByConInfo info) {
        MethodByConJoinPointGenerator generator = this.getJoinPointGenerator(info);
        generator.generateJoinPointClass(this.getClassLoader(), info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object rebindJoinPointWithInstanceInformation(JoinPointInfo info) {
        info.getInterceptorChainReadWriteLock().readLock().lock();
        try {
            JoinPointGenerator generator = this.getJoinPointGenerator(info);
            generator.rebindJoinpoint(info);
            Object object = generator.generateJoinPointClass(this.getClassLoader(), info);
            return object;
        }
        finally {
            info.getInterceptorChainReadWriteLock().readLock().unlock();
        }
    }

    public Object createAndRebindJoinPointForInstance(JoinPointInfo info) {
        JoinPointInfo newinfo = info.copy();
        newinfo.setAdvisor(this);
        return this.rebindJoinPointWithInstanceInformation(newinfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initJoinPointGeneratorsMap() {
        if (this.joinPointGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.joinPointGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.joinPointGenerators = new ConcurrentHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFieldReadJoinPointGeneratorsMap() {
        if (this.fieldReadJoinPoinGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.fieldReadJoinPoinGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.fieldReadJoinPoinGenerators = new ConcurrentHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initConstructionJoinPointGeneratorsMap() {
        if (this.constructionJoinPointGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.constructionJoinPointGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.constructionJoinPointGenerators = new ConcurrentHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMethodCalledByConJoinPointGeneratorsMap() {
        if (this.methodCalledByXXXJoinPointGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.methodCalledByXXXJoinPointGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.methodCalledByXXXJoinPointGenerators = new ConcurrentHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConcurrentHashMap<Joinpoint, Interceptor[]> initOldInfosMap() {
        if (this.oldInfos == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.oldInfos == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.oldInfos = new ConcurrentHashMap();
                }
            }
        }
        return this.oldInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConcurrentHashMap<Joinpoint, Interceptor[]> initOldFieldReadInfosMap() {
        if (this.oldFieldReadInfos == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.oldFieldReadInfos == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.oldFieldReadInfos = new ConcurrentHashMap();
                }
            }
        }
        return this.oldFieldReadInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConcurrentHashMap<Joinpoint, Interceptor[]> initOldConstructionInfosMap() {
        if (this.oldConstructionInfos == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.oldConstructionInfos == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.oldConstructionInfos = new ConcurrentHashMap();
                }
            }
        }
        return this.oldConstructionInfos;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OldInfoMaps {
        INFOS,
        FIELD_READ_INFOS,
        CONSTRUCTION_INFOS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InstanceAdvisorStrategy
    implements AdvisorStrategy {
        GeneratedClassAdvisor parent;
        boolean needsRebuild = true;

        public InstanceAdvisorStrategy(GeneratedClassAdvisor parent) {
            this.parent = parent;
            GeneratedClassAdvisor.this.version = parent.version;
        }

        @Override
        public void initialise(Class<?> clazz, AspectManager manager) {
            GeneratedClassAdvisor.this.initialiseInfosForInstance();
            GeneratedClassAdvisor.super.setManager(manager);
            manager.initialiseClassAdvisor(clazz, GeneratedClassAdvisor.this);
        }

        @Override
        public void checkVersion() {
            if (this.needsRebuild || this.parent.version != GeneratedClassAdvisor.this.version) {
                GeneratedClassAdvisor.this.doRebuildForInstance();
                this.needsRebuild = false;
            }
        }

        @Override
        public void createInterceptorChains() throws Exception {
            if (GeneratedClassAdvisor.this.initialized) {
                GeneratedClassAdvisor.super.createInterceptorChains();
            } else {
                GeneratedClassAdvisor.this.initialized = true;
            }
        }

        @Override
        public MethodJoinPointGenerator getJoinPointGenerator(MethodInfo info) {
            return this.parent.getJoinPointGenerator(info);
        }

        @Override
        public FieldJoinPointGenerator getJoinPointGenerator(FieldInfo info) {
            return this.parent.getJoinPointGenerator(info);
        }

        @Override
        public ConstructorJoinPointGenerator getJoinPointGenerator(ConstructorInfo info) {
            return this.parent.getJoinPointGenerator(info);
        }

        @Override
        public ConstructionJoinPointGenerator getJoinPointGenerator(ConstructionInfo info) {
            return this.parent.getJoinPointGenerator(info);
        }

        @Override
        public MethodByMethodJoinPointGenerator getJoinPointGenerator(MethodByMethodInfo info) {
            return this.parent.getJoinPointGenerator(info);
        }

        @Override
        public ConByMethodJoinPointGenerator getJoinPointGenerator(ConByMethodInfo info) {
            return this.parent.getJoinPointGenerator(info);
        }

        @Override
        public ConByConJoinPointGenerator getJoinPointGenerator(ConByConInfo info) {
            return this.parent.getJoinPointGenerator(info);
        }

        @Override
        public MethodByConJoinPointGenerator getJoinPointGenerator(MethodByConInfo info) {
            return this.parent.getJoinPointGenerator(info);
        }

        @Override
        public Object getPerClassAspect(AspectDefinition def) {
            Object aspect = this.parent.getPerClassAspect(def);
            if (aspect != null) {
                return aspect;
            }
            return GeneratedClassAdvisor.super.getPerClassAspect(def);
        }

        @Override
        public Object getPerClassJoinpointAspect(AspectDefinition def, Joinpoint joinpoint) {
            Object aspect = this.parent.getPerClassJoinpointAspect(def, joinpoint);
            if (aspect != null) {
                return aspect;
            }
            return this.parent.getPerClassJoinpointAspect(def, joinpoint);
        }

        @Override
        public GeneratedClassAdvisor getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices() {
            if (((Domain)GeneratedClassAdvisor.this.getManager()).hasOwnDataWithEffectOnAdvices()) {
                return null;
            }
            return this.parent;
        }

        @Override
        public void createMethodTables() throws Exception {
            GeneratedClassAdvisor.this.unadvisedMethods = this.parent.unadvisedMethods;
            GeneratedClassAdvisor.this.advisedMethods = this.parent.advisedMethods;
        }

        @Override
        public void createFieldTable() throws Exception {
            GeneratedClassAdvisor.this.advisedFields = this.parent.advisedFields;
        }

        @Override
        public void createConstructorTables() throws Exception {
            GeneratedClassAdvisor.this.constructors = this.parent.constructors;
            GeneratedClassAdvisor.this.methodCalledByConBindings = new HashMap[GeneratedClassAdvisor.this.constructors.length];
            GeneratedClassAdvisor.this.methodCalledByConInterceptors = new HashMap[GeneratedClassAdvisor.this.constructors.length];
            GeneratedClassAdvisor.this.conCalledByConBindings = new HashMap[GeneratedClassAdvisor.this.constructors.length];
            GeneratedClassAdvisor.this.conCalledByConInterceptors = new HashMap[GeneratedClassAdvisor.this.constructors.length];
        }

        @Override
        public Set<AspectDefinition> getPerInstanceAspectDefinitions() {
            return this.parent.getPerInstanceAspectDefinitions();
        }

        @Override
        public Map<AspectDefinition, Set<Joinpoint>> getPerInstanceJoinpointAspectDefinitions() {
            return this.parent.getPerInstanceJoinpointAspectDefinitions();
        }

        @Override
        public synchronized void rebuildInterceptors() {
            if (this.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices() != null && GeneratedClassAdvisor.this.version != this.parent.version) {
                GeneratedClassAdvisor.this.adviceBindings.clear();
                this.needsRebuild = true;
            } else if (GeneratedClassAdvisor.this.fieldReadInfos == null) {
                try {
                    GeneratedClassAdvisor.this.createInterceptorChains();
                }
                catch (Exception ex) {
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            } else {
                GeneratedClassAdvisor.super.rebuildInterceptors();
            }
        }

        @Override
        public void rebuildInterceptorsForAddedBinding(AdviceBinding binding) {
            if (this.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices() != null && GeneratedClassAdvisor.this.version != this.parent.version) {
                GeneratedClassAdvisor.this.adviceBindings.clear();
                this.needsRebuild = true;
            } else if (!GeneratedClassAdvisor.this.initialized) {
                try {
                    GeneratedClassAdvisor.this.createInterceptorChains();
                }
                catch (Exception ex) {
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            } else {
                GeneratedClassAdvisor.super.rebuildInterceptorsForAddedBinding(binding);
            }
        }

        @Override
        public void rebuildInterceptorsForRemovedBinding(AdviceBinding binding) {
            if (this.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices() != null && GeneratedClassAdvisor.this.version != this.parent.version) {
                GeneratedClassAdvisor.this.adviceBindings.clear();
                this.needsRebuild = true;
            } else if (!GeneratedClassAdvisor.this.initialized) {
                try {
                    GeneratedClassAdvisor.this.createInterceptorChains();
                }
                catch (Exception ex) {
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            } else {
                GeneratedClassAdvisor.super.rebuildInterceptorsForRemovedBinding(binding);
            }
        }

        @Override
        public void resolveConstructorPointcut(AdviceBinding binding) {
        }

        @Override
        public void resolveConstructionPointcut(AdviceBinding binding) {
        }

        @Override
        public void finalizeConstructorChain(ConstructorInfo[] newConstructorInfos) {
        }

        @Override
        public void finalizeConstructionChain(ConstructionInfo[] newConstructionInfos) {
        }

        @Override
        public void makeAccessibleField(FieldInfo fi) {
        }

        @Override
        public void makeAccessibleMethod(MethodInfo mi) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassAdvisorStrategy
    implements AdvisorStrategy {
        GeneratedClassAdvisor parent;

        private ClassAdvisorStrategy() {
        }

        @Override
        public void initialise(Class<?> clazz, AspectManager manager) {
            GeneratedClassAdvisor.this.methodInfos = new MethodInterceptors(GeneratedClassAdvisor.this);
            GeneratedClassAdvisor.this.initialiseMethods();
            ArrayList<ConstructorInfo> constructorInfoCol = new ArrayList<ConstructorInfo>();
            GeneratedClassAdvisor.this.initialiseConstructors(constructorInfoCol);
            GeneratedClassAdvisor.this.constructorInfos = constructorInfoCol.toArray(new ConstructorInfo[constructorInfoCol.size()]);
            ArrayList<ConstructionInfo> constructionInfoCol = new ArrayList<ConstructionInfo>();
            GeneratedClassAdvisor.this.initialiseConstructions(constructionInfoCol);
            GeneratedClassAdvisor.this.constructionInfos = constructionInfoCol.toArray(new ConstructionInfo[constructionInfoCol.size()]);
            ArrayList<FieldInfo> fieldReadInfoCol = new ArrayList<FieldInfo>();
            GeneratedClassAdvisor.this.initialiseFieldReads(fieldReadInfoCol);
            GeneratedClassAdvisor.this.fieldReadInfos = fieldReadInfoCol.toArray(new FieldInfo[fieldReadInfoCol.size()]);
            ArrayList<FieldInfo> fieldWriteInfoCol = new ArrayList<FieldInfo>();
            GeneratedClassAdvisor.this.initialiseFieldWrites(fieldWriteInfoCol);
            GeneratedClassAdvisor.this.fieldWriteInfos = fieldWriteInfoCol.toArray(new FieldInfo[fieldWriteInfoCol.size()]);
            GeneratedClassAdvisor.super.setManager(manager);
            Advisor existing = AspectManager.instance().getAnyAdvisorIfAdvised(clazz);
            if (existing != null) {
                GeneratedClassAdvisor.this.aspects = existing.aspects;
                if (existing instanceof GeneratedClassAdvisor) {
                    GeneratedClassAdvisor.this.perClassJoinpointAspectDefinitions = ((GeneratedClassAdvisor)existing).perClassJoinpointAspectDefinitions;
                }
            }
            manager.initialiseClassAdvisor(clazz, GeneratedClassAdvisor.this);
            GeneratedClassAdvisor.this.initialiseCallers();
        }

        @Override
        public void checkVersion() {
        }

        @Override
        public void createInterceptorChains() throws Exception {
            GeneratedClassAdvisor.super.createInterceptorChains();
        }

        @Override
        public MethodJoinPointGenerator getJoinPointGenerator(MethodInfo info) {
            MethodJoinPointGenerator generator = (MethodJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
            if (generator == null) {
                generator = new MethodJoinPointGenerator(GeneratedClassAdvisor.this, info);
                GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
                MethodJoinPointGenerator existing = GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), generator);
                if (existing != null) {
                    generator = existing;
                }
            }
            return generator;
        }

        @Override
        public FieldJoinPointGenerator getJoinPointGenerator(FieldInfo info) {
            if (info.isRead()) {
                FieldJoinPointGenerator generator = (FieldJoinPointGenerator)GeneratedClassAdvisor.this.fieldReadJoinPoinGenerators.get(info.getJoinpoint());
                if (generator == null) {
                    generator = new FieldJoinPointGenerator(GeneratedClassAdvisor.this, info);
                    GeneratedClassAdvisor.this.initFieldReadJoinPointGeneratorsMap();
                    FieldJoinPointGenerator existing = GeneratedClassAdvisor.this.fieldReadJoinPoinGenerators.putIfAbsent(info.getJoinpoint(), generator);
                    if (existing != null) {
                        generator = existing;
                    }
                }
                return generator;
            }
            FieldJoinPointGenerator generator = (FieldJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
            if (generator == null) {
                generator = new FieldJoinPointGenerator(GeneratedClassAdvisor.this, info);
                GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
                FieldJoinPointGenerator existing = GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), generator);
                if (existing != null) {
                    generator = existing;
                }
            }
            return generator;
        }

        @Override
        public ConstructorJoinPointGenerator getJoinPointGenerator(ConstructorInfo info) {
            ConstructorJoinPointGenerator generator = (ConstructorJoinPointGenerator)GeneratedClassAdvisor.this.constructionJoinPointGenerators.get(info.getJoinpoint());
            if (generator == null) {
                generator = new ConstructorJoinPointGenerator(GeneratedClassAdvisor.this, info);
                GeneratedClassAdvisor.this.initConstructionJoinPointGeneratorsMap();
                ConstructorJoinPointGenerator existing = GeneratedClassAdvisor.this.constructionJoinPointGenerators.putIfAbsent(info.getJoinpoint(), generator);
                if (existing != null) {
                    generator = existing;
                }
            }
            return generator;
        }

        @Override
        public ConstructionJoinPointGenerator getJoinPointGenerator(ConstructionInfo info) {
            ConstructionJoinPointGenerator generator = (ConstructionJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
            if (generator == null) {
                generator = new ConstructionJoinPointGenerator(GeneratedClassAdvisor.this, info);
                GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
                ConstructionJoinPointGenerator existing = GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), generator);
                if (existing != null) {
                    generator = existing;
                }
            }
            return generator;
        }

        @Override
        public MethodByMethodJoinPointGenerator getJoinPointGenerator(MethodByMethodInfo info) {
            MethodByMethodJoinPointGenerator generator;
            ConcurrentHashMap map = (ConcurrentHashMap)GeneratedClassAdvisor.this.methodCalledByXXXJoinPointGenerators.get(info.getJoinpoint());
            if (map == null) {
                map = new ConcurrentHashMap();
                GeneratedClassAdvisor.this.initMethodCalledByConJoinPointGeneratorsMap();
                ConcurrentHashMap existing = GeneratedClassAdvisor.this.methodCalledByXXXJoinPointGenerators.putIfAbsent(info.getJoinpoint(), map);
                if (existing != null) {
                    map = existing;
                }
            }
            if ((generator = (MethodByMethodJoinPointGenerator)map.get(info.getCalledClass())) == null) {
                generator = new MethodByMethodJoinPointGenerator(GeneratedClassAdvisor.this, info);
                MethodByMethodJoinPointGenerator existing = map.putIfAbsent(info.getCalledClass(), generator);
                if (existing != null) {
                    generator = existing;
                }
            }
            return generator;
        }

        @Override
        public ConByMethodJoinPointGenerator getJoinPointGenerator(ConByMethodInfo info) {
            ConByMethodJoinPointGenerator generator = (ConByMethodJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
            if (generator == null) {
                generator = new ConByMethodJoinPointGenerator(GeneratedClassAdvisor.this, info);
                GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
                ConByMethodJoinPointGenerator existing = GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), generator);
                if (existing != null) {
                    generator = existing;
                }
            }
            return generator;
        }

        @Override
        public ConByConJoinPointGenerator getJoinPointGenerator(ConByConInfo info) {
            ConByConJoinPointGenerator generator = (ConByConJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
            if (generator == null) {
                generator = new ConByConJoinPointGenerator(GeneratedClassAdvisor.this, info);
                GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
                ConByConJoinPointGenerator existing = GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), generator);
                if (existing != null) {
                    generator = existing;
                }
            }
            return generator;
        }

        @Override
        public MethodByConJoinPointGenerator getJoinPointGenerator(MethodByConInfo info) {
            MethodByConJoinPointGenerator generator;
            ConcurrentHashMap map = (ConcurrentHashMap)GeneratedClassAdvisor.this.methodCalledByXXXJoinPointGenerators.get(info.getJoinpoint());
            if (map == null) {
                map = new ConcurrentHashMap();
                GeneratedClassAdvisor.this.initMethodCalledByConJoinPointGeneratorsMap();
                ConcurrentHashMap exisiting = GeneratedClassAdvisor.this.methodCalledByXXXJoinPointGenerators.putIfAbsent(info.getJoinpoint(), map);
                if (exisiting != null) {
                    map = exisiting;
                }
            }
            if ((generator = (MethodByConJoinPointGenerator)map.get(info.getCalledClass())) == null) {
                generator = new MethodByConJoinPointGenerator(GeneratedClassAdvisor.this, info);
                MethodByConJoinPointGenerator existing = map.putIfAbsent(info.getCalledClass(), generator);
                if (existing != null) {
                    generator = existing;
                }
            }
            return generator;
        }

        @Override
        public Object getPerClassAspect(AspectDefinition def) {
            return GeneratedClassAdvisor.super.getPerClassAspect(def);
        }

        @Override
        public Object getPerClassJoinpointAspect(AspectDefinition def, Joinpoint joinpoint) {
            Object aspect;
            Map<Joinpoint, Object> joinpoints = GeneratedClassAdvisor.this.perClassJoinpointAspectDefinitions.get(def);
            if (joinpoints != null && (aspect = joinpoints.get(joinpoint)) != Advisor.NULL_ASPECT) {
                return aspect;
            }
            return null;
        }

        @Override
        public GeneratedClassAdvisor getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices() {
            return null;
        }

        @Override
        public void createMethodTables() throws Exception {
            GeneratedClassAdvisor.super.createMethodTables();
        }

        @Override
        public void createFieldTable() throws Exception {
            GeneratedClassAdvisor.super.createFieldTable();
        }

        @Override
        public void createConstructorTables() throws Exception {
            GeneratedClassAdvisor.super.createConstructorTables();
        }

        @Override
        public Set<AspectDefinition> getPerInstanceAspectDefinitions() {
            return GeneratedClassAdvisor.super.getPerInstanceAspectDefinitions();
        }

        @Override
        public Map<AspectDefinition, Set<Joinpoint>> getPerInstanceJoinpointAspectDefinitions() {
            return GeneratedClassAdvisor.super.getPerInstanceJoinpointAspectDefinitions();
        }

        @Override
        public void rebuildInterceptors() {
            GeneratedClassAdvisor.this.version++;
            GeneratedClassAdvisor.super.rebuildInterceptors();
        }

        @Override
        public void rebuildInterceptorsForAddedBinding(AdviceBinding binding) {
            GeneratedClassAdvisor.this.version++;
            GeneratedClassAdvisor.super.rebuildInterceptorsForAddedBinding(binding);
        }

        @Override
        public void rebuildInterceptorsForRemovedBinding(AdviceBinding binding) {
            GeneratedClassAdvisor.this.version++;
            GeneratedClassAdvisor.super.rebuildInterceptorsForRemovedBinding(binding);
        }

        @Override
        public void resolveConstructorPointcut(AdviceBinding binding) {
            GeneratedClassAdvisor.super.resolveConstructorPointcut(binding);
        }

        @Override
        public void resolveConstructionPointcut(AdviceBinding binding) {
            GeneratedClassAdvisor.super.resolveConstructionPointcut(binding);
        }

        @Override
        public void finalizeConstructorChain(ConstructorInfo[] newConstructorInfos) {
            for (int i = 0; i < newConstructorInfos.length; ++i) {
                ConstructorInfo info = newConstructorInfos[i];
                ConstructorJoinPointGenerator generator = this.getJoinPointGenerator(info);
                Class<?> clazz = info.getClazz();
                if (clazz == null) continue;
                GeneratedClassAdvisor.this.finalizeChainAndRebindJoinPoint(GeneratedClassAdvisor.this.oldInfos, info, generator, OldInfoMaps.INFOS);
            }
        }

        @Override
        public void finalizeConstructionChain(ConstructionInfo[] newConstructionInfos) {
            for (int i = 0; i < newConstructionInfos.length; ++i) {
                ConstructionInfo info = newConstructionInfos[i];
                ConstructionJoinPointGenerator generator = this.getJoinPointGenerator(info);
                GeneratedClassAdvisor.this.finalizeChainAndRebindJoinPoint(GeneratedClassAdvisor.this.oldConstructionInfos, info, generator, OldInfoMaps.CONSTRUCTION_INFOS);
            }
        }

        @Override
        public void makeAccessibleField(FieldInfo fi) {
            SecurityActions.setAccessible(fi.getField());
        }

        @Override
        public void makeAccessibleMethod(MethodInfo mi) {
            SecurityActions.setAccessible(mi.getMethod());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface AdvisorStrategy {
        public void initialise(Class<?> var1, AspectManager var2);

        public void checkVersion();

        public void createInterceptorChains() throws Exception;

        public MethodJoinPointGenerator getJoinPointGenerator(MethodInfo var1);

        public FieldJoinPointGenerator getJoinPointGenerator(FieldInfo var1);

        public ConstructorJoinPointGenerator getJoinPointGenerator(ConstructorInfo var1);

        public ConstructionJoinPointGenerator getJoinPointGenerator(ConstructionInfo var1);

        public MethodByMethodJoinPointGenerator getJoinPointGenerator(MethodByMethodInfo var1);

        public ConByMethodJoinPointGenerator getJoinPointGenerator(ConByMethodInfo var1);

        public ConByConJoinPointGenerator getJoinPointGenerator(ConByConInfo var1);

        public MethodByConJoinPointGenerator getJoinPointGenerator(MethodByConInfo var1);

        public Object getPerClassAspect(AspectDefinition var1);

        public Object getPerClassJoinpointAspect(AspectDefinition var1, Joinpoint var2);

        public GeneratedClassAdvisor getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();

        public void createMethodTables() throws Exception;

        public void createFieldTable() throws Exception;

        public void createConstructorTables() throws Exception;

        public Set<AspectDefinition> getPerInstanceAspectDefinitions();

        public Map<AspectDefinition, Set<Joinpoint>> getPerInstanceJoinpointAspectDefinitions();

        public void rebuildInterceptors();

        public void rebuildInterceptorsForAddedBinding(AdviceBinding var1);

        public void rebuildInterceptorsForRemovedBinding(AdviceBinding var1);

        public void resolveConstructorPointcut(AdviceBinding var1);

        public void resolveConstructionPointcut(AdviceBinding var1);

        public void finalizeConstructorChain(ConstructorInfo[] var1);

        public void finalizeConstructionChain(ConstructionInfo[] var1);

        public void makeAccessibleField(FieldInfo var1);

        public void makeAccessibleMethod(MethodInfo var1);
    }
}

