/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ConByConInfo;
import org.jboss.aop.ConByMethodInfo;
import org.jboss.aop.FieldInfo;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.MethodByConInfo;
import org.jboss.aop.MethodByMethodInfo;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.instrument.DynamicTransformationObserver;
import org.jboss.aop.instrument.GeneratedAdvisorCallerTransformer;
import org.jboss.aop.instrument.GeneratedAdvisorConstructionTransformer;
import org.jboss.aop.instrument.GeneratedAdvisorConstructorExecutionTransformer;
import org.jboss.aop.instrument.GeneratedAdvisorFieldAccessTransformer;
import org.jboss.aop.instrument.GeneratedAdvisorMethodExecutionTransformer;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.JoinpointClassifier;
import org.jboss.aop.instrument.TransformationException;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.instrument.WeavingRegistry;
import org.jboss.logging.Logger;

public class GeneratedAdvisorInstrumentor
extends Instrumentor {
    private static final Logger logger = Logger.getLogger(GeneratedAdvisorInstrumentor.class);
    private static final String CURRENT_ADVISOR = "currentAdvisor$aop";
    private static final String INSTANCE_ADVISOR = "instanceAdvisor$aop";
    private static final String GET_CURRENT_ADVISOR_NAME = "getCurrentAdvisor$aop";
    public static final String GET_CURRENT_ADVISOR = "getCurrentAdvisor$aop()";
    private static final String DOMAIN = "domain";
    private static final String CHECK_VERSION = "checkVersion";
    private static final String ADVICES_UPDATED = "advicesUpdated";
    private static final String INSTANCE_ADVISOR_MIXIN = "instanceAdvisorMixin";
    private static final String PARENT = "parent";
    private static final String CREATE_INSTANCE_ADVISOR = "createInstanceAdvisor";
    private static final String INITIALISE_CALLERS = "initialiseCallers";
    private static final String INITIALISE_FIELD_WRITES = "initialiseFieldWrites";
    private static final String INITIALISE_FIELD_READS = "initialiseFieldReads";
    private static final String INITIALISE_CONSTRUCTIONS = "initialiseConstructions";
    private static final String INITIALISE_CONSTRUCTORS = "initialiseConstructors";
    private static final String INITIALISE_METHODS = "initialiseMethods";
    private static final String INITIALISE_INFOS_FOR_INSTANCE = "initialiseInfosForInstance";
    public static final String GET_CLASS_ADVISOR = "_getClassAdvisor";
    private static final String DO_REBUILD_FOR_INSTANCE = "doRebuildForInstance";
    private static final String LOCK_WRITE_CHAINS = "lockWriteInterceptorChains";
    private static final String UNLOCK_WRITE_CHAINS = "unlockWriteInterceptorChains";
    private static final CtClass[] EMPTY_EXCEPTIONS = new CtClass[0];
    private static final CtClass[] EMPTY_SIG = new CtClass[0];
    CtClass clazz;
    CtClass genadvisor;
    CtClass genInstanceAdvisor;

    public GeneratedAdvisorInstrumentor(ClassPool pool, AspectManager manager, JoinpointClassifier joinpointClassifier, DynamicTransformationObserver observer) {
        super(pool, manager, joinpointClassifier, observer);
    }

    public GeneratedAdvisorInstrumentor(AspectManager manager, JoinpointClassifier joinpointClassifier) {
        super(manager, joinpointClassifier);
    }

    protected CtClass getGenadvisor() {
        return this.genadvisor;
    }

    protected CtClass getGenInstanceadvisor() {
        return this.genInstanceAdvisor;
    }

    public boolean transform(CtClass clazz, ClassAdvisor advisor) {
        try {
            this.clazz = clazz;
            if (super.transform(clazz, advisor)) {
                if (this.genadvisor != null) {
                    this.addInstanceAdvisorWrappers(clazz);
                    TransformerCommon.compileOrLoadClass(clazz, this.genadvisor);
                    TransformerCommon.compileOrLoadClass(clazz, this.genInstanceAdvisor);
                }
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            if (AspectManager.suppressTransformationErrors) {
                logger.error("[warn] AOP Instrumentor failed to transform " + clazz.getName());
                e.printStackTrace();
                return false;
            }
            if (e instanceof TransformationException) {
                throw (TransformationException)e;
            }
            e.printStackTrace();
            throw new RuntimeException("failed to transform: " + clazz.getName(), e);
        }
    }

    protected void intitialiseTransformers() {
        this.callerTransformer = new GeneratedAdvisorCallerTransformer(this, this.manager);
        this.fieldAccessTransformer = new GeneratedAdvisorFieldAccessTransformer(this);
        this.constructorExecutionTransformer = new GeneratedAdvisorConstructorExecutionTransformer(this);
        this.constructionTransformer = new GeneratedAdvisorConstructionTransformer(this);
        this.methodExecutionTransformer = new GeneratedAdvisorMethodExecutionTransformer(this);
    }

    protected CtMethod createMixinInvokeMethod(CtClass clazz, CtClass mixinClass, String initializer, CtMethod method, long hash) throws CannotCompileException, NotFoundException, Exception {
        return ((GeneratedAdvisorMethodExecutionTransformer)this.methodExecutionTransformer).addMixinWrappersAndInfo(this, clazz, mixinClass, initializer, this.genadvisor, method);
    }

    protected CtMethod addMixinMethod(Advisor advisor, CtMethod method, CtClass clazz, CtMethod delegate, long hash) throws Exception {
        return ((GeneratedAdvisorMethodExecutionTransformer)this.methodExecutionTransformer).addMixinWrappersAndInfo(this, clazz, this.genadvisor, method, delegate);
    }

    protected static String getAdvisorName(CtClass clazz) {
        String className = clazz.getName();
        return className.substring(className.lastIndexOf(46) + 1) + "Advisor";
    }

    protected static String getInstanceAdvisorName(CtClass clazz) {
        String className = clazz.getName();
        return className.substring(className.lastIndexOf(46) + 1) + "InstanceAdvisor";
    }

    protected static String getAdvisorFQN(CtClass clazz) {
        return clazz.getName() + "$" + GeneratedAdvisorInstrumentor.getAdvisorName(clazz);
    }

    protected static String getInstanceAdvisorFQN(CtClass clazz) {
        return clazz.getName() + "$" + GeneratedAdvisorInstrumentor.getInstanceAdvisorName(clazz);
    }

    protected CtClass createAdvisorClass(CtClass clazz) throws NotFoundException, CannotCompileException {
        String innerClassName = GeneratedAdvisorInstrumentor.getAdvisorName(clazz);
        boolean classStatic = true;
        this.genadvisor = TransformerCommon.makeNestedClass(clazz, innerClassName, true);
        CtClass superAdvisor = this.getSuperClassAdvisor(clazz.getSuperclass());
        if (superAdvisor == null) {
            this.genadvisor.setSuperclass(this.forName(GeneratedClassAdvisor.class.getName()));
        } else {
            this.genadvisor.setSuperclass(superAdvisor);
        }
        CtClass untransformable = this.getClassPool().get("org.jboss.aop.instrument.Untransformable");
        this.genadvisor.addInterface(untransformable);
        CtField domain = new CtField(this.forName("org.jboss.aop.Domain"), DOMAIN, this.genadvisor);
        domain.setModifiers(4);
        this.genadvisor.addField(domain);
        CtMethod getter = CtNewMethod.getter("getDomain", domain);
        this.genadvisor.addMethod(getter);
        CtMethod initialiseMethods = CtNewMethod.make(4, CtClass.voidType, INITIALISE_METHODS, EMPTY_SIG, EMPTY_EXCEPTIONS, superAdvisor == null ? null : "{super.initialiseMethods();}", this.genadvisor);
        this.genadvisor.addMethod(initialiseMethods);
        CtMethod superInitialiseConstructors = this.genadvisor.getSuperclass().getDeclaredMethod(INITIALISE_CONSTRUCTORS);
        CtMethod initialiseConstructors = CtNewMethod.make(4, CtClass.voidType, INITIALISE_CONSTRUCTORS, superInitialiseConstructors.getParameterTypes(), EMPTY_EXCEPTIONS, null, this.genadvisor);
        this.genadvisor.addMethod(initialiseConstructors);
        CtMethod superInitialiseConstructions = this.genadvisor.getSuperclass().getDeclaredMethod(INITIALISE_CONSTRUCTIONS);
        CtMethod initialiseConstructions = CtNewMethod.make(4, CtClass.voidType, INITIALISE_CONSTRUCTIONS, superInitialiseConstructions.getParameterTypes(), EMPTY_EXCEPTIONS, superAdvisor == null ? null : "{super.initialiseConstructions($1);}", this.genadvisor);
        this.genadvisor.addMethod(initialiseConstructions);
        CtMethod superInitialiseFieldReads = this.genadvisor.getSuperclass().getDeclaredMethod(INITIALISE_FIELD_READS);
        CtMethod initialiseFieldReads = CtNewMethod.make(4, CtClass.voidType, INITIALISE_FIELD_READS, superInitialiseFieldReads.getParameterTypes(), EMPTY_EXCEPTIONS, superAdvisor == null ? null : "{super.initialiseFieldReads($1);}", this.genadvisor);
        this.genadvisor.addMethod(initialiseFieldReads);
        CtMethod superInitialiseFieldWrites = this.genadvisor.getSuperclass().getDeclaredMethod(INITIALISE_FIELD_WRITES);
        CtMethod initialiseFieldWrites = CtNewMethod.make(4, CtClass.voidType, INITIALISE_FIELD_WRITES, superInitialiseFieldWrites.getParameterTypes(), EMPTY_EXCEPTIONS, superAdvisor == null ? null : "{super.initialiseFieldWrites($1);}", this.genadvisor);
        this.genadvisor.addMethod(initialiseFieldWrites);
        CtMethod initialiseCallers = CtNewMethod.make(4, CtClass.voidType, INITIALISE_CALLERS, EMPTY_SIG, EMPTY_EXCEPTIONS, superAdvisor == null ? null : "{super.initialiseCallers();}", this.genadvisor);
        this.genadvisor.addMethod(initialiseCallers);
        this.createAdvisorCtors(clazz);
        return this.genadvisor;
    }

    protected CtClass createInstanceAdvisorClass(CtClass clazz) throws NotFoundException, CannotCompileException {
        String innerClassName = GeneratedAdvisorInstrumentor.getInstanceAdvisorName(clazz);
        boolean classStatic = true;
        this.genInstanceAdvisor = TransformerCommon.makeNestedClass(clazz, innerClassName, true);
        this.genInstanceAdvisor.setModifiers(Modifier.setPublic(this.genInstanceAdvisor.getModifiers()));
        this.genInstanceAdvisor.setSuperclass(this.getGenadvisor());
        CtClass untransformable = this.getClassPool().get("org.jboss.aop.instrument.Untransformable");
        this.genInstanceAdvisor.addInterface(untransformable);
        CtMethod advicesUpdated = CtNewMethod.make(4, CtClass.voidType, ADVICES_UPDATED, EMPTY_SIG, EMPTY_EXCEPTIONS, null, this.genInstanceAdvisor);
        this.genInstanceAdvisor.addMethod(advicesUpdated);
        CtMethod lockWriteChains = CtNewMethod.make(4, CtClass.voidType, LOCK_WRITE_CHAINS, EMPTY_SIG, EMPTY_EXCEPTIONS, null, this.genInstanceAdvisor);
        this.genInstanceAdvisor.addMethod(lockWriteChains);
        CtMethod unlockWriteChains = CtNewMethod.make(4, CtClass.voidType, UNLOCK_WRITE_CHAINS, EMPTY_SIG, EMPTY_EXCEPTIONS, null, this.genInstanceAdvisor);
        this.genInstanceAdvisor.addMethod(unlockWriteChains);
        this.implementInstanceAdvisorMethods();
        String drfiBody = "{lockWriteInterceptorChains();   try   {      internalRebuildInterceptors();       if (instanceAdvisorMixin.hasInterceptors())      {          advicesUpdated();      }   } finally { unlockWriteInterceptorChains();}}";
        CtMethod doRebuildForInstance = CtNewMethod.make(4, CtClass.voidType, DO_REBUILD_FOR_INSTANCE, EMPTY_SIG, EMPTY_EXCEPTIONS, drfiBody, this.genInstanceAdvisor);
        this.genInstanceAdvisor.addMethod(doRebuildForInstance);
        CtField parentField = new CtField(this.getGenadvisor(), PARENT, this.genInstanceAdvisor);
        this.genInstanceAdvisor.addField(parentField, "null");
        String body = "{    super($2);   instanceAdvisorMixin = new org.jboss.aop.GeneratedInstanceAdvisorMixin($1, $2);   parent = $2;}";
        CtConstructor ctor = CtNewConstructor.make(new CtClass[]{this.forName("java.lang.Object"), this.genadvisor}, new CtClass[0], body, this.genInstanceAdvisor);
        this.genInstanceAdvisor.addConstructor(ctor);
        CtMethod initialiseInfosForInstance = CtNewMethod.make(4, CtClass.voidType, INITIALISE_INFOS_FOR_INSTANCE, EMPTY_SIG, EMPTY_EXCEPTIONS, null, this.genInstanceAdvisor);
        this.genInstanceAdvisor.addMethod(initialiseInfosForInstance);
        return this.genInstanceAdvisor;
    }

    protected void createAdvisorCtors(CtClass clazz) throws CannotCompileException, NotFoundException {
        String declaringClass = clazz.getName() + ".class";
        String initBody = "{   java.lang.String domainName = org.jboss.aop.Domain.getDomainName(" + declaringClass + ", $2);" + "   " + DOMAIN + "= new org.jboss.aop.GeneratedAdvisorDomain($1, domainName, " + declaringClass + ", $2); " + "   ((org.jboss.aop.Domain)" + DOMAIN + ").setInheritsBindings(true); " + "   super.initialise(" + declaringClass + ", " + DOMAIN + ");" + "}";
        CtMethod initialise = CtNewMethod.make(4, CtClass.voidType, "initialise", new CtClass[]{this.forName("org.jboss.aop.AspectManager"), CtClass.booleanType}, EMPTY_EXCEPTIONS, initBody, this.genadvisor);
        this.genadvisor.addMethod(initialise);
        CtConstructor ctor = CtNewConstructor.defaultConstructor(this.genadvisor);
        ctor.setBody("{   super(\"" + clazz.getName() + "\"); " + "   initialise(org.jboss.aop.AspectManager.instance(org.jboss.aop.advice.SecurityActions.getClassLoader(this.getClass())), false);" + "}");
        this.genadvisor.addConstructor(ctor);
        String instanceBody = "{   super(\"" + clazz.getName() + "\", $1); " + "   initialise($1.getDomain(), true);" + "}";
        CtConstructor ctorWithParentAdvisor = CtNewConstructor.make(new CtClass[]{this.genadvisor}, EMPTY_EXCEPTIONS, instanceBody, this.genadvisor);
        this.genadvisor.addConstructor(ctorWithParentAdvisor);
        CtConstructor ctorForSubAdvisors = CtNewConstructor.make(new CtClass[]{this.forName("java.lang.String")}, new CtClass[0], "{super($1);}", this.genadvisor);
        this.genadvisor.addConstructor(ctorForSubAdvisors);
        ctorForSubAdvisors.setModifiers(4);
        CtConstructor ctorForSubAdvisorInstanceAdvisors = CtNewConstructor.make(new CtClass[]{this.forName("java.lang.String"), this.forName("org.jboss.aop.GeneratedClassAdvisor")}, new CtClass[0], "{super($1, $2);}", this.genadvisor);
        this.genadvisor.addConstructor(ctorForSubAdvisorInstanceAdvisors);
        ctorForSubAdvisorInstanceAdvisors.setModifiers(4);
    }

    protected CtClass getSuperClassAdvisor(CtClass superclass) throws NotFoundException {
        if (superclass != null) {
            try {
                if (this.isAdvised(superclass)) {
                    return this.forName(superclass.getClassPool(), GeneratedAdvisorInstrumentor.getAdvisorFQN(superclass));
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            return this.getSuperClassAdvisor(superclass.getSuperclass());
        }
        return null;
    }

    protected void implementInstanceAdvisorMethods() throws NotFoundException, CannotCompileException {
        CtClass instanceAdvisor = this.getClassPool().get("org.jboss.aop.InstanceAdvisor");
        this.genInstanceAdvisor.addInterface(instanceAdvisor);
        CtField instanceAdvisorMixin = new CtField(this.getClassPool().get("org.jboss.aop.GeneratedInstanceAdvisorMixin"), INSTANCE_ADVISOR_MIXIN, this.genInstanceAdvisor);
        this.genInstanceAdvisor.addField(instanceAdvisorMixin);
        CtMethod[] instanceAdvisorMethods = instanceAdvisor.getDeclaredMethods();
        for (int i = 0; i < instanceAdvisorMethods.length; ++i) {
            String name = instanceAdvisorMethods[i].getName();
            if (name.equals("hasAspects") || name.equals("getDomain")) continue;
            StringBuffer delegatingBody = new StringBuffer();
            delegatingBody.append("{");
            boolean changeInterceptorChainsOperation = false;
            if (name.startsWith("insertInterceptor") || name.startsWith("removeInterceptor") || name.startsWith("appendInterceptor")) {
                changeInterceptorChainsOperation = true;
                delegatingBody.append(LOCK_WRITE_CHAINS).append("();").append("try {");
                delegatingBody.append("advicesUpdated();");
            }
            if (!instanceAdvisorMethods[i].getReturnType().equals(CtClass.voidType)) {
                delegatingBody.append("return ");
            }
            delegatingBody.append("instanceAdvisorMixin." + instanceAdvisorMethods[i].getName() + "($$);}");
            if (changeInterceptorChainsOperation) {
                delegatingBody.append(" finally {").append(UNLOCK_WRITE_CHAINS).append("();}}");
            }
            CtMethod m = CtNewMethod.make(1, instanceAdvisorMethods[i].getReturnType(), instanceAdvisorMethods[i].getName(), instanceAdvisorMethods[i].getParameterTypes(), instanceAdvisorMethods[i].getExceptionTypes(), delegatingBody.toString(), this.genInstanceAdvisor);
            this.genInstanceAdvisor.addMethod(m);
        }
    }

    private void addCreateInstanceAdvisorToGenAdvisor(CtClass clazz) throws NotFoundException, CannotCompileException {
        CtMethod createInstanceAdvisor = CtNewMethod.make(1, this.forName("org.jboss.aop.Advisor"), CREATE_INSTANCE_ADVISOR, new CtClass[]{this.forName("java.lang.Object")}, EMPTY_EXCEPTIONS, "{return new " + GeneratedAdvisorInstrumentor.getInstanceAdvisorFQN(clazz) + "($1, this);}", this.genadvisor);
        this.genadvisor.addMethod(createInstanceAdvisor);
    }

    protected void doSetupBasics(CtClass clazz) throws CannotCompileException, NotFoundException {
        this.createAdvisorClass(clazz);
        this.createInstanceAdvisorClass(clazz);
        this.addCreateInstanceAdvisorToGenAdvisor(clazz);
        this.createAdvisorFieldsAndGetter(clazz);
    }

    private void createAdvisorFieldsAndGetter(CtClass clazz) throws NotFoundException, CannotCompileException {
        CtField classAdvisor = new CtField(this.forName("org.jboss.aop.Advisor"), "aop$classAdvisor$aop", clazz);
        classAdvisor.setModifiers(138);
        GeneratedAdvisorInstrumentor.addSyntheticAttribute(classAdvisor);
        clazz.addField(classAdvisor, CtField.Initializer.byExpr("new " + GeneratedAdvisorInstrumentor.getAdvisorFQN(clazz) + "()"));
        CtMethod getAdvisor = CtNewMethod.getter("_getAdvisor", classAdvisor);
        getAdvisor.setModifiers(1);
        GeneratedAdvisorInstrumentor.addSyntheticAttribute(getAdvisor);
        clazz.addMethod(getAdvisor);
        CtMethod getClassAdvisor = CtNewMethod.getter(GET_CLASS_ADVISOR, classAdvisor);
        getClassAdvisor.setModifiers(9);
        GeneratedAdvisorInstrumentor.addSyntheticAttribute(getClassAdvisor);
        clazz.addMethod(getClassAdvisor);
        if (this.isBaseClass(clazz)) {
            CtField currentAdvisor = new CtField(this.forName("org.jboss.aop.Advisor"), CURRENT_ADVISOR, clazz);
            currentAdvisor.setModifiers(196);
            GeneratedAdvisorInstrumentor.addSyntheticAttribute(currentAdvisor);
            clazz.addField(currentAdvisor, CtField.Initializer.byExpr("_getAdvisor()"));
            String body = "{   if (currentAdvisor$aop == null)   {      currentAdvisor$aop = _getAdvisor();   }   return currentAdvisor$aop;}";
            CtMethod getCurrentAdvisor = CtNewMethod.make(4, this.forName("org.jboss.aop.Advisor"), GET_CURRENT_ADVISOR_NAME, EMPTY_SIG, EMPTY_EXCEPTIONS, body, clazz);
            GeneratedAdvisorInstrumentor.addSyntheticAttribute(getCurrentAdvisor);
            clazz.addMethod(getCurrentAdvisor);
            CtField instanceAdvisor = new CtField(this.forName("org.jboss.aop.InstanceAdvisor"), INSTANCE_ADVISOR, clazz);
            instanceAdvisor.setModifiers(132);
            GeneratedAdvisorInstrumentor.addSyntheticAttribute(instanceAdvisor);
            clazz.addField(instanceAdvisor);
        }
        String body = "{    if (instanceAdvisor$aop == null)    {       synchronized(this)       {          if (instanceAdvisor$aop == null)          {             org.jboss.aop.Advisor advisor = ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(clazz) + ")" + "aop$classAdvisor$aop" + ").createInstanceAdvisor(this); " + "            " + CURRENT_ADVISOR + " = advisor; " + "            " + INSTANCE_ADVISOR + " = (org.jboss.aop.InstanceAdvisor)advisor; " + "         } " + "      } " + "   } " + "   return " + INSTANCE_ADVISOR + ";" + "}";
        try {
            CtMethod getInstanceAdvisor = CtNewMethod.make(this.forName("org.jboss.aop.InstanceAdvisor"), "_getInstanceAdvisor", new CtClass[0], new CtClass[0], body, clazz);
            GeneratedAdvisorInstrumentor.addSyntheticAttribute(getInstanceAdvisor);
            clazz.addMethod(getInstanceAdvisor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        CtMethod[] methodz = clazz.getMethods();
        boolean setInstanceAdvisorFound = false;
        for (CtMethod m : methodz) {
            if (!m.getName().equals("_setInstanceAdvisor") || m.getDeclaringClass().isInterface()) continue;
            setInstanceAdvisorFound = true;
        }
        if (!setInstanceAdvisorFound) {
            body = "{    synchronized(this)    {       instanceAdvisor$aop == $1;    } }";
            try {
                CtMethod getInstanceAdvisor = CtNewMethod.make(CtClass.voidType, "_setInstanceAdvisor", new CtClass[]{this.forName("org.jboss.aop.InstanceAdvisor")}, new CtClass[0], body, clazz);
                GeneratedAdvisorInstrumentor.addSyntheticAttribute(getInstanceAdvisor);
                clazz.addMethod(getInstanceAdvisor);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected boolean isBaseClass(CtClass clazz) throws NotFoundException {
        CtClass supa = clazz.getSuperclass();
        if (supa == null || supa.getName().equals("java.lang.Object")) {
            return true;
        }
        if (WeavingRegistry.isClassLoadedButNotWoven(this.classPool, supa.getName())) {
            return true;
        }
        return super.isBaseClass(clazz);
    }

    public static String updatedAdvicesName(String infoName) {
        return infoName + "_updated";
    }

    private void addInstanceAdvisorWrappers(CtClass clazz) throws CannotCompileException, NotFoundException {
        CtClass superClass = clazz;
        CtClass superAdvisor = this.genadvisor;
        StringBuffer advicesUpdatedCode = new StringBuffer();
        StringBuffer initialiseInfosForInstanceCode = new StringBuffer();
        StringBuffer lockWriteChainsCode = new StringBuffer();
        StringBuffer unlockWriteChainsCode = new StringBuffer();
        initialiseInfosForInstanceCode.append("java.util.Collection fieldReadCol = new java.util.ArrayList();");
        initialiseInfosForInstanceCode.append("java.util.Collection fieldWriteCol = new java.util.ArrayList();");
        while (true) {
            CtField[] fields = superAdvisor.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                GeneratedAdvisorNameExtractor names;
                if (Modifier.isStatic(fields[i].getModifiers()) || (names = GeneratedAdvisorNameExtractor.extractNames(superAdvisor, fields[i])) == null) continue;
                String infoName = fields[i].getName();
                String updatedJoinpointAdvicesName = this.addAdvicesUpdatedForJoinpointField(infoName);
                advicesUpdatedCode.append(updatedJoinpointAdvicesName + " = true;");
                this.addWrapperDelegatorMethodToInstanceAdvisor(names, updatedJoinpointAdvicesName);
                String infoClassName = fields[i].getType().getName();
                if (infoClassName.equals(FieldInfo.class.getName()) || infoClassName.equals(MethodInfo.class.getName()) || infoClassName.equals(ConByConInfo.class.getName()) || infoClassName.equals(MethodByConInfo.class.getName()) || infoClassName.equals(ConByMethodInfo.class.getName()) || infoClassName.equals(MethodByMethodInfo.class.getName())) {
                    String code = infoName + " = super.copyInfoFromClassAdvisor(((" + this.genadvisor.getName() + ")" + clazz.getName() + "." + GET_CLASS_ADVISOR + "())." + infoName + ");";
                    initialiseInfosForInstanceCode.append(code);
                    lockWriteChainsCode.append(infoName).append(".getInterceptorChainReadWriteLock().writeLock().lock();");
                    unlockWriteChainsCode.append(infoName).append(".getInterceptorChainReadWriteLock().writeLock().unlock();");
                }
                if (!infoClassName.equals(FieldInfo.class.getName())) continue;
                initialiseInfosForInstanceCode.append("if (").append(infoName).append(".isRead()){");
                initialiseInfosForInstanceCode.append("fieldReadCol.add(").append(infoName).append(");");
                initialiseInfosForInstanceCode.append("} else { fieldWriteCol.add(");
                initialiseInfosForInstanceCode.append(infoName).append(");}");
            }
            if (this.isBaseClass(superClass)) break;
            superClass = superClass.getSuperclass();
            superAdvisor = superAdvisor.getSuperclass();
        }
        initialiseInfosForInstanceCode.append("fieldReadInfos = (org.jboss.aop.FieldInfo[]) fieldReadCol.toArray(new org.jboss.aop.FieldInfo[fieldReadCol.size()]);");
        initialiseInfosForInstanceCode.append("fieldWriteInfos = (org.jboss.aop.FieldInfo[]) fieldWriteCol.toArray(new org.jboss.aop.FieldInfo[fieldWriteCol.size()]);");
        if (initialiseInfosForInstanceCode.length() > 0) {
            initialiseInfosForInstanceCode.insert(0, this.genadvisor.getName() + " classAdvisor = (" + this.genadvisor.getName() + ")" + clazz.getName() + "." + GET_CLASS_ADVISOR + "();");
        }
        this.addCodeToInitialiseMethod(this.genInstanceAdvisor, initialiseInfosForInstanceCode.toString(), INITIALISE_INFOS_FOR_INSTANCE);
        CtMethod advicesUpdated = this.genInstanceAdvisor.getDeclaredMethod(ADVICES_UPDATED);
        advicesUpdated.insertAfter(advicesUpdatedCode.toString());
        CtMethod lockWriteChains = this.genInstanceAdvisor.getDeclaredMethod(LOCK_WRITE_CHAINS);
        lockWriteChains.insertAfter(lockWriteChainsCode.toString());
        CtMethod unlockWriteChains = this.genInstanceAdvisor.getDeclaredMethod(UNLOCK_WRITE_CHAINS);
        unlockWriteChains.insertAfter(unlockWriteChainsCode.toString());
    }

    private String addAdvicesUpdatedForJoinpointField(String infoName) throws NotFoundException, CannotCompileException {
        String updatedAdvicesName = GeneratedAdvisorInstrumentor.updatedAdvicesName(infoName);
        try {
            this.genInstanceAdvisor.getDeclaredField(updatedAdvicesName);
        }
        catch (NotFoundException e) {
            CtField updatedAdvice = new CtField(CtClass.booleanType, updatedAdvicesName, this.genInstanceAdvisor);
            updatedAdvice.setModifiers(4);
            this.genInstanceAdvisor.addField(updatedAdvice);
        }
        return updatedAdvicesName;
    }

    private void addWrapperDelegatorMethodToInstanceAdvisor(GeneratedAdvisorNameExtractor names, String updatedAdvicesFieldName) throws NotFoundException, CannotCompileException {
        try {
            this.genInstanceAdvisor.getDeclaredMethod(names.getWrapper().getName());
        }
        catch (NotFoundException e) {
            CtMethod instanceAdvisorMethod = CtNewMethod.delegator(names.getWrapper(), this.genInstanceAdvisor);
            String code = "checkVersion();if (" + updatedAdvicesFieldName + ")" + "{ " + "   " + names.getInfoFieldName() + ".getInterceptorChainReadWriteLock().writeLock().lock();" + "   try" + "   {" + "      " + names.getInfoFieldName() + ".setInterceptors( " + INSTANCE_ADVISOR_MIXIN + ".getWrappers(" + PARENT + "." + names.getInfoFieldName() + ".getInterceptors()) );" + "      " + names.getJoinPointField().getName() + " = null;" + "      " + updatedAdvicesFieldName + " = false;" + "      super.rebindJoinPointWithInstanceInformation(" + names.getInfoFieldName() + ");" + "   } finally {" + "   " + names.getInfoFieldName() + ".getInterceptorChainReadWriteLock().writeLock().unlock();}" + "}";
            instanceAdvisorMethod.insertBefore(code);
            this.genInstanceAdvisor.addMethod(instanceAdvisorMethod);
        }
    }

    protected void initaliseMethodInfo(String infoName, long hash, long unadvisedHash) throws NotFoundException {
        String code = infoName + " = new " + "org.jboss.aop.MethodInfo" + "(" + "java.lang.Class.forName(\"" + this.clazz.getName() + "\")," + hash + "L, " + unadvisedHash + "L, this);" + "addMethodInfo" + "(" + infoName + ");";
        this.addCodeToInitialiseMethod(this.genadvisor, code, INITIALISE_METHODS);
    }

    protected void initialiseFieldReadInfoField(String infoName, int index, String fieldName, long wrapperHash) throws NotFoundException {
        String code = infoName + " = new " + "org.jboss.aop.FieldInfo" + "(" + "java.lang.Class.forName(\"" + this.clazz.getName() + "\")," + index + ", " + "\"" + fieldName + "\", " + wrapperHash + "L, this, true);" + "addFieldReadInfo" + "(" + infoName + ", $1);";
        this.addCodeToInitialiseMethod(this.genadvisor, code, INITIALISE_FIELD_READS);
    }

    protected void initialiseFieldWriteInfoField(String infoName, int index, String fieldName, long wrapperHash) throws NotFoundException {
        String code = infoName + " = new " + "org.jboss.aop.FieldInfo" + "(" + "java.lang.Class.forName(\"" + this.clazz.getName() + "\")," + index + ", " + "\"" + fieldName + "\", " + wrapperHash + "L, this, false);" + "addFieldWriteInfo" + "(" + infoName + ", $1);";
        this.addCodeToInitialiseMethod(this.genadvisor, code, INITIALISE_FIELD_WRITES);
    }

    protected void initialiseConstructorInfoField(String infoName, int index, long constructorHash, long wrapperHash) throws NotFoundException {
        String code = infoName + " = new " + "org.jboss.aop.ConstructorInfo" + "(" + "java.lang.Class.forName(\"" + this.clazz.getName() + "\")," + index + ", " + wrapperHash + "L, " + constructorHash + "L, this);" + "addConstructorInfo" + "(" + infoName + ", $1);";
        this.addCodeToInitialiseMethod(this.genadvisor, code, INITIALISE_CONSTRUCTORS);
    }

    protected void initialiseConstructionInfoField(String infoName, int index, long constructorHash) throws NotFoundException {
        String code = infoName + " = new " + "org.jboss.aop.ConstructionInfo" + "(" + "java.lang.Class.forName(\"" + this.clazz.getName() + "\")," + index + ", " + constructorHash + "L, this);" + "addConstructionInfo" + "(" + infoName + ", $1);";
        this.addCodeToInitialiseMethod(this.genadvisor, code, INITIALISE_CONSTRUCTIONS);
    }

    protected void initialiseCallerInfoField(String infoName, String init) throws CannotCompileException, NotFoundException {
        this.addCodeToInitialiseMethod(this.genadvisor, infoName + " = " + init + ";", INITIALISE_CALLERS);
    }

    static String generateInterceptorChainLockCode(String infoName) {
        return infoName + ".getInterceptorChainReadWriteLock().readLock().lock();";
    }

    static String generateInterceptorChainUnlockCode(String infoName) {
        return infoName + ".getInterceptorChainReadWriteLock().readLock().unlock();";
    }

    private void addCodeToInitialiseMethod(CtClass clazz, String code, String methodName) throws NotFoundException {
        CtMethod method = clazz.getDeclaredMethod(methodName);
        try {
            method.insertAfter(code);
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
            throw new RuntimeException("code was: " + code + " for method " + method.getName());
        }
    }

    private static class GeneratedAdvisorNameExtractor {
        String infoName;
        CtMethod wrapper;
        CtField joinPointField;

        private GeneratedAdvisorNameExtractor(String infoName, CtMethod wrapper, CtField joinPointField) {
            this.infoName = infoName;
            this.wrapper = wrapper;
            this.joinPointField = joinPointField;
        }

        private static GeneratedAdvisorNameExtractor extractNames(CtClass genadvisor, CtField infoField) throws NotFoundException {
            String infoName = infoField.getName();
            if (infoField.getType().getName().equals(FieldInfo.class.getName())) {
                boolean isWrite = infoName.startsWith("aop$FieldInfo_w_");
                if (!isWrite && !infoName.startsWith("aop$FieldInfo_r_")) {
                    throw new RuntimeException("Bad FieldInfo name: '" + infoName + "'");
                }
                String fieldName = infoName.substring("aop$FieldInfo_w_".length());
                String wrapperName = isWrite ? GeneratedAdvisorFieldAccessTransformer.advisorFieldWrite(genadvisor, fieldName) : GeneratedAdvisorFieldAccessTransformer.advisorFieldRead(genadvisor, fieldName);
                CtMethod wrapper = genadvisor.getDeclaredMethod(wrapperName);
                String joinPointName = isWrite ? "joinpoint_w_" + fieldName : "joinpoint_r_" + fieldName;
                CtField joinPointField = genadvisor.getDeclaredField(joinPointName);
                return new GeneratedAdvisorNameExtractor(infoName, wrapper, joinPointField);
            }
            if (infoField.getType().getName().equals(MethodInfo.class.getName())) {
                if (!infoName.startsWith("aop$MethodInfo_")) {
                    throw new RuntimeException("Bad MethodInfo name: '" + infoName + "'");
                }
                String methodNameHash = infoName.substring("aop$MethodInfo_".length());
                CtMethod wrapper = genadvisor.getDeclaredMethod(methodNameHash);
                String joinPointName = "joinpoint_" + methodNameHash;
                CtField joinPointField = genadvisor.getDeclaredField(joinPointName);
                return new GeneratedAdvisorNameExtractor(infoName, wrapper, joinPointField);
            }
            if (infoField.getType().getName().equals(ConByMethodInfo.class.getName())) {
                if (!infoName.startsWith("aop$constructorCall_")) {
                    throw new RuntimeException("Bad ConByMethodInfo name: '" + infoName + "'");
                }
                CtMethod wrapper = genadvisor.getDeclaredMethod(infoName);
                String joinPointName = "joinpoint_CByM_" + infoName.substring("aop$constructorCall_".length());
                CtField joinPointField = genadvisor.getDeclaredField(joinPointName);
                return new GeneratedAdvisorNameExtractor(infoName, wrapper, joinPointField);
            }
            if (infoField.getType().getName().equals(MethodByMethodInfo.class.getName())) {
                if (!infoName.startsWith("aop$methodCall_")) {
                    throw new RuntimeException("Bad MethodByMethodInfo name: '" + infoName + "'");
                }
                CtMethod wrapper = genadvisor.getDeclaredMethod(infoName);
                String joinPointName = "joinpoint_MByM_" + infoName.substring("aop$methodCall_".length());
                CtField joinPointField = genadvisor.getDeclaredField(joinPointName);
                return new GeneratedAdvisorNameExtractor(infoName, wrapper, joinPointField);
            }
            if (infoField.getType().getName().equals(ConByConInfo.class.getName())) {
                if (!infoName.startsWith("aop$constructorCall_con_")) {
                    throw new RuntimeException("Bad ConByConInfo name: '" + infoName + "'");
                }
                CtMethod wrapper = genadvisor.getDeclaredMethod(infoName);
                String joinPointName = "joinpoint_CByC_" + infoName.substring("aop$constructorCall_con_".length());
                CtField joinPointField = genadvisor.getDeclaredField(joinPointName);
                return new GeneratedAdvisorNameExtractor(infoName, wrapper, joinPointField);
            }
            if (infoField.getType().getName().equals(MethodByConInfo.class.getName())) {
                if (!infoName.startsWith("aop$methodCall_con")) {
                    throw new RuntimeException("Bad MethodByConInfo name: '" + infoName + "'");
                }
                CtMethod wrapper = genadvisor.getDeclaredMethod(infoName);
                String joinPointName = "joinpoint_MByC_" + infoName.substring("aop$methodCall_con_".length());
                CtField joinPointField = genadvisor.getDeclaredField(joinPointName);
                return new GeneratedAdvisorNameExtractor(infoName, wrapper, joinPointField);
            }
            return null;
        }

        public CtField getJoinPointField() {
            return this.joinPointField;
        }

        public CtMethod getWrapper() {
            return this.wrapper;
        }

        public String getInfoFieldName() {
            return this.infoName;
        }
    }
}

