/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.retrieval;

import org.jboss.logging.Logger;
import org.jboss.metadata.plugins.context.CachingMetaDataContext;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.context.MetaDataContext;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalToMetaDataBridge;

public class RetrievalUtils {
    private static final Logger log = Logger.getLogger(RetrievalUtils.class);

    public static MetaData createCachedMetaData(MetaData metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException("Null meta data");
        }
        if (metaData.getClass() != MetaDataRetrievalToMetaDataBridge.class) {
            log.warn("MetaDataUtils.createCachedMetaData(): meta data is not a MetaDataRetrievalToMetaDataBridge, not adding caching");
            return metaData;
        }
        if (!(((MetaDataRetrievalToMetaDataBridge)metaData).getMetaDataRetrieval() instanceof MetaDataContext)) {
            log.warn("MetaDataUtils.createCachedMetaData(): Could not determine structure of meta data, not adding caching");
            return metaData;
        }
        MetaDataContext ctx = (MetaDataContext)((MetaDataRetrievalToMetaDataBridge)metaData).getMetaDataRetrieval();
        return new MetaDataRetrievalToMetaDataBridge(RetrievalUtils.createCachedMetaDataContext(ctx));
    }

    private static MetaDataContext createCachedMetaDataContext(MetaDataContext ctx) {
        MetaDataContext parent = ctx.getParent();
        if (parent != null) {
            parent = RetrievalUtils.createCachedMetaDataContext(parent);
        }
        return new CachingMetaDataContext(parent, ctx.getLocalRetrievals());
    }
}

