/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.util.Arrays;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.SignatureAttribute;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.javassist.JavassistAccessController;
import org.jboss.reflect.plugins.javassist.JavassistAnnotatedParameterInfo;
import org.jboss.reflect.plugins.javassist.JavassistHelper;
import org.jboss.reflect.plugins.javassist.JavassistMethod;
import org.jboss.reflect.plugins.javassist.JavassistReflectionFactory;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.plugins.javassist.JavassistTypeVariableSpy;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.MutableMethodInfo;
import org.jboss.reflect.spi.MutableMethodInfoCommand;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class JavassistMethodInfo
extends JavassistAnnotatedParameterInfo
implements MutableMethodInfo {
    private static final long serialVersionUID = 101183748227690112L;
    private volatile transient JavassistMethod method;
    private transient TypeInfo returnType;

    public JavassistMethodInfo(AnnotationHelper annotationHelper, JavassistTypeInfo typeInfo, CtMethod ctMethod) {
        super(annotationHelper, typeInfo, ctMethod);
    }

    public String getName() {
        return ((CtMethod)this.ctBehavior).getName();
    }

    public ClassInfo getDeclaringClass() {
        return this.typeInfo;
    }

    public TypeInfo getReturnType() {
        if (this.returnType != null) {
            return this.returnType;
        }
        try {
            CtMethod ctMethod = (CtMethod)this.ctBehavior;
            SignatureAttribute.MethodSignature sig = JavassistHelper.getMethodSignature(ctMethod);
            if (sig != null && !(sig.getReturnType() instanceof SignatureAttribute.BaseType)) {
                return this.typeInfo.getFactory().getTypeInfo(this.typeInfo.getClassLoaderInternal(), sig.getReturnType(), JavassistTypeVariableSpy.createForBehavior(ctMethod, sig));
            }
            CtClass clazz = ctMethod.getReturnType();
            return this.typeInfo.getFactory().getTypeInfo(clazz);
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for return type of method " + this.getName(), e);
        }
    }

    public Object invoke(Object target, Object[] args) throws Throwable {
        if (this.method == null) {
            this.method = JavassistReflectionFactory.INSTANCE.createMethod(this);
        }
        JavassistAccessController.checkAccess(this);
        return this.method.invoke(target, args);
    }

    protected int getHashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MethodInfo)) {
            return false;
        }
        MethodInfo other = (MethodInfo)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        return Arrays.equals(this.getParameterTypes(), other.getParameterTypes());
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getName());
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.getName());
        super.toString(buffer);
    }

    public void executeCommand(MutableMethodInfoCommand mmc) {
    }

    public CtMethod getCtMethod() {
        return (CtMethod)this.ctBehavior;
    }

    public void setName(String name) {
        ((CtMethod)this.ctBehavior).setName(name);
        this.typeInfo.clearMethodCache();
    }

    public void setReturnType(String returnType) {
        throw new RuntimeException("Method not supported by Javassist");
    }

    public void setReturnType(ClassInfo returnType) {
        throw new RuntimeException("Method not supported by Javassist");
    }
}

