/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist.defaultmember;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.reflect.plugins.javassist.JavassistConstructor;
import org.jboss.reflect.plugins.javassist.JavassistConstructorInfo;
import org.jboss.reflect.plugins.javassist.JavassistField;
import org.jboss.reflect.plugins.javassist.JavassistFieldInfo;
import org.jboss.reflect.plugins.javassist.JavassistMethod;
import org.jboss.reflect.plugins.javassist.JavassistMethodInfo;
import org.jboss.reflect.plugins.javassist.defaultmember.DefaultJavassistConstructor;
import org.jboss.reflect.plugins.javassist.defaultmember.DefaultJavassistField;
import org.jboss.reflect.plugins.javassist.defaultmember.DefaultJavassistMethod;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMemberFactory {
    private static final Class<?>[] NO_PARAMS = new Class[0];

    public static JavassistMethod createJavassistMethod(JavassistMethodInfo methodInfo) {
        if (methodInfo == null) {
            throw new IllegalArgumentException("Null method");
        }
        try {
            Class<?> clazz = methodInfo.getDeclaringClass().getType();
            Class<?>[] params = DefaultMemberFactory.getParams(methodInfo.getParameterTypes());
            Method method = clazz.getDeclaredMethod(methodInfo.getName(), params);
            return new DefaultJavassistMethod(method);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JavassistConstructor createJavassistConstructor(JavassistConstructorInfo constructorInfo) {
        if (constructorInfo == null) {
            throw new IllegalArgumentException("Null constructor");
        }
        try {
            Class<?> clazz = constructorInfo.getDeclaringClass().getType();
            Class<?>[] params = DefaultMemberFactory.getParams(constructorInfo.getParameterTypes());
            Constructor<?> ctor = clazz.getDeclaredConstructor(params);
            return new DefaultJavassistConstructor(ctor);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JavassistField createJavassistField(JavassistFieldInfo fieldInfo) {
        if (fieldInfo == null) {
            throw new IllegalArgumentException("Null field");
        }
        try {
            Class<?> clazz = fieldInfo.getDeclaringClass().getType();
            Field field = clazz.getDeclaredField(fieldInfo.getName());
            return new DefaultJavassistField(field);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?>[] getParams(TypeInfo[] typeParams) {
        if (typeParams == null || typeParams.length == 0) {
            return NO_PARAMS;
        }
        Class[] params = new Class[typeParams.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = typeParams[i].getType();
        }
        return params;
    }
}

