package org.jboss.arquillian.api;

import org.jboss.shrinkwrap.api.Archive;

/**
 * An archive deployer
 *
 * An instance of this object can be injected into an test case like this
 *
 * <code>
 * @Inject
 * ArchiveDeployer deployer;
 * </code>
 *
 * @author Thomas.Diesler@jboss.com
 * @since 16-Feb-2011
 */
public interface ArchiveDeployer {

    String deploy(Archive<?> archive) throws Exception;

    void undeploy(String runtimeName) throws Exception;
}