/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.jboss.arquillian.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.RunWith;
import org.junit.runner.notification.Failure;

public class JUnitIntegrationTestCase {
    public static Map<String, Integer> containerCallbacks = new HashMap<String, Integer>();

    static {
        containerCallbacks.put("setup", 0);
        containerCallbacks.put("start", 0);
        containerCallbacks.put("stop", 0);
        containerCallbacks.put("deploy", 0);
        containerCallbacks.put("undeploy", 0);
        containerCallbacks.put("shouldBeInvoked", 0);
    }

    public static void wasCalled(String name) {
        if (!containerCallbacks.containsKey(name)) {
            throw new RuntimeException("Unknown callback: " + name);
        }
        containerCallbacks.put(name, containerCallbacks.get(name) + 1);
    }

    @Test
    public void shouldHandleTheLifecycleCorrectlyOnMultipleTestRunsWithExceptions() throws Throwable {
        JUnitCore runner = new JUnitCore();
        Result result = runner.run(Request.classes((Class[])new Class[]{TestClass1.class, TestClass1.class}));
        Assert.assertEquals((String)"Verify that both exceptions thrown bubbled up", (int)2, (int)result.getFailureCount());
        Assert.assertEquals((String)"Verify exception thrown", (String)"deploy", (String)((Failure)result.getFailures().get(0)).getException().getCause().getMessage());
        Assert.assertEquals((String)"Verify exception thrown", (String)"undeploy", (String)((Failure)result.getFailures().get(1)).getException().getCause().getMessage());
        Assert.assertFalse((boolean)result.wasSuccessful());
        this.assertCallbacks();
    }

    private void assertCallbacks() throws Exception {
        Assert.assertEquals((String)"Verify container only setup once", (int)1, (int)containerCallbacks.get("setup"));
        Assert.assertEquals((String)"Verify container only started once", (int)1, (int)containerCallbacks.get("start"));
        Assert.assertEquals((String)"Verify container only stopped once", (int)1, (int)containerCallbacks.get("stop"));
        Assert.assertEquals((String)"Verify deployed twice", (int)2, (int)containerCallbacks.get("deploy"));
        Assert.assertEquals((String)"Verify undeployed twice", (int)2, (int)containerCallbacks.get("undeploy"));
        Assert.assertEquals((String)"Verify test invoked only once, first run should fail during deploy", (int)1, (int)containerCallbacks.get("shouldBeInvoked"));
    }

    @RunWith(value=Arquillian.class)
    public static class TestClass1 {
        @Deployment
        public static JavaArchive create() {
            return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        }

        @Test
        public void shouldBeInvoked() throws Exception {
            JUnitIntegrationTestCase.wasCalled("shouldBeInvoked");
        }
    }
}

