/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit;

import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.JUnitTestRunner;
import org.jboss.arquillian.spi.TestResult;
import org.junit.Assert;
import org.junit.Test;

public class JUnitTestRunnerTestCase {
    @Test
    public void shouldReturnPassedTest() throws Exception {
        JUnitTestRunner runner = new JUnitTestRunner();
        TestResult result = runner.execute(JUnitTestRunnerTestCase.class, "shouldProvidePassingTestToRunner");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)TestResult.Status.PASSED, (Object)result.getStatus());
        Assert.assertNull((Object)result.getThrowable());
    }

    @Test
    public void shouldReturnExceptionOnPassedTest() throws Exception {
        Arquillian.caughtTestException.set(new IllegalArgumentException());
        JUnitTestRunner runner = new JUnitTestRunner();
        TestResult result = runner.execute(JUnitTestRunnerTestCase.class, "shouldProvideExpectedExceptionToRunner");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)TestResult.Status.PASSED, (Object)result.getStatus());
        Assert.assertNotNull((Object)result.getThrowable());
        Assert.assertEquals(IllegalArgumentException.class, result.getThrowable().getClass());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldProvideExpectedExceptionToRunner() throws Exception {
        throw new IllegalArgumentException();
    }

    @Test
    public void shouldProvidePassingTestToRunner() throws Exception {
        Assert.assertTrue((boolean)true);
    }
}

