/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.jboss.arquillian.api.Deployment;
import org.jboss.arquillian.api.OperateOnDeployment;
import org.jboss.arquillian.impl.core.ManagerImpl;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.RunWith;
import org.junit.runner.notification.Failure;

public class JUnitIntegrationTestCase {
    public static Map<String, Integer> containerCallbacks = new HashMap<String, Integer>();

    public JUnitIntegrationTestCase() {
        ManagerImpl.DEBUG = false;
    }

    public static void wasCalled(String name) {
        if (!containerCallbacks.containsKey(name)) {
            throw new RuntimeException("Unknown callback: " + name);
        }
        containerCallbacks.put(name, containerCallbacks.get(name) + 1);
    }

    @Test
    public void shouldHandleTheLifecycleCorrectlyOnMultipleTestRunsWithExceptions() throws Throwable {
        JUnitCore runner = new JUnitCore();
        Result result = runner.run(Request.classes((Class[])new Class[]{ArquillianClass1.class, ArquillianClass1.class}));
        Assert.assertEquals((String)"Verify that both exceptions thrown bubbled up", (int)2, (int)result.getFailureCount());
        Assert.assertEquals((String)"Verify exception thrown", (String)"deploy", (String)((Failure)result.getFailures().get(0)).getException().getMessage());
        Assert.assertEquals((String)"Verify exception thrown", (String)"undeploy", (String)((Failure)result.getFailures().get(1)).getException().getMessage());
        Assert.assertFalse((boolean)result.wasSuccessful());
        this.assertCallbacks();
    }

    private void assertCallbacks() throws Exception {
        Assert.assertEquals((String)"Verify container only setup once", (int)1, (int)containerCallbacks.get("setup"));
        Assert.assertEquals((String)"Verify container only started once", (int)1, (int)containerCallbacks.get("start"));
        Assert.assertEquals((String)"Verify container only stopped once", (int)1, (int)containerCallbacks.get("stop"));
        Assert.assertEquals((String)"Verify deployed twice", (int)2, (int)containerCallbacks.get("deploy"));
        Assert.assertEquals((String)"Verify undeployed twice", (int)2, (int)containerCallbacks.get("undeploy"));
        Assert.assertEquals((String)"Verify beforeClass not called", (int)0, (int)containerCallbacks.get("beforeClass"));
        Assert.assertEquals((String)"Verify before not called", (int)0, (int)containerCallbacks.get("before"));
        Assert.assertEquals((String)"Verify test invoked only once, first run should fail during deploy", (int)1, (int)containerCallbacks.get("shouldBeInvoked"));
        Assert.assertEquals((String)"Verify after not called", (int)0, (int)containerCallbacks.get("after"));
        Assert.assertEquals((String)"Verify afterClass not called", (int)0, (int)containerCallbacks.get("afterClass"));
    }

    static {
        containerCallbacks.put("setup", 0);
        containerCallbacks.put("start", 0);
        containerCallbacks.put("stop", 0);
        containerCallbacks.put("deploy", 0);
        containerCallbacks.put("undeploy", 0);
        containerCallbacks.put("beforeClass", 0);
        containerCallbacks.put("before", 0);
        containerCallbacks.put("shouldBeInvoked", 0);
        containerCallbacks.put("after", 0);
        containerCallbacks.put("afterClass", 0);
    }

    @RunWith(value=Arquillian.class)
    public static class ArquillianClass1 {
        @Deployment(name="test")
        public static JavaArchive create() {
            return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        }

        @BeforeClass
        public static void beforeClass() {
            JUnitIntegrationTestCase.wasCalled("beforeClass");
        }

        @AfterClass
        public static void afterClass() {
            JUnitIntegrationTestCase.wasCalled("afterClass");
        }

        @Before
        public void before() {
            JUnitIntegrationTestCase.wasCalled("before");
        }

        @After
        public void after() {
            JUnitIntegrationTestCase.wasCalled("after");
        }

        @Test
        @OperateOnDeployment(value="test")
        public void shouldBeInvoked() throws Exception {
            JUnitIntegrationTestCase.wasCalled("shouldBeInvoked");
        }
    }
}

