/*
 * Decompiled with CFR 0.152.
 */
package com.acme.ejb;

import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destination", propertyValue="queue/DLQ"), @ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue")})
public class MessageEcho
implements MessageListener {
    @Resource(mappedName="java:/ConnectionFactory")
    private ConnectionFactory factory;

    public void onMessage(Message msg) {
        try {
            System.out.println("received " + msg.getJMSMessageID());
            Connection connection = this.factory.createConnection();
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer(msg.getJMSReplyTo());
            producer.send(msg);
            producer.close();
            session.close();
            connection.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not reply to message", e);
        }
    }
}

