/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.angular.ftest;

import java.net.URL;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.angular.findby.FindByNg;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@RunWith(value=Arquillian.class)
@RunAsClient
public class AngularElementTest {
    @Drone
    private WebDriver browser;
    @ArquillianResource
    private URL contextRoot;
    @FindByNg(model="todo.done")
    List<WebElement> todos;
    @FindByNg(model="todoText")
    WebElement todoEntry;
    @FindByNg(action="archive()")
    WebElement archive;
    @FindByNg(action="addTodo()")
    WebElement addTodo;
    @FindByNg(repeat="todo in todos")
    List<WebElement> todoRepeat;

    @Deployment
    public static WebArchive createTestArchive() {
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"angular-test.war");
        war.addAsWebResource("app/index.html", "index.html");
        war.addAsWebResource("app/app.js", "app.js");
        war.addAsWebResource("app/todo.js", "todo.js");
        war.addAsWebResource("app/lib/angular.js", "lib/angular.js");
        return war;
    }

    @Before
    public void loadPage() {
        this.browser.navigate().to(this.contextRoot + "index.html");
    }

    @Test
    public void testNumberOfTodosAtStart() {
        Assert.assertEquals((long)2L, (long)this.todos.size());
    }

    @Test
    public void testArchive() {
        Assert.assertEquals((long)2L, (long)this.todos.size());
        this.archive.click();
        Assert.assertEquals((long)1L, (long)this.todos.size());
    }

    @Test
    public void testAddTodo() {
        Assert.assertEquals((long)2L, (long)this.todos.size());
        this.todoEntry.sendKeys(new CharSequence[]{"This is a new TODO item"});
        this.addTodo.submit();
        Assert.assertEquals((long)3L, (long)this.todos.size());
    }

    @Test
    public void testRepeater() {
        Assert.assertEquals((long)2L, (long)this.todoRepeat.size());
        WebElement secondRow = this.todoRepeat.get(1);
        WebElement checkbox = secondRow.findElement(By.tagName((String)"input"));
        WebElement todoItem = secondRow.findElement(By.tagName((String)"span"));
        Assert.assertEquals((Object)"second todo", (Object)todoItem.getText());
        checkbox.click();
        this.archive.click();
        Assert.assertEquals((long)0L, (long)this.todoRepeat.size());
    }
}

