/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.configuration;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.drone.configuration.ConfigurationMapper;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.AndroidDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.ChromeDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.FirefoxDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.HtmlUnitDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.IPhoneDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.InternetExplorerDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfigurationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedWebDriverConfiguration<T extends WebDriverConfigurationType>
implements DroneConfiguration<TypedWebDriverConfiguration<T>>,
AndroidDriverConfiguration,
ChromeDriverConfiguration,
FirefoxDriverConfiguration,
HtmlUnitDriverConfiguration,
InternetExplorerDriverConfiguration,
IPhoneDriverConfiguration,
WebDriverConfiguration {
    public static final String CONFIGURATION_NAME = "webdriver";
    protected Class<T> type;
    protected String implementationClass;
    protected int iePort;
    protected String applicationName;
    protected String applicationVersion;
    protected String userAgent;
    protected String firefoxProfile;
    protected String firefoxBinary;
    protected String chromeBinary;
    protected String chromeDriverBinary;
    protected String chromeSwitches;
    protected String remoteAddress;
    protected float browserVersionNumeric;
    protected boolean useJavaScript;

    public TypedWebDriverConfiguration(Class<T> type, String implementationClass) {
        this.type = type;
        this.implementationClass = implementationClass;
    }

    @Override
    public String getImplementationClass() {
        return this.implementationClass;
    }

    @Override
    public void setImplementationClass(String implementationClass) {
        this.implementationClass = implementationClass;
    }

    @Override
    public void setIePort(final int iePort) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.iePort = iePort;
                return null;
            }
        };
        interceptor.intercept("setIePort", Integer.TYPE);
    }

    @Override
    public int getIePort() {
        CallInterceptor<Integer> interceptor = new CallInterceptor<Integer>(){

            @Override
            public Integer invoke() {
                return TypedWebDriverConfiguration.this.iePort;
            }
        };
        return (Integer)interceptor.intercept("getIePort", new Class[0]);
    }

    @Override
    public String getApplicationName() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.applicationName;
            }
        };
        return (String)interceptor.intercept("getApplicationName", new Class[0]);
    }

    @Override
    public void setApplicationName(final String applicationName) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.applicationName = applicationName;
                return null;
            }
        };
        interceptor.intercept("setApplicationName", String.class);
    }

    @Override
    public String getApplicationVersion() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.applicationVersion;
            }
        };
        return (String)interceptor.intercept("getApplicationVersion", new Class[0]);
    }

    @Override
    public void setApplicationVersion(final String applicationVersion) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.applicationVersion = applicationVersion;
                return null;
            }
        };
        interceptor.intercept("setApplicationVersion", String.class);
    }

    @Override
    public String getUserAgent() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.userAgent;
            }
        };
        return (String)interceptor.intercept("getUserAgent", new Class[0]);
    }

    @Override
    public void setUserAgent(final String userAgent) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.userAgent = userAgent;
                return null;
            }
        };
        interceptor.intercept("setUserAgent", String.class);
    }

    @Override
    public float getBrowserVersionNumeric() {
        CallInterceptor<Float> interceptor = new CallInterceptor<Float>(){

            @Override
            public Float invoke() {
                return Float.valueOf(TypedWebDriverConfiguration.this.browserVersionNumeric);
            }
        };
        return ((Float)interceptor.intercept("getBrowserVersionNumeric", new Class[0])).floatValue();
    }

    @Override
    public void setBrowserVersionNumeric(final float browserVersionNumeric) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.browserVersionNumeric = browserVersionNumeric;
                return null;
            }
        };
        interceptor.intercept("setBrowserVersionNumeric", Float.TYPE);
    }

    @Override
    public boolean isUseJavaScript() {
        CallInterceptor<Boolean> interceptor = new CallInterceptor<Boolean>(){

            @Override
            public Boolean invoke() {
                return TypedWebDriverConfiguration.this.useJavaScript;
            }
        };
        return (Boolean)interceptor.intercept("isUseJavaScript", new Class[0]);
    }

    @Override
    public void setUseJavaScript(final boolean useJavaScript) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.useJavaScript = useJavaScript;
                return null;
            }
        };
        interceptor.intercept("setUseJavaScript", Boolean.TYPE);
    }

    @Override
    public String getFirefoxProfile() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.firefoxProfile;
            }
        };
        return (String)interceptor.intercept("getFirefoxProfile", new Class[0]);
    }

    @Override
    public void setFirefoxProfile(final String firefoxProfile) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.firefoxProfile = firefoxProfile;
                return null;
            }
        };
        interceptor.intercept("setFirefoxProfile", String.class);
    }

    @Override
    public String getFirefoxBinary() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.firefoxBinary;
            }
        };
        return (String)interceptor.intercept("getFirefoxBinary", new Class[0]);
    }

    @Override
    public void setFirefoxBinary(final String firefoxBinary) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.firefoxBinary = firefoxBinary;
                return null;
            }
        };
        interceptor.intercept("setFirefoxBinary", String.class);
    }

    @Override
    public String getChromeBinary() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.chromeBinary;
            }
        };
        return (String)interceptor.intercept("getChromeBinary", new Class[0]);
    }

    @Override
    public void setChromeBinary(final String chromeBinary) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.chromeBinary = chromeBinary;
                return null;
            }
        };
        interceptor.intercept("setChromeBinary", String.class);
    }

    @Override
    public void setChromeDriverBinary(final String chromeDriverBinary) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.chromeDriverBinary = chromeDriverBinary;
                return null;
            }
        };
        interceptor.intercept("setChromeDriverBinary", String.class);
    }

    @Override
    public String getChromeDriverBinary() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.chromeDriverBinary;
            }
        };
        return (String)interceptor.intercept("getChromeDriverBinary", new Class[0]);
    }

    @Override
    public void setChromeSwitches(final String chromeSwitches) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.chromeSwitches = chromeSwitches;
                return null;
            }
        };
        interceptor.intercept("setChromeSwitches", String.class);
    }

    @Override
    public String getChromeSwitches() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.chromeSwitches;
            }
        };
        return (String)interceptor.intercept("getChromeSwitches", new Class[0]);
    }

    @Override
    public void setRemoteAddress(final String remoteAddress) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.remoteAddress = remoteAddress;
                return null;
            }
        };
        interceptor.intercept("setRemoteAddress", String.class);
    }

    @Override
    public String getRemoteAddress() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.remoteAddress;
            }
        };
        return (String)interceptor.intercept("getRemoteAddress", new Class[0]);
    }

    public String getConfigurationName() {
        return CONFIGURATION_NAME;
    }

    public TypedWebDriverConfiguration<T> configure(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        ConfigurationMapper.fromArquillianDescriptor((ArquillianDescriptor)descriptor, (DroneConfiguration)this, qualifier);
        return (TypedWebDriverConfiguration)ConfigurationMapper.fromSystemConfiguration((DroneConfiguration)this, qualifier);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class CallInterceptor<R> {
        private Boolean exists = null;

        private CallInterceptor() {
        }

        private boolean methodExists(String name, Class<?>[] parameterTypes) {
            if (this.exists != null) {
                return this.exists;
            }
            try {
                TypedWebDriverConfiguration.this.type.getMethod(name, parameterTypes);
                this.exists = true;
            }
            catch (NoSuchMethodException e) {
                this.exists = false;
            }
            return this.exists;
        }

        public abstract R invoke();

        public R intercept(String name, Class<?> ... parameterTypes) {
            if (this.methodExists(name, parameterTypes)) {
                return this.invoke();
            }
            String propertyName = this.decamelize(name);
            String configurationName = TypedWebDriverConfiguration.this.type.getSimpleName().replaceAll("ConfigurationType", "");
            throw new IllegalStateException("Property with name " + propertyName + " is not valid for " + configurationName + ". Make sure you are using proper configuration element for the WebDriver browser type");
        }

        private String decamelize(String name) {
            StringBuilder sb = new StringBuilder(name.substring(3));
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
            return sb.toString();
        }
    }
}

