/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.io.File;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.FirefoxDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.TypedWebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.factory.Validate;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirefoxDriverFactory
implements Configurator<FirefoxDriver, TypedWebDriverConfiguration<FirefoxDriverConfiguration>>,
Instantiator<FirefoxDriver, TypedWebDriverConfiguration<FirefoxDriverConfiguration>>,
Destructor<FirefoxDriver> {
    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(FirefoxDriver instance) {
        instance.quit();
    }

    public FirefoxDriver createInstance(TypedWebDriverConfiguration<FirefoxDriverConfiguration> configuration) {
        String binary = configuration.getFirefoxBinary();
        String profile = configuration.getFirefoxProfile();
        if (Validate.empty(binary) && Validate.empty(profile)) {
            return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[0], new Object[0], FirefoxDriver.class);
        }
        if (Validate.empty(profile)) {
            Validate.isExecutable(binary, "Firefox binary does not point to a valid executable,  " + binary);
            return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{FirefoxBinary.class, FirefoxProfile.class}, new Object[]{new FirefoxBinary(new File(binary)), null}, FirefoxDriver.class);
        }
        if (Validate.empty(binary)) {
            Validate.isValidPath(profile, "Firefox profile does not point to a valid path " + profile);
            return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{FirefoxProfile.class}, new Object[]{new FirefoxProfile(new File(profile))}, FirefoxDriver.class);
        }
        Validate.isValidPath(profile, "Firefox profile does not point to a valid path,  " + profile);
        Validate.isExecutable(binary, "Firefox binary does not point to a valid executable,  " + binary);
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{FirefoxBinary.class, FirefoxProfile.class}, new Object[]{new FirefoxBinary(new File(binary)), new FirefoxProfile(new File(profile))}, FirefoxDriver.class);
    }

    public TypedWebDriverConfiguration<FirefoxDriverConfiguration> createConfiguration(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        return new TypedWebDriverConfiguration<FirefoxDriverConfiguration>(FirefoxDriverConfiguration.class, "org.openqa.selenium.firefox.FirefoxDriver").configure(descriptor, qualifier);
    }
}

