/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.IPhoneDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.TypedWebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.factory.Validate;
import org.openqa.selenium.iphone.IPhoneDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPhoneDriverFactory
implements Configurator<IPhoneDriver, TypedWebDriverConfiguration<IPhoneDriverConfiguration>>,
Instantiator<IPhoneDriver, TypedWebDriverConfiguration<IPhoneDriverConfiguration>>,
Destructor<IPhoneDriver> {
    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(IPhoneDriver instance) {
        instance.quit();
    }

    public IPhoneDriver createInstance(TypedWebDriverConfiguration<IPhoneDriverConfiguration> configuration) {
        String remoteAddress = configuration.getRemoteAddress();
        if (Validate.empty(remoteAddress)) {
            return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[0], new Object[0], IPhoneDriver.class);
        }
        Validate.isValidUrl(remoteAddress, "Remote address must be a valid url, " + remoteAddress);
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{String.class}, new Object[]{remoteAddress}, IPhoneDriver.class);
    }

    public TypedWebDriverConfiguration<IPhoneDriverConfiguration> createConfiguration(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        return new TypedWebDriverConfiguration<IPhoneDriverConfiguration>(IPhoneDriverConfiguration.class, "org.openqa.selenium.iphone.IPhoneDriver").configure(descriptor, qualifier);
    }
}

