/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.InternetExplorerDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.TypedWebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.openqa.selenium.ie.InternetExplorerDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternetExplorerDriverFactory
implements Configurator<InternetExplorerDriver, TypedWebDriverConfiguration<InternetExplorerDriverConfiguration>>,
Instantiator<InternetExplorerDriver, TypedWebDriverConfiguration<InternetExplorerDriverConfiguration>>,
Destructor<InternetExplorerDriver> {
    public static final int DEFAULT_INTERNET_EXPLORER_PORT = 0;

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(InternetExplorerDriver instance) {
        instance.quit();
    }

    public InternetExplorerDriver createInstance(TypedWebDriverConfiguration<InternetExplorerDriverConfiguration> configuration) {
        int port = configuration.getIePort();
        if (port == 0) {
            return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[0], new Object[0], InternetExplorerDriver.class);
        }
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{Integer.TYPE}, new Object[]{port}, InternetExplorerDriver.class);
    }

    public TypedWebDriverConfiguration<InternetExplorerDriverConfiguration> createConfiguration(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        return new TypedWebDriverConfiguration<InternetExplorerDriverConfiguration>(InternetExplorerDriverConfiguration.class, "org.openqa.selenium.ie.InternetExplorerDriver").configure(descriptor, qualifier);
    }
}

