/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(GetTcclAction.INSTANCE);
    }

    static Constructor<?> getConstructor(final Class<?> clazz, final Class<?> ... argumentTypes) throws NoSuchMethodException {
        try {
            return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>>(){

                @Override
                public Constructor<?> run() throws NoSuchMethodException {
                    return clazz.getConstructor(argumentTypes);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static Class<?> getClass(String className) {
        if (className == null) {
            throw new IllegalArgumentException("ClassName must be specified");
        }
        try {
            ClassLoader tccl = SecurityActions.getThreadContextClassLoader();
            return Class.forName(className, false, tccl);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to find implementation class " + className + " on current classpath. Please make sure it is present on the classpath.");
        }
    }

    static <T> T newInstance(String className, Class<?>[] argumentTypes, Object[] arguments, Class<T> expectedType) {
        Object obj;
        if (className == null) {
            throw new IllegalArgumentException("ClassName must be specified");
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException("ArgumentTypes must be specified. Use empty array if no arguments");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Arguments must be specified. Use empty array if no arguments");
        }
        try {
            Class<?> implClass = SecurityActions.getClass(className);
            Constructor<?> constructor = SecurityActions.getConstructor(implClass, argumentTypes);
            obj = constructor.newInstance(arguments);
        }
        catch (NoSuchMethodException e) {
            StringBuilder argNames = new StringBuilder();
            for (Class<?> arg : argumentTypes) {
                argNames.append(arg.getSimpleName()).append(", ");
            }
            if (argNames.length() > 0) {
                argNames.deleteCharAt(argNames.length() - 1);
            }
            throw new IllegalStateException("Unable to find a proper constructor for implementation class " + className + " with given parameters (" + argNames.toString() + "). Please make sure that you haven't misconfigured Arquillian Drone, " + "e.g. you set an implementationClass which does not match the field/parameter type in your code.");
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Unable to instantiate a " + className + ". Please make sure that you haven't misconfigured Arquillian Drone, " + "e.g. you set an implementationClass which does not match the field/parameter type in your code.", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Unable to instantiate a " + className + ". Please make sure that you haven't misconfigured Arquillian Drone, " + "e.g. you set an implementationClass which does not match the field/parameter type in your code.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to instantiate a " + className + " instance, access refused by SecurityManager.", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Unable to instantiate a " + className + ". Please make sure that you haven't misconfigured Arquillian Drone, " + "e.g. you set an implementationClass which does not match the field/parameter type in your code.", e);
        }
        try {
            return expectedType.cast(obj);
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Incorrect expected type, " + expectedType.getName() + ", defined for " + obj.getClass().getName());
        }
    }

    static String getProperty(final String key) {
        try {
            String value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static String setProperty(final String key, final String value) {
        try {
            String oldValue = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    if (value == null) {
                        return System.clearProperty(key);
                    }
                    return System.setProperty(key, value);
                }
            });
            return oldValue;
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

