/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

class Validate {
    Validate() {
    }

    static boolean empty(String object) {
        return object == null || object.length() == 0;
    }

    static boolean nonEmpty(String object) {
        return !Validate.empty(object);
    }

    static void isEmpty(String object, String message) throws IllegalArgumentException {
        if (Validate.empty(object)) {
            throw new IllegalArgumentException(message);
        }
    }

    static void isValidPath(String path, String message) throws IllegalArgumentException {
        Validate.isEmpty(path, message);
        File file = new File(path);
        if (!file.exists() || !file.canRead()) {
            throw new IllegalArgumentException(message);
        }
    }

    static void isValidUrl(String url, String message) throws IllegalArgumentException {
        Validate.isEmpty(url, message);
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(message, e);
        }
    }

    static void isExecutable(String path, String message) throws IllegalArgumentException {
        Validate.isEmpty(path, message);
        File file = new File(path);
        if (!file.exists() || !file.canExecute()) {
            throw new IllegalArgumentException(message);
        }
    }
}

