/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DroneRegistry;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.TypedWebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverFactory
implements Configurator<WebDriver, TypedWebDriverConfiguration<WebDriverConfiguration>>,
Instantiator<WebDriver, TypedWebDriverConfiguration<WebDriverConfiguration>>,
Destructor<WebDriver> {
    @Inject
    private Instance<DroneRegistry> registryInstance;

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(WebDriver instance) {
        instance.quit();
    }

    public WebDriver createInstance(TypedWebDriverConfiguration<WebDriverConfiguration> configuration) {
        Class<?> implementationClass;
        String implementationClassName = configuration.getImplementationClass();
        DroneRegistry registry = (DroneRegistry)this.registryInstance.get();
        Instantiator instantiator = (Instantiator)registry.getEntryFor(implementationClass = SecurityActions.getClass(implementationClassName), Instantiator.class);
        if (instantiator != null && instantiator.getClass() != this.getClass()) {
            return (WebDriver)instantiator.createInstance(configuration);
        }
        WebDriver driver = SecurityActions.newInstance(configuration.getImplementationClass(), new Class[0], new Object[0], WebDriver.class);
        return driver;
    }

    public TypedWebDriverConfiguration<WebDriverConfiguration> createConfiguration(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        return new TypedWebDriverConfiguration<WebDriverConfiguration>(WebDriverConfiguration.class, "org.openqa.selenium.htmlunit.HtmlUnitDriver").configure(descriptor, qualifier);
    }
}

