/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.augmentation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jboss.arquillian.drone.spi.Enhancer;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusableRemoteWebDriver;
import org.jboss.arquillian.drone.webdriver.spi.DroneAugmented;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.InterfaceImplementation;
import org.openqa.selenium.remote.RemoteWebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AugmentingEnhancer
implements Enhancer<RemoteWebDriver> {
    public static final String DRONE_AUGMENTED = "droneAugmented";
    private final Augmenter augmenter = new Augmenter(){
        {
            this.addDriverAugmentation(AugmentingEnhancer.DRONE_AUGMENTED, new AugmenterProvider(){

                public Class<?> getDescribedInterface() {
                    return DroneAugmented.class;
                }

                public InterfaceImplementation getImplementation(Object value) {
                    return new DroneAugmentedImpl((RemoteWebDriver)value);
                }
            });
        }
    };

    public int getPrecedence() {
        return 0;
    }

    public boolean canEnhance(Class<?> type, Class<? extends Annotation> qualifier) {
        if (RemoteWebDriver.class == type || ReusableRemoteWebDriver.class == type) {
            return true;
        }
        return RemoteWebDriver.class.isAssignableFrom(type) && DroneAugmented.class.isAssignableFrom(type);
    }

    public RemoteWebDriver enhance(RemoteWebDriver instance, Class<? extends Annotation> qualifier) {
        RemoteWebDriver enhanced = (RemoteWebDriver)this.augmenter.augment((WebDriver)instance);
        return enhanced;
    }

    public RemoteWebDriver deenhance(RemoteWebDriver enhancedInstance, Class<? extends Annotation> qualifier) {
        if (enhancedInstance instanceof DroneAugmented) {
            RemoteWebDriver original = (RemoteWebDriver)((DroneAugmented)enhancedInstance).getWrapped();
            Capabilities capabilities = enhancedInstance.getCapabilities();
            if (capabilities != null) {
                ((DesiredCapabilities)enhancedInstance.getCapabilities()).setCapability(DRONE_AUGMENTED, (Object)Boolean.FALSE);
            }
            return original;
        }
        return enhancedInstance;
    }

    private class DroneAugmentedImpl
    implements InterfaceImplementation {
        private transient RemoteWebDriver original;

        public DroneAugmentedImpl(RemoteWebDriver original) {
            this.original = original;
        }

        public Object invoke(ExecuteMethod executeMethod, Object self, Method method, Object ... args) {
            return this.original;
        }
    }
}

