/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.configuration;

import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.drone.configuration.ConfigurationMapper;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilities;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverConfiguration
implements DroneConfiguration<WebDriverConfiguration> {
    private static final Logger log = Logger.getLogger(WebDriverConfiguration.class.getName());
    public static final String CONFIGURATION_NAME = "webdriver";
    public static URL DEFAULT_REMOTE_URL;
    public static final String DEFAULT_BROWSER_CAPABILITIES;
    @Deprecated
    private String implementationClass;
    private int iePort;
    @Deprecated
    private String applicationName;
    @Deprecated
    private String applicationVersion;
    @Deprecated
    private String userAgent;
    @Deprecated
    private String firefoxProfile;
    @Deprecated
    private String firefoxBinary;
    @Deprecated
    private String chromeBinary;
    private String chromeDriverBinary;
    @Deprecated
    private String chromeSwitches;
    private URL remoteAddress;
    @Deprecated
    private float browserVersionNumeric;
    @Deprecated
    private boolean useJavaScript = true;
    @Deprecated
    private String operaArguments;
    @Deprecated
    private boolean operaAutostart = true;
    @Deprecated
    private String operaBinary;
    @Deprecated
    private int operaDisplay = -1;
    @Deprecated
    private boolean operaIdle = false;
    @Deprecated
    private String operaLauncher;
    @Deprecated
    private String operaLoggingFile;
    @Deprecated
    private String operaLoggingLevel = "INFO";
    @Deprecated
    private int operaPort = 0;
    @Deprecated
    private String operaProfile;
    @Deprecated
    private String operaProduct;
    @Deprecated
    private boolean operaQuit = true;
    @Deprecated
    private boolean operaRestart = true;
    private String browserCapabilities;
    private boolean remoteReusable;
    private boolean remote;
    private boolean reuseCookies;
    private Map<String, Object> capabilityMap;
    private String _originalBrowserCapabilities;
    private BrowserCapabilities _browserCapabilities;

    public WebDriverConfiguration(BrowserCapabilities browser) {
        if (browser != null) {
            this._browserCapabilities = browser;
            this.browserCapabilities = this._originalBrowserCapabilities = browser.getReadableName();
        }
    }

    public void setBrowserCapabilitiesInternal(BrowserCapabilities browser) {
        if (browser != null) {
            this._browserCapabilities = browser;
            this.browserCapabilities = browser.getReadableName();
        }
    }

    @Deprecated
    public WebDriverConfiguration(String implementationClass) {
        this.implementationClass = implementationClass;
    }

    public WebDriverConfiguration configure(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        ConfigurationMapper.fromArquillianDescriptor((ArquillianDescriptor)descriptor, (DroneConfiguration)this, qualifier);
        ConfigurationMapper.fromSystemConfiguration((DroneConfiguration)this, qualifier);
        if (this._originalBrowserCapabilities != null && !this._originalBrowserCapabilities.equals(this.browserCapabilities)) {
            log.log(Level.WARNING, "Arquillian configuration is specifying a Drone of type {0}, however test class specifically asked for {1}. As Drone cannot guarantee that those two are compatible, Arquillian configuration will be ignored.", new Object[]{this.browserCapabilities, this._originalBrowserCapabilities});
            this.browserCapabilities = this._originalBrowserCapabilities;
        }
        return this;
    }

    @Deprecated
    public String getApplicationName() {
        return this.applicationName;
    }

    @Deprecated
    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getBrowserCapabilities() {
        if (this._browserCapabilities != null) {
            return this._browserCapabilities.getReadableName();
        }
        return this.browserCapabilities;
    }

    @Deprecated
    public float getBrowserVersionNumeric() {
        return this.browserVersionNumeric;
    }

    public Capabilities getCapabilities() {
        return new DesiredCapabilities(new Capabilities[]{new DesiredCapabilities(this._browserCapabilities.getRawCapabilities() == null ? new HashMap() : this._browserCapabilities.getRawCapabilities()), new DesiredCapabilities(this.capabilityMap)});
    }

    @Deprecated
    public String getChromeBinary() {
        return this.chromeBinary;
    }

    public String getChromeDriverBinary() {
        return this.chromeDriverBinary;
    }

    @Deprecated
    public String getChromeSwitches() {
        return this.chromeSwitches;
    }

    public String getConfigurationName() {
        return CONFIGURATION_NAME;
    }

    @Deprecated
    public String getFirefoxBinary() {
        return this.firefoxBinary;
    }

    @Deprecated
    public String getFirefoxProfile() {
        return this.firefoxProfile;
    }

    public int getIePort() {
        return this.iePort;
    }

    public String getImplementationClass() {
        String implementationClassName = this.implementationClass;
        if (implementationClassName == null && this._browserCapabilities != null) {
            implementationClassName = this._browserCapabilities.getImplementationClassName();
        }
        return implementationClassName;
    }

    @Deprecated
    public String getOperaArguments() {
        return this.operaArguments;
    }

    @Deprecated
    public String getOperaBinary() {
        return this.operaBinary;
    }

    @Deprecated
    public int getOperaDisplay() {
        return this.operaDisplay;
    }

    @Deprecated
    public String getOperaLauncher() {
        return this.operaLauncher;
    }

    @Deprecated
    public String getOperaLoggingFile() {
        return this.operaLoggingFile;
    }

    @Deprecated
    public String getOperaLoggingLevel() {
        return this.operaLoggingLevel;
    }

    @Deprecated
    public int getOperaPort() {
        return this.operaPort;
    }

    @Deprecated
    public String getOperaProduct() {
        return this.operaProduct;
    }

    @Deprecated
    public String getOperaProfile() {
        return this.operaProfile;
    }

    public URL getRemoteAddress() {
        return this.remoteAddress;
    }

    @Deprecated
    public String getUserAgent() {
        return this.userAgent;
    }

    @Deprecated
    public boolean isOperaAutostart() {
        return this.operaAutostart;
    }

    @Deprecated
    public boolean isOperaIdle() {
        return this.operaIdle;
    }

    @Deprecated
    public boolean isOperaQuit() {
        return this.operaQuit;
    }

    @Deprecated
    public boolean isOperaRestart() {
        return this.operaRestart;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean isRemoteReusable() {
        return this.remoteReusable;
    }

    @Deprecated
    public boolean isUseJavaScript() {
        return this.useJavaScript;
    }

    @Deprecated
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Deprecated
    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public void setBrowserCapabilities(String browserCapabilities) {
        this.browserCapabilities = browserCapabilities;
    }

    @Deprecated
    public void setBrowserVersionNumeric(float browserVersionNumeric) {
        this.browserVersionNumeric = browserVersionNumeric;
    }

    @Deprecated
    public void setChromeBinary(String chromeBinary) {
        this.chromeBinary = chromeBinary;
    }

    public void setChromeDriverBinary(String chromeDriverBinary) {
        this.chromeDriverBinary = chromeDriverBinary;
    }

    @Deprecated
    public void setChromeSwitches(String chromeSwitches) {
        this.chromeSwitches = chromeSwitches;
    }

    @Deprecated
    public void setFirefoxBinary(String firefoxBinary) {
        this.firefoxBinary = firefoxBinary;
    }

    @Deprecated
    public void setFirefoxProfile(String firefoxProfile) {
        this.firefoxProfile = firefoxProfile;
    }

    public void setIePort(int iePort) {
        this.iePort = iePort;
    }

    @Deprecated
    public void setImplementationClass(String implementationClass) {
        this.implementationClass = implementationClass;
    }

    @Deprecated
    public void setOperaArguments(String operaArguments) {
        this.operaArguments = operaArguments;
    }

    @Deprecated
    public void setOperaAutostart(boolean operaAutostart) {
        this.operaAutostart = operaAutostart;
    }

    @Deprecated
    public void setOperaBinary(String operaBinary) {
        this.operaBinary = operaBinary;
    }

    @Deprecated
    public void setOperaDisplay(int operaDisplay) {
        this.operaDisplay = operaDisplay;
    }

    @Deprecated
    public void setOperaIdle(boolean operaIdle) {
        this.operaIdle = operaIdle;
    }

    @Deprecated
    public void setOperaLauncher(String operaLauncher) {
        this.operaLauncher = operaLauncher;
    }

    @Deprecated
    public void setOperaLoggingFile(String operaLoggingFile) {
        this.operaLoggingFile = operaLoggingFile;
    }

    @Deprecated
    public void setOperaLoggingLevel(String operaLoggingLevel) {
        this.operaLoggingLevel = operaLoggingLevel;
    }

    @Deprecated
    public void setOperaPort(int operaPort) {
        this.operaPort = operaPort;
    }

    @Deprecated
    public void setOperaProduct(String operaProduct) {
        this.operaProduct = operaProduct;
    }

    @Deprecated
    public void setOperaProfile(String operaProfile) {
        this.operaProfile = operaProfile;
    }

    @Deprecated
    public void setOperaQuit(boolean operaQuit) {
        this.operaQuit = operaQuit;
    }

    @Deprecated
    public void setOperaRestart(boolean operaRestart) {
        this.operaRestart = operaRestart;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public void setRemoteAddress(URL remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setRemoteReusable(boolean remoteReusable) {
        this.remoteReusable = remoteReusable;
    }

    @Deprecated
    public void setUseJavaScript(boolean useJavaScript) {
        this.useJavaScript = useJavaScript;
    }

    @Deprecated
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean isReuseCookies() {
        return this.reuseCookies;
    }

    public void setReuseCookies(boolean reuseCookies) {
        this.reuseCookies = reuseCookies;
    }

    static {
        try {
            DEFAULT_REMOTE_URL = new URL("http://localhost:14444/wd/hub");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        DEFAULT_BROWSER_CAPABILITIES = new BrowserCapabilitiesList.HtmlUnit().getReadableName();
    }
}

