/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.Validate;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilities;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilitiesRegistry;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractWebDriverFactory<T extends WebDriver>
implements Configurator<T, WebDriverConfiguration> {
    private static final Logger log = Logger.getLogger(AbstractWebDriverFactory.class.getName());
    @Inject
    protected Instance<BrowserCapabilitiesRegistry> registryInstance;

    AbstractWebDriverFactory() {
    }

    protected abstract String getDriverReadableName();

    public WebDriverConfiguration createConfiguration(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        BrowserCapabilitiesRegistry registry = (BrowserCapabilitiesRegistry)this.registryInstance.get();
        BrowserCapabilities browser = registry.getEntryFor(this.getDriverReadableName());
        DroneConfiguration configuration = new WebDriverConfiguration(browser).configure(descriptor, (Class)qualifier);
        if (browser == null && Validate.nonEmpty(configuration.getImplementationClass())) {
            browser = registry.getEntryByImplementationClassName(configuration.getImplementationClass());
            if (browser == null) {
                log.log(Level.FINE, "Available implementationClasses are {}", this.getAvailableImplementationClasses());
                throw new IllegalStateException(MessageFormat.format("Unable to initialize WebDriver instance. Please specify a browserCapabilities property instead of implementationClass {1}. Available options are: {0}", this.getAvailableBrowserCapabilities(), configuration.getImplementationClass()));
            }
            configuration.setBrowserCapabilitiesInternal(browser);
            log.log(Level.WARNING, "Please use browserCapability to specify browser type instead of implementationClass. Available options are: {0}", this.getAvailableBrowserCapabilities());
        }
        if (browser == null && Validate.nonEmpty(configuration.getBrowserCapabilities())) {
            browser = registry.getEntryFor(configuration.getBrowserCapabilities());
            if (browser == null) {
                throw new IllegalStateException(MessageFormat.format("Unable to initialize WebDriver instance. Please specify a valid browserCapabilities instead of {1}. Available options are: {0}", this.getAvailableBrowserCapabilities(), configuration.getBrowserCapabilities()));
            }
            configuration.setBrowserCapabilitiesInternal(browser);
        }
        if (browser == null) {
            browser = registry.getEntryFor(WebDriverConfiguration.DEFAULT_BROWSER_CAPABILITIES);
            log.log(Level.INFO, "Property \"browserCapabilities\" was not specified, using default value of {0}", WebDriverConfiguration.DEFAULT_BROWSER_CAPABILITIES);
            configuration.setBrowserCapabilitiesInternal(browser);
        }
        return configuration;
    }

    private String getAvailableBrowserCapabilities() {
        BrowserCapabilitiesRegistry registry = (BrowserCapabilitiesRegistry)this.registryInstance.get();
        StringBuilder sb = new StringBuilder();
        for (BrowserCapabilities browser : registry.getAllBrowserCapabilities()) {
            if (!Validate.nonEmpty(browser.getReadableName())) continue;
            sb.append(browser.getReadableName()).append(", ");
        }
        if (sb.lastIndexOf(", ") != -1) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    private String getAvailableImplementationClasses() {
        BrowserCapabilitiesRegistry registry = (BrowserCapabilitiesRegistry)this.registryInstance.get();
        StringBuilder sb = new StringBuilder();
        for (BrowserCapabilities browser : registry.getAllBrowserCapabilities()) {
            sb.append(browser.getImplementationClassName()).append(", ");
        }
        if (sb.lastIndexOf(", ") != -1) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }
}

