/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.factory.Validate;
import org.openqa.selenium.iphone.IPhoneDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPhoneDriverFactory
extends AbstractWebDriverFactory<IPhoneDriver>
implements Configurator<IPhoneDriver, WebDriverConfiguration>,
Instantiator<IPhoneDriver, WebDriverConfiguration>,
Destructor<IPhoneDriver> {
    private static final Logger log = Logger.getLogger(IPhoneDriverFactory.class.getName());
    private static final String BROWSER_CAPABILITIES = new BrowserCapabilitiesList.IPhone().getReadableName();

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(IPhoneDriver instance) {
        instance.quit();
    }

    public IPhoneDriver createInstance(WebDriverConfiguration configuration) {
        URL remoteAddress = configuration.getRemoteAddress();
        if (Validate.empty(remoteAddress)) {
            remoteAddress = WebDriverConfiguration.DEFAULT_REMOTE_URL;
            log.log(Level.INFO, "Property \"remoteAdress\" was not specified, using default value of {0}", WebDriverConfiguration.DEFAULT_REMOTE_URL);
        }
        Validate.isValidUrl(remoteAddress, "Remote address must be a valid url, " + remoteAddress);
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{URL.class}, new Object[]{remoteAddress}, IPhoneDriver.class);
    }

    @Override
    public WebDriverConfiguration createConfiguration(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        DroneConfiguration configuration = super.createConfiguration(descriptor, (Class)qualifier);
        if (!configuration.isRemote()) {
            configuration.setRemote(true);
            log.log(Level.FINE, "Forcing IPhoneDriver configuration to be remote-based.");
        }
        return configuration;
    }

    @Override
    protected String getDriverReadableName() {
        return BROWSER_CAPABILITIES;
    }
}

