/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory.remote.reusable;

import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.InitializationParametersMap;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.PersistReusedSessionsEvent;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusedSessionPernamentStorage;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusedSessionStore;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusedSessionStoreImpl;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;

public class ReusableRemoteWebDriverExtension {
    @Inject
    @SuiteScoped
    private InstanceProducer<ReusedSessionStore> storeInstance;
    @Inject
    @SuiteScoped
    private InstanceProducer<InitializationParametersMap> initParamsMapInstance;
    @Inject
    @ApplicationScoped
    private InstanceProducer<ReusedSessionPernamentStorage> pernamentStorage;
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    public void initialize(@Observes BeforeSuite event) {
        this.initializePernamentStorage();
        this.initializeStore();
    }

    private void initializePernamentStorage() {
        ReusedSessionPernamentStorage instance = (ReusedSessionPernamentStorage)((ServiceLoader)this.serviceLoader.get()).onlyOne(ReusedSessionPernamentStorage.class);
        this.pernamentStorage.set((Object)instance);
    }

    private void initializeStore() {
        ReusedSessionStore store = ((ReusedSessionPernamentStorage)this.pernamentStorage.get()).loadStore();
        if (store == null) {
            store = new ReusedSessionStoreImpl();
        }
        this.storeInstance.set((Object)store);
        this.initParamsMapInstance.set((Object)new InitializationParametersMap());
    }

    public void persistStore(@Observes PersistReusedSessionsEvent event) {
        ((ReusedSessionPernamentStorage)this.pernamentStorage.get()).writeStore((ReusedSessionStore)this.storeInstance.get());
    }
}

