/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory.remote.reusable;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.arquillian.drone.webdriver.factory.RemoteWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.SerializationUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.SessionId;

public class ReusedSession
implements Serializable {
    private static final long serialVersionUID = 4363274772718639918L;
    private static final Logger log = Logger.getLogger(RemoteWebDriverFactory.class.getName());
    private String opaqueKey;
    private Capabilities capabilities;

    ReusedSession(SessionId sessionId, Capabilities capabilities) {
        this.opaqueKey = sessionId.toString();
        this.capabilities = ReusedSession.createReusableCapabilities(capabilities);
    }

    public static ReusedSession createInstance(SessionId sessionId, Capabilities capabilities) {
        DesiredCapabilities reusableCapabilities = ReusedSession.createReusableCapabilities(capabilities);
        return new ReusedSession(sessionId, (Capabilities)reusableCapabilities);
    }

    public SessionId getSessionId() {
        return new SessionId(this.opaqueKey);
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    static DesiredCapabilities createReusableCapabilities(Capabilities driverCapabilities) {
        DesiredCapabilities capabilitiesForReuse = new DesiredCapabilities();
        for (Map.Entry capability : driverCapabilities.asMap().entrySet()) {
            String key = (String)capability.getKey();
            Object value = capability.getValue();
            if (value instanceof Serializable) {
                try {
                    SerializationUtils.serializeToBytes((Serializable)value);
                    capabilitiesForReuse.setCapability((String)capability.getKey(), capability.getValue());
                }
                catch (IOException e) {
                    String type = value != null ? value.getClass().getName() : null;
                    log.warning(String.format("The capability '%s' has unserializable value of type '%s' and value '%s' - cause: %s", key, type, value, e.getCause()));
                }
                continue;
            }
            String type = value != null ? value.getClass().getName() : null;
            log.warning(String.format("The capability '%s' has unserializable value of type '%s' and value '%s'", key, type, value));
        }
        return capabilitiesForReuse;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.capabilities == null ? 0 : this.capabilities.hashCode());
        result = 31 * result + (this.opaqueKey == null ? 0 : this.opaqueKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReusedSession other = (ReusedSession)obj;
        if (this.capabilities == null ? other.capabilities != null : !this.capabilities.equals(other.capabilities)) {
            return false;
        }
        return !(this.opaqueKey == null ? other.opaqueKey != null : !this.opaqueKey.equals(other.opaqueKey));
    }

    public String toString() {
        return "ReusedSession [opaqueKey=" + this.opaqueKey + ", capabilities=" + this.capabilities + "]";
    }
}

