/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.window;

import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.InstanceOrCallableInstance;
import org.jboss.arquillian.drone.spi.event.AfterDroneEnhanced;
import org.jboss.arquillian.drone.spi.event.AfterDroneInstantiated;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.window.Validate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowResizer {
    private static final Logger log = Logger.getLogger(WindowResizer.class.getName());
    static final String DIMENSIONS_CAPABILITY = "dimensions";
    static final Pattern DIMENSIONS_PATTERN = Pattern.compile("([0-9]+)x([0-9]+)");
    @Inject
    Instance<DroneContext> droneContext;

    public void resizeBrowserWindow(@Observes AfterDroneInstantiated event) {
        InstanceOrCallableInstance instance = event.getInstance();
        Class droneType = event.getDroneType();
        Class qualifier = event.getQualifier();
        Class<?> realInstanceClass = instance.asInstance(droneType).getClass();
        this.resizeWindow(instance, droneType, qualifier, realInstanceClass);
    }

    public void resizeBrowserWindow(@Observes AfterDroneEnhanced event) {
        InstanceOrCallableInstance instance = event.getInstance();
        Class droneType = event.getDroneType();
        Class qualifier = event.getQualifier();
        Class<?> realInstanceClass = instance.asInstance(droneType).getClass();
        this.resizeWindow(instance, droneType, qualifier, realInstanceClass);
    }

    private void resizeWindow(InstanceOrCallableInstance instance, Class<?> droneType, Class<? extends Annotation> qualifier, Class<?> realInstanceClass) {
        Matcher m;
        if (!WebDriver.class.isAssignableFrom(realInstanceClass)) {
            return;
        }
        Object browser = instance.asInstance(droneType);
        WebDriver driver = (WebDriver)browser;
        try {
            driver.manage().window();
        }
        catch (UnsupportedOperationException e) {
            log.log(Level.WARNING, "Ignoring request to resize browser window for {0} @{1}, not supported for {2}", new Object[]{droneType.getSimpleName(), qualifier.getSimpleName(), realInstanceClass.getName()});
            return;
        }
        Validate.stateNotNull(this.droneContext.get(), "DroneContext must not be null");
        InstanceOrCallableInstance configurationInstance = ((DroneContext)this.droneContext.get()).get(WebDriverConfiguration.class, qualifier);
        Validate.stateNotNull(configurationInstance, "WebDriver configuration must not be null");
        WebDriverConfiguration configuration = (WebDriverConfiguration)configurationInstance.asInstance(WebDriverConfiguration.class);
        Validate.stateNotNull(configuration, "WebDriver configuration must not be null");
        Capabilities capabilities = configuration.getCapabilities();
        Validate.stateNotNull(capabilities, "WebDriver capabilities must not be null");
        String dimensions = (String)capabilities.getCapability(DIMENSIONS_CAPABILITY);
        if (dimensions != null && (m = DIMENSIONS_PATTERN.matcher(dimensions)).matches()) {
            int width = Integer.valueOf(m.group(1));
            int height = Integer.valueOf(m.group(2));
            driver.manage().window().setSize(new Dimension(width, height));
        }
    }
}

