/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.window;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.InjectionPoint;
import org.jboss.arquillian.drone.spi.event.AfterDroneEnhanced;
import org.jboss.arquillian.drone.spi.event.AfterDroneInstantiated;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.window.Validate;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowResizer {
    private static final Logger log = Logger.getLogger(WindowResizer.class.getName());
    static final Pattern DIMENSIONS_PATTERN = Pattern.compile("([0-9]+)x([0-9]+)");
    @Inject
    Instance<DroneContext> droneContext;

    public void resizeBrowserWindow(@Observes AfterDroneInstantiated event) {
        Object drone = event.getDrone();
        InjectionPoint injectionPoint = event.getInjectionPoint();
        this.resizeWindow(drone, injectionPoint);
    }

    public void resizeBrowserWindow(@Observes AfterDroneEnhanced event) {
        Object drone = event.getDrone();
        InjectionPoint injectionPoint = event.getInjectionPoint();
        this.resizeWindow(drone, injectionPoint);
    }

    private void resizeWindow(Object drone, InjectionPoint<?> injectionPoint) {
        Matcher m;
        if (!WebDriver.class.isAssignableFrom(drone.getClass())) {
            return;
        }
        DroneContext context = (DroneContext)this.droneContext.get();
        WebDriver driver = (WebDriver)drone;
        Validate.stateNotNull(context, "DroneContext must not be null");
        WebDriverConfiguration configuration = (WebDriverConfiguration)context.getDroneConfiguration(injectionPoint, WebDriverConfiguration.class);
        Validate.stateNotNull(configuration, "WebDriver configuration must not be null");
        String dimensions = configuration.getDimensions();
        if (dimensions != null && (m = DIMENSIONS_PATTERN.matcher(dimensions)).matches()) {
            int width = Integer.valueOf(m.group(1));
            int height = Integer.valueOf(m.group(2));
            this.safelyResizeWindow(driver, width, height, injectionPoint);
        }
    }

    private void safelyResizeWindow(WebDriver driver, int width, int height, InjectionPoint<?> injectionPoint) {
        try {
            driver.manage().window().setSize(new Dimension(width, height));
        }
        catch (WebDriverException e) {
            this.logRequestIgnored(driver, width, height, injectionPoint);
        }
        catch (UnsupportedOperationException e) {
            this.logRequestIgnored(driver, width, height, injectionPoint);
        }
    }

    private void logRequestIgnored(WebDriver driver, int width, int height, InjectionPoint<?> injectionPoint) {
        log.log(Level.WARNING, "Ignoring request to resize browser window to {3}x{4} for {0} @{1}, not supported for {2}", new Object[]{injectionPoint.getDroneType().getSimpleName(), injectionPoint.getQualifier().getSimpleName(), driver.getClass().getName(), width, height});
    }
}

