/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.io.File;
import java.io.IOException;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.factory.Validate;
import org.jboss.arquillian.phantom.resolver.ResolvingPhantomJSDriverService;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriverService;
import org.openqa.selenium.remote.DesiredCapabilities;

public class PhantomJSDriverFactory
extends AbstractWebDriverFactory<PhantomJSDriver>
implements Configurator<PhantomJSDriver, WebDriverConfiguration>,
Instantiator<PhantomJSDriver, WebDriverConfiguration>,
Destructor<PhantomJSDriver> {
    private static final String PHANTOMJS_EXECUTABLE_PATH = "phantomjs.binary.path";
    private static final String BROWSER_CAPABILITIES = new BrowserCapabilitiesList.PhantomJS().getReadableName();

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(PhantomJSDriver instance) {
        instance.quit();
    }

    public PhantomJSDriver createInstance(WebDriverConfiguration configuration) {
        DesiredCapabilities capabilities = new DesiredCapabilities(configuration.getCapabilities());
        String executablePath = (String)capabilities.getCapability(PHANTOMJS_EXECUTABLE_PATH);
        if (Validate.empty(executablePath)) {
            executablePath = SecurityActions.getProperty(PHANTOMJS_EXECUTABLE_PATH);
        }
        if (Validate.empty(executablePath)) {
            capabilities.setCapability(PHANTOMJS_EXECUTABLE_PATH, new File("target/drone-phantomjs").getAbsolutePath());
        }
        try {
            return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{PhantomJSDriverService.class, Capabilities.class}, new Object[]{ResolvingPhantomJSDriverService.createDefaultService((Capabilities)capabilities), capabilities}, PhantomJSDriver.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create an instance of " + configuration.getImplementationClass() + ".", e);
        }
    }

    @Override
    protected String getDriverReadableName() {
        return BROWSER_CAPABILITIES;
    }
}

