/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.factory.Validate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ie.InternetExplorerDriver;

public class InternetExplorerDriverFactory
extends AbstractWebDriverFactory<InternetExplorerDriver>
implements Configurator<InternetExplorerDriver, WebDriverConfiguration>,
Instantiator<InternetExplorerDriver, WebDriverConfiguration>,
Destructor<InternetExplorerDriver> {
    private static final Logger log = Logger.getLogger(InternetExplorerDriverFactory.class.getName());
    public static final int DEFAULT_INTERNET_EXPLORER_PORT = 0;
    private static final String IE_DRIVER_BINARY_KEY = "webdriver.ie.driver";
    private static final String BROWSER_CAPABILITIES = new BrowserCapabilitiesList.InternetExplorer().getReadableName();

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(InternetExplorerDriver instance) {
        instance.quit();
    }

    public InternetExplorerDriver createInstance(WebDriverConfiguration configuration) {
        int port = configuration.getIePort();
        String driverBinary = configuration.getIeDriverBinary();
        if (Validate.empty(driverBinary)) {
            driverBinary = SecurityActions.getProperty(IE_DRIVER_BINARY_KEY);
        }
        if (Validate.nonEmpty(driverBinary)) {
            Validate.isExecutable(driverBinary, "Internet Explorer driver binary must point to an executable file, " + driverBinary);
            SecurityActions.setProperty(IE_DRIVER_BINARY_KEY, driverBinary);
        }
        if (port == 0) {
            return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{Capabilities.class}, new Object[]{configuration.getCapabilities()}, InternetExplorerDriver.class);
        }
        log.log(Level.FINE, "Creating InternetExplorerDriver bound to port {0}", port);
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{Integer.TYPE}, new Object[]{port}, InternetExplorerDriver.class);
    }

    @Override
    protected String getDriverReadableName() {
        return BROWSER_CAPABILITIES;
    }
}

