/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.binary.downloading.source;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.http.client.utils.URIBuilder;
import org.jboss.arquillian.drone.webdriver.binary.downloading.ExternalBinary;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.ExternalBinarySource;
import org.jboss.arquillian.drone.webdriver.utils.GitHubLastUpdateCache;
import org.jboss.arquillian.drone.webdriver.utils.HttpClient;
import org.jboss.arquillian.drone.webdriver.utils.Rfc2126DateTimeFormatter;

public abstract class GitHubSource
implements ExternalBinarySource {
    private static final String LATEST_URL = "/releases/latest";
    private static final String RELEASES_URL = "/releases";
    private static final Logger log = Logger.getLogger(GitHubSource.class.toString());
    private static final Gson gson = new Gson();
    private String tagNameKey = "tag_name";
    private String assetNameKey = "name";
    private String browserDownloadUrlKey = "browser_download_url";
    private String assetsKey = "assets";
    private final HttpClient httpClient;
    private final GitHubLastUpdateCache cache;
    private final String projectUrl;
    private final String uniqueKey;

    public GitHubSource(String organization, String project, HttpClient httpClient, GitHubLastUpdateCache gitHubLastUpdateCache) {
        this.httpClient = httpClient;
        this.projectUrl = String.format("https://api.github.com/repos/%s/%s", organization, project);
        this.uniqueKey = organization + "@" + project;
        this.cache = gitHubLastUpdateCache;
    }

    protected abstract String getExpectedFileNameRegex(String var1);

    @Override
    public ExternalBinary getLatestRelease() throws Exception {
        ExternalBinary binaryRelease;
        HttpClient.Response response = this.sentGetRequestWithPagination(this.projectUrl + LATEST_URL, 1, this.lastModificationHeader());
        if (response.hasPayload()) {
            JsonObject latestRelease = ((JsonElement)gson.fromJson(response.getPayload(), JsonElement.class)).getAsJsonObject();
            String tagName = latestRelease.get(this.tagNameKey).getAsString();
            binaryRelease = new ExternalBinary(tagName);
            binaryRelease.setUrl(this.findReleaseBinaryUrl(latestRelease, binaryRelease.getVersion()));
            this.cache.store(binaryRelease, this.uniqueKey, this.extractModificationDate(response));
        } else {
            binaryRelease = this.cache.load(this.uniqueKey, ExternalBinary.class);
        }
        return binaryRelease;
    }

    private Map<String, String> lastModificationHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("If-Modified-Since", this.cache.lastModificationOf(this.uniqueKey).withZoneSameInstant(ZoneId.of("GMT")).format(Rfc2126DateTimeFormatter.INSTANCE));
        System.out.println(headers);
        return headers;
    }

    private ZonedDateTime extractModificationDate(HttpClient.Response response) {
        String modificationDate = response.getHeader("Last-Modified");
        DateTimeFormatter dateTimeFormatter = Rfc2126DateTimeFormatter.INSTANCE;
        return ZonedDateTime.parse(modificationDate, dateTimeFormatter);
    }

    @Override
    public ExternalBinary getReleaseForVersion(String version) throws Exception {
        JsonArray releases = this.sentGetRequest(this.projectUrl + RELEASES_URL, Collections.emptyMap(), true).getAsJsonArray();
        if (releases != null) {
            for (JsonElement release : releases) {
                JsonObject releaseObject = release.getAsJsonObject();
                String releaseTagName = releaseObject.get(this.tagNameKey).getAsString();
                if (!version.equals(releaseTagName)) continue;
                ExternalBinary binaryRelease = new ExternalBinary(releaseTagName);
                binaryRelease.setUrl(this.findReleaseBinaryUrl(releaseObject, binaryRelease.getVersion()));
                return binaryRelease;
            }
            log.warning("There wasn't found any release for the version: " + version + " in the repository: " + this.projectUrl);
        }
        return null;
    }

    private String findReleaseBinaryUrl(JsonObject releaseObject, String version) throws Exception {
        JsonArray assets = releaseObject.get(this.assetsKey).getAsJsonArray();
        for (JsonElement asset : assets) {
            JsonObject assetJson = asset.getAsJsonObject();
            String name = assetJson.get(this.assetNameKey).getAsString();
            if (!name.matches(this.getExpectedFileNameRegex(version))) continue;
            return assetJson.get(this.browserDownloadUrlKey).getAsString();
        }
        return null;
    }

    private JsonElement sentGetRequest(String url, Map<String, String> headers, boolean withPagination) throws Exception {
        HttpClient.Response response = this.sentGetRequestWithPagination(url, 1, headers);
        JsonElement result = (JsonElement)gson.fromJson(response.getPayload(), JsonElement.class);
        if (result != null && result.isJsonArray()) {
            HttpClient.Response nextResponse;
            JsonArray page;
            JsonArray resultArray = result.getAsJsonArray();
            int i = 2;
            while ((page = (JsonArray)gson.fromJson((nextResponse = this.sentGetRequestWithPagination(url, i, headers)).getPayload(), JsonArray.class)).size() != 0) {
                resultArray.addAll(page);
                if (!withPagination) break;
                ++i;
            }
            return resultArray;
        }
        return result;
    }

    private HttpClient.Response sentGetRequestWithPagination(String url, int pageNumber, Map<String, String> headers) throws Exception {
        URI uri = new URIBuilder(url).setParameter("page", String.valueOf(pageNumber)).build();
        return this.httpClient.get(uri.toString(), headers);
    }
}

