/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.binary.handler;

import java.io.IOException;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.ExternalBinarySource;
import org.jboss.arquillian.drone.webdriver.binary.handler.AbstractBinaryHandler;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.utils.PropertySecurityAction;
import org.jboss.arquillian.drone.webdriver.utils.Validate;
import org.jboss.arquillian.phantom.resolver.ResolvingPhantomJSDriverService;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

public class PhantomJSDriverBinaryHandler
extends AbstractBinaryHandler {
    public static final String PHANTOMJS_BINARY_VERSION_PROPERTY = "phantomjsBinaryVersion";
    public static final String PHANTOMJS_BINARY_URL_PROPERTY = "phantomjsBinaryUrl";
    private DesiredCapabilities capabilities;

    public PhantomJSDriverBinaryHandler(DesiredCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public String checkAndSetBinary(boolean performExecutableValidations) {
        try {
            ResolvingPhantomJSDriverService.createDefaultService((Capabilities)this.capabilities);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return this.checkAndSetBinaryWithoutResolve();
    }

    public String checkAndSetBinaryWithoutResolve() {
        String executablePath = PropertySecurityAction.getProperty("phantomjs.binary.path");
        if (Validate.empty(executablePath)) {
            executablePath = (String)this.capabilities.getCapability("phantomjs.binary.path");
        }
        if (!Validate.empty(executablePath)) {
            PropertySecurityAction.setProperty("phantomjs.binary.path", executablePath);
        }
        return executablePath;
    }

    @Override
    protected String getBinaryProperty() {
        return null;
    }

    @Override
    public String getSystemBinaryProperty() {
        return "phantomjs.binary.path";
    }

    @Override
    protected String getArquillianCacheSubdirectory() {
        return new BrowserCapabilitiesList.PhantomJS().getReadableName();
    }

    @Override
    protected String getDesiredVersionProperty() {
        return PHANTOMJS_BINARY_VERSION_PROPERTY;
    }

    @Override
    protected String getUrlToDownloadProperty() {
        return PHANTOMJS_BINARY_URL_PROPERTY;
    }

    @Override
    protected ExternalBinarySource getExternalBinarySource() {
        return null;
    }

    @Override
    protected DesiredCapabilities getCapabilities() {
        return this.capabilities;
    }
}

