/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.binary.handler.OperaDriverBinaryHandler;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.CapabilitiesOptionsMapper;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.utils.PropertySecurityAction;
import org.jboss.arquillian.drone.webdriver.utils.Validate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.opera.OperaOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class OperaDriverFactory
extends AbstractWebDriverFactory<OperaDriver>
implements Configurator<OperaDriver, WebDriverConfiguration>,
Instantiator<OperaDriver, WebDriverConfiguration>,
Destructor<OperaDriver> {
    private static final String BROWSER_CAPABILITIES = new BrowserCapabilitiesList.Opera().getReadableName();
    private static final String OPERA_BINARY_KEY = "opera.binary";

    public int getPrecedence() {
        return 0;
    }

    public OperaDriver createInstance(WebDriverConfiguration configuration) {
        Capabilities operaCapabilities = this.getCapabilities(configuration, true);
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{Capabilities.class}, new Object[]{operaCapabilities}, OperaDriver.class);
    }

    public Capabilities getCapabilities(WebDriverConfiguration configuration, boolean performValidations) {
        DesiredCapabilities capabilities = new DesiredCapabilities(configuration.getCapabilities());
        new OperaDriverBinaryHandler(capabilities).checkAndSetBinary(performValidations);
        String binary = PropertySecurityAction.getProperty(OPERA_BINARY_KEY);
        if (Validate.empty(binary)) {
            binary = (String)capabilities.getCapability(OPERA_BINARY_KEY);
        }
        OperaOptions operaOptions = new OperaOptions();
        CapabilitiesOptionsMapper.mapCapabilities(operaOptions, capabilities, BROWSER_CAPABILITIES);
        if (Validate.nonEmpty(binary)) {
            if (performValidations) {
                Validate.isExecutable(binary, "Opera binary must point to an executable file, " + binary);
            }
            operaOptions.setBinary(binary);
        }
        capabilities.setCapability("operaOptions", (Object)operaOptions);
        return capabilities;
    }

    public void destroyInstance(OperaDriver instance) {
        instance.quit();
    }

    @Override
    protected String getDriverReadableName() {
        return BROWSER_CAPABILITIES;
    }
}

