/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.binary;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.commons.codec.digest.DigestUtils;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.task.archive.UntarTool;
import org.arquillian.spacelift.task.archive.UnzipTool;
import org.jboss.arquillian.drone.webdriver.utils.Constants;

public class BinaryFilesUtils {
    private static final Logger log = Logger.getLogger(BinaryFilesUtils.class.toString());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extract(File toExtract) throws Exception {
        String dir = BinaryFilesUtils.getMd5hash(toExtract);
        if (dir == null) {
            dir = UUID.randomUUID().toString();
        }
        File targetDir = Constants.DRONE_TARGET_DIRECTORY.resolve(dir).toFile();
        Logger logger = log;
        synchronized (logger) {
            if (!targetDir.exists() || targetDir.listFiles().length == 0) {
                targetDir.mkdirs();
                String filePath = toExtract.getAbsolutePath();
                log.info("Extracting zip file: " + toExtract + " to " + targetDir.getPath());
                if (filePath.endsWith(".zip")) {
                    ((UnzipTool)Spacelift.task((Object)toExtract, UnzipTool.class)).toDir(targetDir).execute().await();
                } else if (filePath.endsWith(".tar.gz")) {
                    ((UntarTool)Spacelift.task((Object)toExtract, UntarTool.class)).gzip(true).toDir(targetDir).execute().await();
                } else if (filePath.endsWith(".tar.bz2")) {
                    ((UntarTool)Spacelift.task((Object)toExtract, UntarTool.class)).bzip2(true).toDir(targetDir).execute().await();
                } else {
                    log.info("The file " + toExtract + " is not compressed by a format that is supported by Drone. Drone supported formats are .zip, .tar.gz, .tar.bz2. The file will be only copied");
                    targetDir.mkdirs();
                    Files.copy(toExtract.toPath(), targetDir.toPath().resolve(toExtract.getName()), StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
        return targetDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMd5hash(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            String string = DigestUtils.md5Hex((InputStream)fis);
            return string;
        }
        catch (IOException e) {
            log.warning("A problem occurred when md5 hash of a file " + file + " was being retrieved:\n" + e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.warning("A problem occurred when FileInputStream of a file " + file + "was being closed:\n" + e.getMessage());
                }
            }
        }
        return null;
    }
}

