/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.util.Map;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.DesiredCapabilities;

public class BrowserCapabilitiesList {

    public static class ChromeHeadless
    implements BrowserCapabilities {
        public String getReadableName() {
            return "chromeheadless";
        }

        public String getImplementationClassName() {
            return "org.openqa.selenium.chrome.ChromeDriver";
        }

        public Map<String, ?> getRawCapabilities() {
            return Capabilities.CHROME.asMap();
        }

        public int getPrecedence() {
            return 0;
        }
    }

    public static class PhantomJS
    implements BrowserCapabilities {
        public String getReadableName() {
            return "phantomjs";
        }

        public String getImplementationClassName() {
            return "org.openqa.selenium.phantomjs.PhantomJSDriver";
        }

        public Map<String, ?> getRawCapabilities() {
            return Capabilities.PHANTOM_JS.asMap();
        }

        public int getPrecedence() {
            return 0;
        }
    }

    public static class Safari
    implements BrowserCapabilities {
        public String getReadableName() {
            return "safari";
        }

        public String getImplementationClassName() {
            return "org.openqa.selenium.safari.SafariDriver";
        }

        public Map<String, ?> getRawCapabilities() {
            return Capabilities.SAFARI.asMap();
        }

        public int getPrecedence() {
            return 0;
        }
    }

    public static class Remote
    implements BrowserCapabilities {
        public String getReadableName() {
            return null;
        }

        public String getImplementationClassName() {
            return "org.openqa.selenium.remote.RemoteWebDriver";
        }

        public Map<String, ?> getRawCapabilities() {
            return null;
        }

        public int getPrecedence() {
            return 0;
        }
    }

    public static class Opera
    implements BrowserCapabilities {
        public String getImplementationClassName() {
            return "org.openqa.selenium.opera.OperaDriver";
        }

        public Map<String, ?> getRawCapabilities() {
            return Capabilities.OPERA.asMap();
        }

        public String getReadableName() {
            return "opera";
        }

        public int getPrecedence() {
            return 0;
        }
    }

    public static class InternetExplorer
    implements BrowserCapabilities {
        public String getImplementationClassName() {
            return "org.openqa.selenium.ie.InternetExplorerDriver";
        }

        public Map<String, ?> getRawCapabilities() {
            return Capabilities.IE.asMap();
        }

        public String getReadableName() {
            return "internetexplorer";
        }

        public int getPrecedence() {
            return 0;
        }
    }

    public static class HtmlUnit
    implements BrowserCapabilities {
        public String getImplementationClassName() {
            return "org.jboss.arquillian.drone.webdriver.htmlunit.DroneHtmlUnitDriver";
        }

        public Map<String, ?> getRawCapabilities() {
            return Capabilities.HTML_UNIT.asMap();
        }

        public String getReadableName() {
            return "htmlunit";
        }

        public int getPrecedence() {
            return 0;
        }
    }

    public static class Firefox
    implements BrowserCapabilities {
        public String getImplementationClassName() {
            return "org.openqa.selenium.firefox.FirefoxDriver";
        }

        public Map<String, ?> getRawCapabilities() {
            return Capabilities.FIREFOX.asMap();
        }

        public String getReadableName() {
            return "firefox";
        }

        public int getPrecedence() {
            return 0;
        }
    }

    public static class Edge
    implements BrowserCapabilities {
        public String getImplementationClassName() {
            return "org.openqa.selenium.edge.EdgeDriver";
        }

        public Map<String, ?> getRawCapabilities() {
            return Capabilities.EDGE.asMap();
        }

        public String getReadableName() {
            return "edge";
        }

        public int getPrecedence() {
            return 0;
        }
    }

    public static class Chrome
    implements BrowserCapabilities {
        public String getImplementationClassName() {
            return "org.openqa.selenium.chrome.ChromeDriver";
        }

        public Map<String, ?> getRawCapabilities() {
            return Capabilities.CHROME.asMap();
        }

        public String getReadableName() {
            return "chrome";
        }

        public int getPrecedence() {
            return 0;
        }
    }

    public static class Capabilities {
        public static DesiredCapabilities CHROME = new DesiredCapabilities(Browser.CHROME.browserName(), "", Platform.ANY);
        public static DesiredCapabilities EDGE = new DesiredCapabilities(Browser.EDGE.browserName(), "", Platform.ANY);
        public static DesiredCapabilities FIREFOX = new DesiredCapabilities(Browser.FIREFOX.browserName(), "", Platform.ANY);
        public static DesiredCapabilities HTML_UNIT = new DesiredCapabilities(Browser.HTMLUNIT.browserName(), "", Platform.ANY);
        public static DesiredCapabilities IE = new DesiredCapabilities(Browser.IE.browserName(), "", Platform.WINDOWS);
        public static DesiredCapabilities OPERA = new DesiredCapabilities(Browser.OPERA.browserName(), "", Platform.ANY);
        public static DesiredCapabilities SAFARI = new DesiredCapabilities(Browser.SAFARI.browserName(), "", Platform.MAC);
        public static DesiredCapabilities PHANTOM_JS = new DesiredCapabilities("phantomjs", "", Platform.ANY);
    }
}

