/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.binary.downloading.source;

import java.io.IOException;
import java.util.logging.Logger;
import org.jboss.arquillian.drone.webdriver.binary.downloading.ExternalBinary;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.ExternalBinarySource;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.MissingBinaryException;
import org.jboss.arquillian.drone.webdriver.utils.Architecture;
import org.jboss.arquillian.drone.webdriver.utils.HttpClient;
import org.jboss.arquillian.drone.webdriver.utils.StringUtils;

public abstract class UrlStorageSource
implements ExternalBinarySource {
    private Logger log = Logger.getLogger(UrlStorageSource.class.toString());
    private HttpClient httpClient;
    protected String nodeName;
    protected String fileName;
    protected String urlToLatestRelease;
    private String storageUrl;
    private String latestVersion;

    public UrlStorageSource(String nodeName, String fileName, String storageUrl, String urlToLatestRelease, HttpClient httpClient) {
        this.httpClient = httpClient;
        this.nodeName = nodeName;
        this.fileName = fileName;
        this.storageUrl = storageUrl;
        this.urlToLatestRelease = urlToLatestRelease;
    }

    public UrlStorageSource(String storageUrl, HttpClient httpClient) {
        this("Contents", "Key", storageUrl, null, httpClient);
    }

    public UrlStorageSource(String storageUrl, String urlToLatestRelease, HttpClient httpClient) {
        this("Contents", "Key", storageUrl, urlToLatestRelease, httpClient);
    }

    @Override
    public ExternalBinary getLatestRelease() throws Exception {
        return this.getLatestRelease("UTF-8");
    }

    protected ExternalBinary getLatestRelease(String charset) throws Exception {
        if (this.urlToLatestRelease != null) {
            this.latestVersion = this.getVersion(this.urlToLatestRelease, charset);
        }
        return this.getReleaseForVersion(this.latestVersion);
    }

    protected String getVersion(String versionUrl, String charset) throws IOException {
        return StringUtils.trimMultiline(this.httpClient.get(versionUrl, charset).getPayload());
    }

    @Override
    public ExternalBinary getReleaseForVersion(String requiredVersion) throws Exception {
        return this.getReleaseForVersion(requiredVersion, Architecture.AUTO_DETECT);
    }

    @Override
    public ExternalBinary getReleaseForVersion(String requiredVersion, Architecture architecture) throws Exception {
        String externalBinaryUrl = this.storageUrl + this.getFileNameRegexToDownload(requiredVersion, architecture);
        HttpClient.Response response = this.httpClient.get(externalBinaryUrl);
        if (response.getStatusCode() != 200) {
            this.log.warning("There wasn't found any binary on the url: " + externalBinaryUrl);
            throw new MissingBinaryException("There wasn't found any binary on the url: " + externalBinaryUrl);
        }
        return new ExternalBinary(requiredVersion, externalBinaryUrl);
    }
}

