/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jboss.arquillian.drone.webdriver.utils.PropertySecurityAction;

public class HttpClient {
    public static final String UTF_8 = "UTF-8";
    private final Logger log = Logger.getLogger(HttpClient.class.getName());

    public Response get(String url) throws IOException {
        return this.get(url, Collections.emptyMap(), UTF_8);
    }

    public Response get(String url, String charset) throws IOException {
        return this.get(url, Collections.emptyMap(), charset);
    }

    public Response get(String url, Map<String, String> headers) throws IOException {
        return this.get(url, headers, UTF_8);
    }

    public Response get(String url, Map<String, String> headers, String charset) throws IOException {
        try (CloseableHttpClient client = this.createHttpClient();){
            HttpGet request = new HttpGet(url);
            this.addHeaders(headers, request);
            String message = "Sending request: " + request + " with headers: " + Arrays.asList(request.getAllHeaders());
            this.log.log(PropertySecurityAction.isArquillianDebug() ? Level.INFO : Level.FINE, message);
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            Response response2 = Response.from((HttpResponse)response, charset);
            return response2;
        }
    }

    private CloseableHttpClient createHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.useSystemProperties();
        return httpClientBuilder.build();
    }

    private void addHeaders(Map<String, String> headers, HttpGet request) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            request.addHeader(header.getKey(), header.getValue());
        }
    }

    public static class Response {
        private int statusCode;
        private final String payload;
        private final Map<String, String> headers;

        public Response(int statusCode, String payload, Map<String, String> headers) {
            this.statusCode = statusCode;
            this.payload = payload;
            this.headers = headers;
        }

        public static Response from(HttpResponse response) throws IOException {
            return Response.from(response, HttpClient.UTF_8);
        }

        public static Response from(HttpResponse response, String charset) throws IOException {
            HttpEntity entity = response.getEntity();
            String payload = entity == null ? null : EntityUtils.toString((HttpEntity)entity, (String)charset);
            HashMap<String, String> headers = new HashMap<String, String>();
            for (Header header : response.getAllHeaders()) {
                headers.put(header.getName().toLowerCase(), header.getValue());
            }
            int statusCode = 0;
            if (response.getStatusLine() != null) {
                statusCode = response.getStatusLine().getStatusCode();
            }
            return new Response(statusCode, payload, headers);
        }

        public boolean hasPayload() {
            return this.payload != null && !this.payload.isEmpty();
        }

        public String getPayload() {
            return this.payload;
        }

        public String getHeader(String header) {
            return this.headers.get(header.toLowerCase());
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

