/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.window;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.event.AfterDroneInstantiated;
import org.jboss.arquillian.drone.spi.event.DroneEvent;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.window.Dimensions;
import org.jboss.arquillian.drone.webdriver.window.Validate;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class WindowResizer {
    private static final Logger log = Logger.getLogger(WindowResizer.class.getName());
    @Inject
    Instance<DroneContext> droneContext;

    public void resizeBrowserWindow(@Observes(precedence=-100) AfterDroneInstantiated event) {
        this.resizeWindow((DroneEvent)event);
    }

    private void resizeWindow(DroneEvent event) {
        DronePoint dronePoint = event.getDronePoint();
        if (!dronePoint.conformsTo(WebDriver.class)) {
            return;
        }
        DroneContext context = (DroneContext)this.droneContext.get();
        WebDriver driver = (WebDriver)context.get(dronePoint).getInstanceAs(WebDriver.class);
        Validate.stateNotNull(context, "DroneContext must not be null");
        WebDriverConfiguration configuration = (WebDriverConfiguration)context.get(dronePoint).getConfigurationAs(WebDriverConfiguration.class);
        Validate.stateNotNull(configuration, "WebDriver configuration must not be null");
        String browser = configuration.getBrowser().toLowerCase();
        if (!browser.equals("chromeheadless")) {
            Dimensions dimensions = new Dimensions(configuration);
            if (dimensions.isFullscreenSet()) {
                this.safelyMaximizeWindow(driver, dronePoint);
            } else if (dimensions.areDimensionsPositive()) {
                this.safelyResizeWindow(driver, dimensions.getWidth(), dimensions.getHeight(), dronePoint);
            }
        }
    }

    private void safelyResizeWindow(WebDriver driver, int width, int height, DronePoint<?> dronePoint) {
        try {
            driver.manage().window().setSize(new Dimension(width, height));
        }
        catch (UnsupportedOperationException | WebDriverException e) {
            log.log(Level.WARNING, "Ignoring request to resize browser window to {2}x{3} for {0}, not supported for {1}", new Object[]{dronePoint, driver.getClass().getName(), width, height});
        }
    }

    private void safelyMaximizeWindow(WebDriver driver, DronePoint<?> dronePoint) {
        try {
            driver.manage().window().maximize();
        }
        catch (UnsupportedOperationException | WebDriverException e) {
            log.log(Level.INFO, "Drone cannot automatically maximize browser window for {0}, not supported for {1}", new Object[]{dronePoint, driver.getClass().getName()});
        }
    }
}

