/*
 * JBoss, Home of Professional Open Source
 * Copyright 2012, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.arquillian.extension.guice.testsuite;

import com.google.inject.Binder;
import com.google.inject.Module;
import org.jboss.arquillian.extension.guice.testsuite.repository.EmployeeRepository;
import org.jboss.arquillian.extension.guice.testsuite.repository.impl.DefaultEmployeeRepository;
import org.jboss.arquillian.extension.guice.testsuite.service.EmployeeService;
import org.jboss.arquillian.extension.guice.testsuite.service.impl.DefaultEmployeeService;


/**
 * The employee module.
 *
 * @author <a href="mailto:jmnarloch@gmail.com">Jakub Narloch</a>
 */
public class EmployeeModule implements Module {

    /**
     * {@inheritDoc}
     */
    public void configure(Binder binder) {
        binder.bind(EmployeeRepository.class).to(DefaultEmployeeRepository.class);
        binder.bind(EmployeeService.class).to(DefaultEmployeeService.class);
    }
}
