/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.dbunit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ColumnsHolder {
    final List<String> global = new ArrayList<String>();
    final Map<String, List<String>> columnsPerTable = new HashMap<String, List<String>>();

    public ColumnsHolder(String[] columns) {
        for (String column : columns) {
            if (column.length() == 0) continue;
            if (!column.contains(".")) {
                this.global.add(column);
                continue;
            }
            this.splitTableAndColumn(column);
        }
    }

    private void splitTableAndColumn(String columnToExclude) {
        String[] splittedTableAndColumn = columnToExclude.split("\\.");
        if (splittedTableAndColumn.length != 2) {
            throw new IllegalArgumentException("Cannot associated table with column for [" + columnToExclude + "]. Expected format: 'tableName.columnName'");
        }
        String tableName = splittedTableAndColumn[0];
        List<String> tableColumns = this.columnsPerTable.get(tableName);
        if (tableColumns == null) {
            tableColumns = new ArrayList<String>();
            this.columnsPerTable.put(tableName, tableColumns);
        }
        tableColumns.add(splittedTableAndColumn[1]);
    }
}

