/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.dbunit;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.persistence.core.data.provider.ResourceProvider;
import org.jboss.arquillian.persistence.core.event.AfterPersistenceTest;
import org.jboss.arquillian.persistence.core.event.BeforePersistenceTest;
import org.jboss.arquillian.persistence.core.metadata.MetadataExtractor;
import org.jboss.arquillian.persistence.core.metadata.PersistenceExtensionFeatureResolver;
import org.jboss.arquillian.persistence.dbunit.configuration.DBUnitConfiguration;
import org.jboss.arquillian.persistence.dbunit.configuration.DBUnitConfigurationPropertyMapper;
import org.jboss.arquillian.persistence.dbunit.data.descriptor.DataSetResourceDescriptor;
import org.jboss.arquillian.persistence.dbunit.data.provider.DataSetProvider;
import org.jboss.arquillian.persistence.dbunit.data.provider.ExpectedDataSetProvider;
import org.jboss.arquillian.persistence.dbunit.dataset.DataSetRegister;
import org.jboss.arquillian.persistence.dbunit.exception.DBUnitConnectionException;
import org.jboss.arquillian.persistence.dbunit.exception.DBUnitInitializationException;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.annotation.TestScoped;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBUnitPersistenceTestLifecycleHandler {
    @Inject
    private Instance<DataSource> dataSourceInstance;
    @Inject
    private Instance<MetadataExtractor> metadataExtractorInstance;
    @Inject
    private Instance<DBUnitConfiguration> dbUnitConfigurationInstance;
    @Inject
    @ClassScoped
    private InstanceProducer<DatabaseConnection> databaseConnectionProducer;
    @Inject
    @TestScoped
    private InstanceProducer<DataSetRegister> dataSetRegisterProducer;
    @Inject
    private Instance<PersistenceExtensionFeatureResolver> persistenceExtensionFeatureResolverInstance;

    public void provideDatabaseConnectionAroundBeforePersistenceTest(@Observes(precedence=100000) EventContext<BeforePersistenceTest> context) {
        this.createDatabaseConnection();
        context.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDatabaseConnections(@Observes(precedence=100000) EventContext<AfterPersistenceTest> context) {
        try {
            context.proceed();
        }
        finally {
            this.closeDatabaseConnection();
        }
    }

    public void createDatasets(@Observes(precedence=1000) EventContext<BeforePersistenceTest> context) {
        ResourceProvider dataSetProvider;
        Method testMethod = ((BeforePersistenceTest)context.getEvent()).getTestMethod();
        PersistenceExtensionFeatureResolver persistenceExtensionFeatureResolver = (PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolverInstance.get();
        if (persistenceExtensionFeatureResolver.shouldSeedData()) {
            dataSetProvider = new DataSetProvider((MetadataExtractor)this.metadataExtractorInstance.get(), (DBUnitConfiguration)((Object)this.dbUnitConfigurationInstance.get()));
            this.createInitialDataSets(dataSetProvider.getDescriptorsDefinedFor(testMethod));
        }
        if (persistenceExtensionFeatureResolver.shouldVerifyDataAfterTest()) {
            dataSetProvider = new ExpectedDataSetProvider((MetadataExtractor)this.metadataExtractorInstance.get(), (DBUnitConfiguration)((Object)this.dbUnitConfigurationInstance.get()));
            this.createExpectedDataSets(dataSetProvider.getDescriptorsDefinedFor(testMethod));
        }
        context.proceed();
    }

    private void createDatabaseConnection() {
        if (this.databaseConnectionProducer.get() == null) {
            this.configureDatabaseConnection();
        }
    }

    private void configureDatabaseConnection() {
        try {
            DataSource dataSource = (DataSource)this.dataSourceInstance.get();
            String schema = ((DBUnitConfiguration)((Object)this.dbUnitConfigurationInstance.get())).getSchema();
            DatabaseConnection databaseConnection = this.createDatabaseConnection(dataSource, schema);
            this.databaseConnectionProducer.set((Object)databaseConnection);
            DatabaseConfig dbUnitConfig = databaseConnection.getConfig();
            dbUnitConfig.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new DefaultDataTypeFactory());
            Map<String, Object> properties = new DBUnitConfigurationPropertyMapper().map((DBUnitConfiguration)((Object)this.dbUnitConfigurationInstance.get()));
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                dbUnitConfig.setProperty(property.getKey(), property.getValue());
            }
        }
        catch (Exception e) {
            throw new DBUnitInitializationException("Unable to initialize database connection for DBUnit module.", e);
        }
    }

    public DatabaseConnection createDatabaseConnection(DataSource dataSource, String schema) throws DatabaseUnitException, SQLException {
        DatabaseConnection databaseConnection = schema != null && schema.length() > 0 ? new DatabaseConnection(dataSource.getConnection(), schema) : new DatabaseConnection(dataSource.getConnection());
        return databaseConnection;
    }

    private void closeDatabaseConnection() {
        try {
            Connection connection = ((DatabaseConnection)this.databaseConnectionProducer.get()).getConnection();
            if (!connection.isClosed()) {
                connection.close();
            }
        }
        catch (Exception e) {
            throw new DBUnitConnectionException("Unable to close connection.", e);
        }
    }

    private void createInitialDataSets(Collection<DataSetResourceDescriptor> dataSetDescriptors) {
        DataSetRegister dataSetRegister = this.getOrCreateDataSetRegister();
        for (DataSetResourceDescriptor dataSetDescriptor : dataSetDescriptors) {
            dataSetRegister.addInitial(dataSetDescriptor.getContent());
        }
        this.dataSetRegisterProducer.set((Object)dataSetRegister);
    }

    private void createExpectedDataSets(Collection<DataSetResourceDescriptor> dataSetDescriptors) {
        DataSetRegister dataSetRegister = this.getOrCreateDataSetRegister();
        for (DataSetResourceDescriptor dataSetDescriptor : dataSetDescriptors) {
            dataSetRegister.addExpected(dataSetDescriptor.getContent());
        }
        this.dataSetRegisterProducer.set((Object)dataSetRegister);
    }

    private DataSetRegister getOrCreateDataSetRegister() {
        DataSetRegister dataSetRegister = (DataSetRegister)this.dataSetRegisterProducer.get();
        if (dataSetRegister == null) {
            dataSetRegister = new DataSetRegister();
        }
        return dataSetRegister;
    }
}

