/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.dbunit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.dbunit.Assertion;
import org.dbunit.DatabaseUnitException;
import org.dbunit.assertion.DiffCollectingFailureHandler;
import org.dbunit.assertion.Difference;
import org.dbunit.assertion.FailureHandler;
import org.dbunit.dataset.CompositeTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.FilteredTableMetaData;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.SortedTable;
import org.dbunit.dataset.filter.DefaultColumnFilter;
import org.dbunit.dataset.filter.IColumnFilter;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.filter.IncludeTableFilter;
import org.jboss.arquillian.persistence.core.test.AssertionErrorCollector;
import org.jboss.arquillian.persistence.dbunit.ColumnsHolder;
import org.jboss.arquillian.persistence.dbunit.DataSetUtils;
import org.jboss.arquillian.persistence.dbunit.dataset.TableWrapper;
import org.jboss.arquillian.persistence.dbunit.exception.DBUnitDataSetHandlingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetComparator {
    private static final String DIFF_ERROR = "%s | In row %d: expected value of %s \"%s\" but was \"%s\".";
    private static final Logger log = Logger.getLogger(DataSetComparator.class.getName());
    final ColumnsHolder toExclude;
    final ColumnsHolder orderBy;
    final Set<Class<? extends IColumnFilter>> columnFilters;

    public DataSetComparator(String[] orderBy, String[] toExclude, Set<Class<? extends IColumnFilter>> columnFilters) {
        this.toExclude = new ColumnsHolder(toExclude);
        this.orderBy = new ColumnsHolder(orderBy);
        this.columnFilters = columnFilters;
    }

    public void compare(IDataSet currentDataSet, IDataSet expectedDataSet, AssertionErrorCollector errorCollector) throws DatabaseUnitException {
        if (expectedDataSet.getTableNames().length == 0) {
            this.shouldBeEmpty(currentDataSet, errorCollector);
        } else {
            this.compareContent(currentDataSet, expectedDataSet, errorCollector);
        }
    }

    public void compareContent(IDataSet currentDataSet, IDataSet expectedDataSet, AssertionErrorCollector errorCollector) throws DatabaseUnitException {
        String[] tableNames = expectedDataSet.getTableNames();
        FilteredDataSet filteredCurrentDataSet = new FilteredDataSet((ITableFilter)new IncludeTableFilter(tableNames), currentDataSet);
        for (String tableName : tableNames) {
            List<String> columnsForSorting = this.defineColumnsForSorting((IDataSet)filteredCurrentDataSet, expectedDataSet, tableName);
            ITable expectedTable = this.sort((ITable)new TableWrapper(expectedDataSet.getTable(tableName), filteredCurrentDataSet.getTable(tableName).getTableMetaData()), columnsForSorting);
            ITable currentTable = this.sort(filteredCurrentDataSet.getTable(tableName), columnsForSorting);
            List<String> columnsToIgnore = this.extractColumnsToBeIgnored(expectedDataSet.getTable(tableName), filteredCurrentDataSet.getTable(tableName));
            DiffCollectingFailureHandler diffCollector = new DiffCollectingFailureHandler();
            ITable expectedTableWithFilteredColumns = this.filter(expectedTable, DataSetComparator.toStringArray(columnsToIgnore));
            ITable actualTableWithFilteredColumns = this.filter(currentTable, DataSetComparator.toStringArray(columnsToIgnore));
            Assertion.assertEquals((ITable)expectedTableWithFilteredColumns, (ITable)actualTableWithFilteredColumns, (FailureHandler)diffCollector);
            List diffs = diffCollector.getDiffList();
            this.collectErrors(errorCollector, diffs);
        }
    }

    public void shouldBeEmpty(IDataSet dataSet, AssertionErrorCollector errorCollector) throws DatabaseUnitException {
        String[] tableNames;
        for (String tableName : tableNames = dataSet.getTableNames()) {
            this.shouldBeEmpty(dataSet, tableName, errorCollector);
        }
    }

    public void shouldBeEmpty(IDataSet dataSet, String tableName, AssertionErrorCollector errorCollector) throws DataSetException {
        SortedTable tableState = new SortedTable(dataSet.getTable(tableName));
        int rowCount = tableState.getRowCount();
        if (rowCount != 0) {
            errorCollector.collect(new AssertionError((Object)(tableName + " expected to be empty, but was <" + rowCount + ">.")));
        }
    }

    private void collectErrors(AssertionErrorCollector errorCollector, List<Difference> diffs) {
        for (Difference diff : diffs) {
            String tableName = diff.getActualTable().getTableMetaData().getTableName();
            errorCollector.collect(String.format(DIFF_ERROR, tableName, diff.getRowIndex(), diff.getColumnName(), diff.getExpectedValue(), diff.getActualValue()));
        }
    }

    private ITable sort(ITable table, List<String> columnsForSorting) throws DataSetException {
        SortedTable sortedTable = new SortedTable(table, DataSetComparator.toStringArray(columnsForSorting));
        sortedTable.setUseComparable(true);
        return sortedTable;
    }

    private List<String> defineColumnsForSorting(IDataSet currentDataSet, IDataSet expectedDataSet, String tableName) throws DataSetException {
        ArrayList<String> columnsForSorting = new ArrayList<String>();
        columnsForSorting.addAll(this.orderBy.global);
        List<String> columsPerTable = this.orderBy.columnsPerTable.get(tableName);
        if (columsPerTable != null) {
            columnsForSorting.addAll(columsPerTable);
        }
        columnsForSorting.addAll(this.additionalColumnsForSorting(expectedDataSet.getTable(tableName), currentDataSet.getTable(tableName)));
        return columnsForSorting;
    }

    private static <T> String[] toStringArray(Collection<T> collection) {
        return collection.toArray(new String[collection.size()]);
    }

    private List<String> additionalColumnsForSorting(ITable expectedTableState, ITable currentTableState) {
        ArrayList<String> columnsForSorting = new ArrayList<String>();
        try {
            HashSet<String> allColumns = new HashSet<String>(DataSetUtils.extractColumnNames(expectedTableState.getTableMetaData().getColumns()));
            HashSet<String> columnsToIgnore = new HashSet<String>(this.extractColumnsToBeIgnored(expectedTableState, currentTableState));
            for (String column : allColumns) {
                if (columnsToIgnore.contains(column)) continue;
                columnsForSorting.add(column);
            }
        }
        catch (DataSetException e) {
            throw new DBUnitDataSetHandlingException("Unable to resolve columns", e);
        }
        return columnsForSorting;
    }

    private List<String> extractColumnsToBeIgnored(ITable expectedTableState, ITable currentTableState) throws DataSetException {
        List<String> nonExistingColumns;
        List<String> columnsToIgnore = DataSetUtils.extractColumnsNotSpecifiedInExpectedDataSet(expectedTableState, currentTableState);
        String tableName = expectedTableState.getTableMetaData().getTableName();
        List<String> tableColumns = this.toExclude.columnsPerTable.get(tableName);
        columnsToIgnore.addAll(this.toExclude.global);
        if (tableColumns != null) {
            columnsToIgnore.addAll(tableColumns);
        }
        if (!(nonExistingColumns = DataSetUtils.extractNonExistingColumns(columnsToIgnore, DataSetUtils.extractColumnNames(currentTableState.getTableMetaData().getColumns()))).isEmpty()) {
            log.warning("Columns which are specified to be filtered out " + Arrays.toString(nonExistingColumns.toArray()) + " are not existing in the table " + tableName);
        }
        return columnsToIgnore;
    }

    private ITable filter(ITable table, String[] columnsToFilter) throws DataSetException {
        ITable filteredTable = DefaultColumnFilter.excludedColumnsTable((ITable)table, (String[])columnsToFilter);
        return this.applyCustomFilters(filteredTable);
    }

    private ITable applyCustomFilters(ITable table) {
        for (Class<? extends IColumnFilter> columnFilter : this.columnFilters) {
            try {
                IColumnFilter customColumnFilter = columnFilter.newInstance();
                FilteredTableMetaData metaData = new FilteredTableMetaData(table.getTableMetaData(), customColumnFilter);
                table = new CompositeTable((ITableMetaData)metaData, table);
            }
            catch (Exception e) {
                throw new DBUnitDataSetHandlingException("Unable to initialize custom column filters", e);
            }
        }
        return table;
    }
}

